/*
 * Decompiled with CFR 0.152.
 */
package org.python27.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.python27.Version;
import org.python27.core.PrePy;
import org.python27.core.Py;
import org.python27.core.PyException;
import org.python27.core.PyObject;
import org.python27.core.PyString;
import org.python27.core.PySystemState;
import org.python27.util.Generic;
import org.python27.util.PythonInterpreter;

public class PyServlet
extends HttpServlet {
    protected static final Logger logger = Logger.getLogger("org.python27.servlet");
    public static final String SKIP_INIT_NAME = "skip_jython_initialization";
    protected static final String INIT_ATTR = "__jython_initialized__";
    private static final Pattern FIND_NAME = Pattern.compile("([^/]+)\\.py$");
    private PythonInterpreter interp;
    private Map<String, CacheEntry> cache = Generic.map();

    public void init() {
        boolean initialize;
        logger.log(Level.INFO, "Jython {0} servlet {1}", new Object[]{Version.PY_VERSION, this.getServletName()});
        Properties props = new Properties();
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.put(name, this.getInitParameter(name));
        }
        boolean bl = initialize = this.getServletConfig().getInitParameter(SKIP_INIT_NAME) != null;
        if (this.getServletContext().getAttribute(INIT_ATTR) != null) {
            if (initialize) {
                logger.log(Level.WARNING, "Jython has already been initialized in this context. Not initializing for ''{0}''. Add {1} as an init param to this servlet''s configuration to indicate this is expected.", new Object[]{this.getServletName(), SKIP_INIT_NAME});
            }
        } else if (initialize) {
            PyServlet.init(props, this.getServletContext());
        }
        this.reset();
    }

    protected static void init(Properties props, ServletContext context) {
        String rootPath = PyServlet.getRootPath(context);
        context.setAttribute(INIT_ATTR, (Object)true);
        Properties baseProps = PrePy.getSystemProperties();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.put(name, context.getInitParameter(name));
        }
        if (props.getProperty("python.home") == null && baseProps.getProperty("python.home") == null) {
            props.put("python.home", rootPath + "WEB-INF" + File.separator + "lib");
        }
        PySystemState.initialize(baseProps, props, new String[0]);
        PySystemState.add_package("javax.servlet");
        PySystemState.add_package("javax.servlet.http");
        PySystemState.add_package("javax.servlet.jsp");
        PySystemState.add_package("javax.servlet.jsp.tagext");
        PySystemState.add_classdir(rootPath + "WEB-INF" + File.separator + "classes");
        PySystemState.add_extdir(rootPath + "WEB-INF" + File.separator + "lib", true);
    }

    protected static PythonInterpreter createInterpreter(ServletContext servletContext) {
        String rootPath = PyServlet.getRootPath(servletContext);
        PySystemState sys = new PySystemState();
        PythonInterpreter interp = new PythonInterpreter(Py.newStringMap(), sys);
        sys.path.append(new PyString(rootPath));
        String modulesDir = rootPath + "WEB-INF" + File.separator + "jython";
        sys.path.append(new PyString(modulesDir));
        return interp;
    }

    protected static String getRootPath(ServletContext context) {
        String rootPath = context.getRealPath("/");
        if (!rootPath.endsWith(File.separator)) {
            rootPath = rootPath + File.separator;
        }
        return rootPath;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        req.setAttribute("pyservlet", (Object)this);
        String spath = (String)req.getAttribute("javax.servlet.include.servlet_path");
        if (spath == null && ((spath = ((HttpServletRequest)req).getServletPath()) == null || spath.length() == 0)) {
            spath = ((HttpServletRequest)req).getPathInfo();
        }
        String rpath = this.getServletContext().getRealPath(spath);
        this.getServlet(rpath).service(req, res);
    }

    public void destroy() {
        super.destroy();
        this.destroyCache();
    }

    public void reset() {
        this.destroyCache();
        this.interp = PyServlet.createInterpreter(this.getServletContext());
    }

    private synchronized HttpServlet getServlet(String path) throws ServletException, IOException {
        CacheEntry entry = this.cache.get(path);
        if (entry == null || new File(path).lastModified() > entry.date) {
            return this.loadServlet(path);
        }
        return entry.servlet;
    }

    private HttpServlet loadServlet(String path) throws ServletException, IOException {
        File file = new File(path);
        HttpServlet servlet = PyServlet.createInstance(this.interp, file, HttpServlet.class);
        try {
            servlet.init(this.getServletConfig());
        }
        catch (PyException e) {
            throw new ServletException((Throwable)e);
        }
        this.cache.put(path, new CacheEntry(servlet, file.lastModified()));
        return servlet;
    }

    protected static <T> T createInstance(PythonInterpreter interp, File file, Class<T> type) throws ServletException {
        Matcher m = FIND_NAME.matcher(file.getName());
        if (!m.find()) {
            throw new ServletException("I can't guess the name of the class from " + file.getAbsolutePath());
        }
        String name = m.group(1);
        try {
            interp.set("__file__", file.getAbsolutePath());
            interp.execfile(file.getAbsolutePath());
            PyObject cls = interp.get(name);
            if (cls == null) {
                throw new ServletException("No callable (class or function) named " + name + " in " + file.getAbsolutePath());
            }
            PyObject pyServlet = cls.__call__();
            Object o = pyServlet.__tojava__(type);
            if (o == Py.NoConversion) {
                throw new ServletException("The value from " + name + " must extend " + type.getSimpleName());
            }
            Object asT = o;
            return (T)asT;
        }
        catch (PyException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void destroyCache() {
        for (CacheEntry entry : this.cache.values()) {
            entry.servlet.destroy();
        }
        this.cache.clear();
    }

    private static class CacheEntry {
        public long date;
        public HttpServlet servlet;

        CacheEntry(HttpServlet servlet, long date) {
            this.servlet = servlet;
            this.date = date;
        }
    }
}

