/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.model.oaipmh;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.model.oaipmh.Error;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.Request;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.xml.XmlWritable;
import org.dspace.xoai.xml.XmlWriter;

public class OAIPMH
implements XmlWritable {
    public static final String NAMESPACE_URI = "http://www.openarchives.org/OAI/2.0/";
    public static final String SCHEMA_LOCATION = "http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd";
    private Date responseDate = new Date();
    private List<Error> errors = new ArrayList<Error>();
    private Request request;
    private Verb verb;

    public Date getResponseDate() {
        return this.responseDate;
    }

    public Request getRequest() {
        return this.request;
    }

    public OAIPMH withResponseDate(Date responseDate) {
        this.responseDate = responseDate;
        return this;
    }

    public OAIPMH withRequest(Request request) {
        this.request = request;
        return this;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public OAIPMH withError(Error error) {
        this.errors.add(error);
        return this;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Verb getVerb() {
        return this.verb;
    }

    public OAIPMH withVerb(Verb verb) {
        this.verb = verb;
        return this;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            writer.writeStartElement("OAI-PMH");
            writer.writeDefaultNamespace(NAMESPACE_URI);
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd");
            writer.writeElement("responseDate", this.responseDate, Granularity.Second);
            writer.writeElement("request", this.request);
            if (!this.errors.isEmpty()) {
                for (Error error : this.errors) {
                    writer.writeElement("error", error);
                }
            } else {
                if (this.verb == null) {
                    throw new XmlWriteException("An error or a valid response must be set");
                }
                writer.writeElement(this.verb.getType().displayName(), this.verb);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }
}

