/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.model.oaipmh;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.xml.XmlWritable;
import org.dspace.xoai.xml.XmlWriter;

public class Request
implements XmlWritable {
    private final String baseUrl;
    private String verbType;
    private String identifier;
    private String metadataPrefix;
    private Date from;
    private Date until;
    private String set;
    private String resumptionToken;
    private String fromString;
    private String untilString;

    public Request(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Verb.Type getVerbType() {
        return Verb.Type.fromValue(this.verbType);
    }

    public String getVerb() {
        return this.verbType;
    }

    public Request withVerbType(Verb.Type value) {
        this.verbType = value.displayName();
        return this;
    }

    public Request withVerbType(String verb) {
        this.verbType = verb;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Request withIdentifier(String value) {
        this.identifier = value;
        return this;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public Request withMetadataPrefix(String value) {
        this.metadataPrefix = value;
        return this;
    }

    public Date getFrom() {
        return this.from;
    }

    public Request withFrom(Date value) {
        this.from = value;
        return this;
    }

    public Date getUntil() {
        return this.until;
    }

    public Request withUntil(Date value) {
        this.until = value;
        return this;
    }

    public String getSet() {
        return this.set;
    }

    public Request withSet(String value) {
        this.set = value;
        return this;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public Request withResumptionToken(String value) {
        this.resumptionToken = value;
        return this;
    }

    public Request withFrom(String value) {
        this.fromString = value;
        return this;
    }

    public Request withUntil(String value) {
        this.untilString = value;
        return this;
    }

    @Override
    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            writer.writeAttribute("verb", this.verbType);
            writer.writeAttribute("identifier", this.identifier);
            writer.writeAttribute("metadataPrefix", this.metadataPrefix);
            if (this.from != null) {
                writer.writeAttribute("from", this.from);
            } else {
                writer.writeAttribute("from", this.fromString);
            }
            if (this.until != null) {
                writer.writeAttribute("until", this.until);
            } else {
                writer.writeAttribute("until", this.untilString);
            }
            writer.writeAttribute("set", this.set);
            writer.writeAttribute("resumptionToken", this.resumptionToken);
            writer.writeCharacters(this.baseUrl);
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }
}

