/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.model.xoai;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.XmlWritable;
import com.lyncode.xml.XmlWriter;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.exceptions.XmlWriteException;
import com.lyncode.xml.matchers.AttributeMatchers;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.model.xoai.Field;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class Element
implements XmlWritable {
    protected List<Field> fields = new ArrayList<Field>();
    protected String name;
    protected List<Element> elements = new ArrayList<Element>();

    public static Element parse(XmlReader reader) throws XmlReaderException {
        if (!reader.current(AllOf.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"element")))))) {
            throw new XmlReaderException("Invalid XML. Expecting entity 'element'");
        }
        if (!reader.hasAttribute(AttributeMatchers.attributeName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"name"))))) {
            throw new XmlReaderException("Invalid XML. Element entities must have a name");
        }
        Element element = new Element(reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"name"))));
        while (reader.next(new Matcher[]{XmlEventMatchers.anElement()}).current(XmlEventMatchers.aStartElement())) {
            if (reader.current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"element"))))) {
                element.withElement(Element.parse(reader));
                continue;
            }
            if (reader.current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"field"))))) {
                element.withField(Field.parse(reader));
                continue;
            }
            throw new XmlReaderException("Unexpected element");
        }
        if (!reader.current(AllOf.allOf((Matcher)XmlEventMatchers.anEndElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"element")))))) {
            throw new XmlReaderException("Invalid XML. Expecting end of entity 'element'");
        }
        return element;
    }

    public Element(String name) {
        this.name = name;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public Element withName(String value) {
        this.name = value;
        return this;
    }

    public Element withField(Field field) {
        this.fields.add(field);
        return this;
    }

    public Element withField(String name, String value) {
        this.fields.add(new Field(value, name));
        return this;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public Element withElement(Element element) {
        this.elements.add(element);
        return this;
    }

    public void write(XmlWriter writer) throws XmlWriteException {
        try {
            if (this.name != null) {
                writer.writeAttribute("name", this.getName());
            }
            for (Field field : this.getFields()) {
                writer.writeStartElement("field");
                field.write(writer);
                writer.writeEndElement();
            }
            for (Element element : this.getElements()) {
                writer.writeStartElement("element");
                element.write(writer);
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }
}

