/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dspace.xoai.model.xoai.Element;
import org.dspace.xoai.model.xoai.Field;
import org.dspace.xoai.model.xoai.XOAIMetadata;
import org.dspace.xoai.services.api.MetadataSearch;
import org.dspace.xoai.services.impl.AbstractMetadataSearcher;

public class MetadataSearchImpl
extends AbstractMetadataSearcher<String>
implements MetadataSearch<String> {
    public MetadataSearchImpl(XOAIMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void consume(List<String> newNames, Element element) {
        ArrayList<String> names = new ArrayList<String>(newNames);
        names.add(element.getName());
        if (!element.getFields().isEmpty()) {
            for (Field field : element.getFields()) {
                if (field.getName() != null && !field.getName().equals("value")) {
                    this.add(StringUtils.join(names, (String)".") + ":" + field.getName(), field.getValue());
                    continue;
                }
                this.add(StringUtils.join(names, (String)"."), field.getValue());
            }
        }
        if (!element.getElements().isEmpty()) {
            for (Element subElement : element.getElements()) {
                this.consume(names, subElement);
            }
        }
    }

    private void add(String name, String value) {
        if (!this.index.containsKey(name)) {
            this.index.put(name, new ArrayList());
        }
        ((List)this.index.get(name)).add(value);
    }

    @Override
    public String findOne(String xoaiPath) {
        return (String)super.findOne(xoaiPath);
    }

    @Override
    public List<String> findAll(String xoaiPath) {
        return super.findAll(xoaiPath);
    }

    @Override
    public Map<String, List<String>> index() {
        return this.index;
    }
}

