/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.dspace.xoai.exceptions.InvalidResumptionTokenException;
import org.dspace.xoai.model.oaipmh.ResumptionToken;
import org.dspace.xoai.services.api.ResumptionTokenFormat;
import org.dspace.xoai.util.Base64Utils;

public class SimpleResumptionTokenFormat
implements ResumptionTokenFormat {
    @Override
    public ResumptionToken.Value parse(String resumptionToken) throws InvalidResumptionTokenException {
        String metadataPrefix;
        Date until;
        Date from;
        String set;
        int offset;
        block9: {
            if (resumptionToken == null) {
                return new ResumptionToken.Value();
            }
            offset = 0;
            set = null;
            from = null;
            until = null;
            metadataPrefix = null;
            if (resumptionToken == null || resumptionToken.trim().equals("")) {
                return new ResumptionToken.Value();
            }
            String s = Base64Utils.decode(resumptionToken);
            String[] pieces = s.split(Pattern.quote("|"));
            try {
                if (pieces.length > 0) {
                    offset = Integer.parseInt(pieces[0].substring(2));
                    if (pieces.length > 1 && (set = pieces[1].substring(2)) != null && set.equals("")) {
                        set = null;
                    }
                    if (pieces.length > 2) {
                        from = this.stringToDate(pieces[2].substring(2));
                    }
                    if (pieces.length > 3) {
                        until = this.stringToDate(pieces[3].substring(2));
                    }
                    if (pieces.length > 4 && (metadataPrefix = pieces[4].substring(2)) != null && metadataPrefix.equals("")) {
                        metadataPrefix = null;
                    }
                    break block9;
                }
                throw new InvalidResumptionTokenException();
            }
            catch (Exception ex) {
                throw new InvalidResumptionTokenException(ex);
            }
        }
        return new ResumptionToken.Value().withUntil(until).withFrom(from).withMetadataPrefix(metadataPrefix).withOffset(offset).withSetSpec(set);
    }

    @Override
    public String format(ResumptionToken.Value resumptionToken) {
        String s = "1:" + resumptionToken.getOffset();
        s = s + "|2:";
        if (resumptionToken.hasSetSpec()) {
            s = s + resumptionToken.getSetSpec();
        }
        s = s + "|3:";
        if (resumptionToken.hasFrom()) {
            s = s + this.dateToString(resumptionToken.getFrom());
        }
        s = s + "|4:";
        if (resumptionToken.hasUntil()) {
            s = s + this.dateToString(resumptionToken.getUntil());
        }
        s = s + "|5:";
        if (resumptionToken.hasMetadataPrefix()) {
            s = s + resumptionToken.getMetadataPrefix();
        }
        return Base64Utils.encode(s);
    }

    private String dateToString(Date date) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return formatDate.format(date);
    }

    private Date stringToDate(String string) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            return formatDate.parse(string);
        }
        catch (ParseException ex) {
            formatDate = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return formatDate.parse(string);
            }
            catch (ParseException ex1) {
                return null;
            }
        }
    }
}

