/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.xml;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.ResumptionToken;
import org.dspace.xoai.services.api.DateProvider;
import org.dspace.xoai.services.api.ResumptionTokenFormat;
import org.dspace.xoai.services.impl.SimpleResumptionTokenFormat;
import org.dspace.xoai.services.impl.UTCDateProvider;
import org.dspace.xoai.xml.XmlWritable;

public class XmlWriter
extends com.lyncode.xml.XmlWriter {
    private final DateProvider dateProvider = new UTCDateProvider();
    private final WriterContext writerContext;

    public static String toString(XmlWritable writable) throws XMLStreamException, XmlWriteException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter(outputStream, XmlWriter.defaultContext());
        writable.write(writer);
        writer.close();
        return outputStream.toString();
    }

    public static WriterContext defaultContext() {
        return new WriterContext(Granularity.Second, new SimpleResumptionTokenFormat());
    }

    public XmlWriter(OutputStream output) throws XMLStreamException {
        super(output);
        this.writerContext = XmlWriter.defaultContext();
    }

    public XmlWriter(OutputStream output, WriterContext writerContext) throws XMLStreamException {
        super(output);
        this.writerContext = writerContext;
    }

    public void writeDate(Date date) throws XmlWriteException {
        try {
            this.writeCharacters(this.dateProvider.format(date, this.writerContext.granularity));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeDate(Date date, Granularity granularity) throws XmlWriteException {
        try {
            this.writeCharacters(this.dateProvider.format(date, granularity));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeElement(String elementName, String elementValue) throws XmlWriteException {
        try {
            this.writeStartElement(elementName);
            this.writeCharacters(elementValue);
            this.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeElement(String elementName, XmlWritable writable) throws XmlWriteException {
        try {
            if (writable != null) {
                this.writeStartElement(elementName);
                writable.write(this);
                this.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeElement(String elementName, Date date, Granularity granularity) throws XmlWriteException {
        this.writeElement(elementName, this.dateProvider.format(date, granularity));
    }

    public void writeElement(String elementName, Date date) throws XmlWriteException {
        this.writeElement(elementName, this.dateProvider.format(date, this.writerContext.granularity));
    }

    public void writeAttribute(String name, Date date) throws XmlWriteException {
        try {
            this.writeAttribute(name, this.dateProvider.format(date, this.writerContext.granularity));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeAttribute(String name, Date value, Granularity granularity) throws XmlWriteException {
        try {
            this.writeAttribute(name, this.dateProvider.format(value, granularity));
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (value != null) {
            super.writeAttribute(localName, value);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if (text != null) {
            super.writeCharacters(text);
        }
    }

    public void write(XmlWritable writable) throws XmlWriteException {
        if (writable != null) {
            writable.write(this);
        }
    }

    public void write(ResumptionToken.Value value) throws XmlWriteException {
        try {
            if (!value.isEmpty()) {
                this.writeCharacters(this.writerContext.formatter.format(value));
            }
        }
        catch (XMLStreamException e) {
            throw new XmlWriteException((Throwable)e);
        }
    }

    public static class WriterContext {
        private Granularity granularity;
        private ResumptionTokenFormat formatter;

        public WriterContext(Granularity granularity, ResumptionTokenFormat formatter) {
            this.granularity = granularity;
            this.formatter = formatter;
        }
    }
}

