/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.ImagingDatabaseHelper;
import ch.systemsx.cisd.openbis.dss.etl.RelativeImageReference;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgAcquiredImageDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelStackDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbstractImageDatasetUploader {
    protected final IImagingQueryDAO dao;
    private static final long DUMMY_ID = 0L;

    protected AbstractImageDatasetUploader(IImagingQueryDAO dao) {
        this.dao = dao;
    }

    protected final void createImages(List<AcquiredSingleImage> images, ISpotProvider spotProvider, ImagingDatabaseHelper.ImagingChannelsMap channelsMap, long datasetId) {
        Map<ImgChannelStackDTO, List<AcquiredImageInStack>> stackImagesMap = this.makeStackImagesMap(images, spotProvider, datasetId);
        this.createImages(stackImagesMap, channelsMap, datasetId);
    }

    private Map<ImgChannelStackDTO, List<AcquiredImageInStack>> makeStackImagesMap(List<AcquiredSingleImage> images, ISpotProvider spotProvider, long datasetId) {
        HashMap<ImgChannelStackDTO, List<AcquiredImageInStack>> map = new HashMap<ImgChannelStackDTO, List<AcquiredImageInStack>>();
        HashSet<ImgChannelStackDTO> newChannelStacks = new HashSet<ImgChannelStackDTO>();
        for (AcquiredSingleImage image : images) {
            ImgChannelStackDTO stackDTO = this.getOrCreateStackDtoWithouId(image, spotProvider, datasetId, newChannelStacks);
            ArrayList<AcquiredImageInStack> stackImages = (ArrayList<AcquiredImageInStack>)map.get(stackDTO);
            if (stackImages == null) {
                stackImages = new ArrayList<AcquiredImageInStack>();
            }
            stackImages.add(AbstractImageDatasetUploader.makeAcquiredImageInStack(image));
            map.put(stackDTO, stackImages);
        }
        Set<ImgChannelStackDTO> channelStacks = map.keySet();
        this.setChannelStackIds(newChannelStacks);
        this.setChannelStackRepresentatives(channelStacks);
        this.dao.addChannelStacks(newChannelStacks);
        return map;
    }

    private void setChannelStackRepresentatives(Set<ImgChannelStackDTO> channelStacks) {
        Set<ImgChannelStackDTO> representatives = ChannelStackRepresentativesOracle.calculateRepresentatives(channelStacks);
        for (ImgChannelStackDTO channelStack : channelStacks) {
            boolean isRepresentative = representatives.contains(channelStack);
            channelStack.setRepresentative(isRepresentative);
        }
    }

    private void setChannelStackIds(Collection<ImgChannelStackDTO> channelStacks) {
        for (ImgChannelStackDTO channelStack : channelStacks) {
            if (channelStack.getId() != 0L) continue;
            channelStack.setId(this.dao.createChannelStackId());
        }
    }

    private static AcquiredImageInStack makeAcquiredImageInStack(AcquiredSingleImage image) {
        return new AcquiredImageInStack(image.getChannelCode(), image.getImageReference(), image.getThumbnailFilePathOrNull(), image.tryGetImageTransformerFactory());
    }

    private ImgChannelStackDTO getOrCreateStackDtoWithouId(AcquiredSingleImage image, ISpotProvider spotProvider, long datasetId, Collection<ImgChannelStackDTO> newChannelStacks) {
        Long spotId = spotProvider.tryGetSpotId(image);
        ImgChannelStackDTO newChannelStack = new ImgChannelStackDTO(0L, image.getTileRow(), image.getTileColumn(), datasetId, spotId, image.tryGetTimePoint(), image.tryGetDepth(), image.tryGetSeriesNumber(), false);
        List channelStacks = null;
        channelStacks = spotId != null ? this.dao.listChannelStacks(datasetId, spotId) : this.dao.listChannelStacks(datasetId);
        for (ImgChannelStackDTO channelStack : channelStacks) {
            if (!newChannelStack.equals(channelStack)) continue;
            return channelStack;
        }
        newChannelStacks.add(newChannelStack);
        return newChannelStack;
    }

    private void createImages(Map<ImgChannelStackDTO, List<AcquiredImageInStack>> stackImagesMap, ImagingDatabaseHelper.ImagingChannelsMap channelsMap, long datasetId) {
        ImagesToCreate imagesToCreate = new ImagesToCreate(new ArrayList<ImgImageDTO>(), new ArrayList<ImgAcquiredImageDTO>(), new ArrayList<ImgAcquiredImageDTO>());
        List acquiredImages = this.dao.listAllAcquiredImagesForDataSet(datasetId);
        HashMap<Long, ArrayList<ImgAcquiredImageDTO>> acquiredImagesInStacks = new HashMap<Long, ArrayList<ImgAcquiredImageDTO>>();
        for (ImgAcquiredImageDTO imgAcquiredImageDTO : acquiredImages) {
            ArrayList<ImgAcquiredImageDTO> acquiredImagesInStack = (ArrayList<ImgAcquiredImageDTO>)acquiredImagesInStacks.get(imgAcquiredImageDTO.getChannelStackId());
            if (acquiredImagesInStack == null) {
                acquiredImagesInStack = new ArrayList<ImgAcquiredImageDTO>();
                acquiredImagesInStacks.put(imgAcquiredImageDTO.getChannelStackId(), acquiredImagesInStack);
            }
            acquiredImagesInStack.add(imgAcquiredImageDTO);
        }
        for (Map.Entry entry : stackImagesMap.entrySet()) {
            long stackId = ((ImgChannelStackDTO)entry.getKey()).getId();
            this.addImagesToCreate(imagesToCreate, stackId, channelsMap, (List)entry.getValue(), (List)acquiredImagesInStacks.get(stackId));
        }
        this.dao.addImages(imagesToCreate.getImages());
        this.dao.addAcquiredImages(imagesToCreate.getAcquiredImages());
        this.dao.updateAcquiredImagesThumbnails(imagesToCreate.getAcquiredImagesToUpdate());
    }

    private void addImagesToCreate(ImagesToCreate imagesToCreate, long stackId, ImagingDatabaseHelper.ImagingChannelsMap channelsMap, List<AcquiredImageInStack> images, List<ImgAcquiredImageDTO> alreadyRegisteredImages) {
        List<ImgImageDTO> imageDTOs = imagesToCreate.getImages();
        List<ImgAcquiredImageDTO> acquiredImageDTOs = imagesToCreate.getAcquiredImages();
        for (AcquiredImageInStack image : images) {
            long channelTechId = channelsMap.getChannelId(image.getChannelCode());
            ImgAcquiredImageDTO alreadyRegisteredImage = null;
            if (alreadyRegisteredImages != null) {
                for (ImgAcquiredImageDTO alreadyRegisteredImageCandidate : alreadyRegisteredImages) {
                    if (alreadyRegisteredImageCandidate.getChannelId() != channelTechId) continue;
                    alreadyRegisteredImage = alreadyRegisteredImageCandidate;
                    break;
                }
            }
            if (alreadyRegisteredImage == null) {
                ImgImageDTO imageDTO = this.mkImageWithIdDTO(image.getImageFilePath());
                imageDTOs.add(imageDTO);
                ImgImageDTO thumbnailDTO = this.tryMkImageWithIdDTO(image.getThumbnailPathOrNull());
                Long thumbnailId = null;
                if (thumbnailDTO != null) {
                    thumbnailId = thumbnailDTO.getId();
                    imageDTOs.add(thumbnailDTO);
                }
                ImgAcquiredImageDTO acquiredImage = this.mkAcquiredImage(stackId, channelTechId, imageDTO.getId(), thumbnailId, image.getImageTransformerFactoryOrNull());
                acquiredImageDTOs.add(acquiredImage);
                continue;
            }
            if (alreadyRegisteredImage.getThumbnailId() != null) continue;
            ImgImageDTO thumbnailDTO = this.tryMkImageWithIdDTO(image.getThumbnailPathOrNull());
            Long thumbnailId = null;
            if (thumbnailDTO == null) continue;
            thumbnailId = thumbnailDTO.getId();
            imageDTOs.add(thumbnailDTO);
            alreadyRegisteredImage.setThumbnailId(thumbnailId);
            imagesToCreate.getAcquiredImagesToUpdate().add(alreadyRegisteredImage);
        }
    }

    private ImgAcquiredImageDTO mkAcquiredImage(long stackId, long channelTechId, long imageId, Long thumbnailId, IImageTransformerFactory transformerFactoryOrNull) {
        ImgAcquiredImageDTO acquiredImage = new ImgAcquiredImageDTO();
        acquiredImage.setImageId(imageId);
        acquiredImage.setThumbnailId(thumbnailId);
        acquiredImage.setChannelStackId(stackId);
        acquiredImage.setChannelId(channelTechId);
        acquiredImage.setImageTransformerFactory(transformerFactoryOrNull);
        return acquiredImage;
    }

    private ImgImageDTO tryMkImageWithIdDTO(RelativeImageReference imageReferenceOrNull) {
        if (imageReferenceOrNull == null) {
            return null;
        }
        return this.mkImageWithIdDTO(imageReferenceOrNull);
    }

    private ImgImageDTO mkImageWithIdDTO(RelativeImageReference imageReference) {
        ImgImageDTO dto = new ImgImageDTO(this.dao.createImageId(), imageReference.getImageRelativePath(), imageReference.tryGetImageID(), imageReference.tryGetColorComponent());
        return dto;
    }

    protected final long getOrCreateImageDataset(String datasetPermId, ImageDatasetInfo imageDatasetInfo, Long containerIdOrNull) {
        ImgImageDatasetDTO imageDataSet = this.dao.tryGetImageDatasetByPermId(datasetPermId);
        if (imageDataSet == null) {
            ImgImageDatasetDTO dataset = AbstractImageDatasetUploader.createImageDatasetDTO(datasetPermId, imageDatasetInfo, containerIdOrNull);
            long imageContainerDatasetId = this.dao.addImageDataset(dataset);
            return imageContainerDatasetId;
        }
        return imageDataSet.getId();
    }

    private static ImgImageDatasetDTO createImageDatasetDTO(String datasetPermId, ImageDatasetInfo imageDatasetInfo, Long containerIdOrNull) {
        ImageLibraryInfo imageLibrary = imageDatasetInfo.tryGetImageLibrary();
        String imageLibraryName = null;
        String imageReaderName = null;
        if (imageLibrary != null) {
            imageLibraryName = imageLibrary.getName();
            imageReaderName = imageLibrary.getReaderName();
        }
        return new ImgImageDatasetDTO(datasetPermId, imageDatasetInfo.getTileRows(), imageDatasetInfo.getTileColumns(), containerIdOrNull, imageDatasetInfo.hasImageSeries(), imageLibraryName, imageReaderName);
    }

    @Private
    static final class ChannelStackRepresentativesOracle {
        ChannelStackRepresentativesOracle() {
        }

        public static Set<ImgChannelStackDTO> calculateRepresentatives(Set<ImgChannelStackDTO> images) {
            Map<Long, List<ImgChannelStackDTO>> mapBySpot = ChannelStackRepresentativesOracle.createMapBySpot(images);
            Comparator<? super ImgChannelStackDTO> spotChannelStacksComparator = ChannelStackRepresentativesOracle.createChannelStacksComparator();
            for (List<ImgChannelStackDTO> spotChannelStacks : mapBySpot.values()) {
                Collections.sort(spotChannelStacks, spotChannelStacksComparator);
            }
            HashSet<ImgChannelStackDTO> representatives = new HashSet<ImgChannelStackDTO>();
            for (List<ImgChannelStackDTO> spotChannelStacks : mapBySpot.values()) {
                representatives.add(spotChannelStacks.get(0));
            }
            return representatives;
        }

        private static Comparator<? super ImgChannelStackDTO> createChannelStacksComparator() {
            return new Comparator<ImgChannelStackDTO>(){

                @Override
                public int compare(ImgChannelStackDTO o1, ImgChannelStackDTO o2) {
                    int cmp = this.compareNullable(o1.getRow(), o2.getRow());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = this.compareNullable(o1.getColumn(), o2.getColumn());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = this.compareNullable(o1.getT(), o2.getT());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = this.compareNullable(o1.getZ(), o2.getZ());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = this.compareNullable(o1.getSeriesNumber(), o2.getSeriesNumber());
                    return cmp;
                }

                private <T extends Comparable<T>> int compareNullable(T v1OrNull, T v2OrNull) {
                    if (v1OrNull == null) {
                        return v2OrNull == null ? 0 : -1;
                    }
                    return v2OrNull == null ? 1 : v1OrNull.compareTo(v2OrNull);
                }
            };
        }

        private static Map<Long, List<ImgChannelStackDTO>> createMapBySpot(Set<ImgChannelStackDTO> channelStacks) {
            HashMap<Long, List<ImgChannelStackDTO>> mapBySpot = new HashMap<Long, List<ImgChannelStackDTO>>();
            for (ImgChannelStackDTO channelStack : channelStacks) {
                Long spotId = channelStack.getSpotId();
                ArrayList<ImgChannelStackDTO> spotChannelStacks = (ArrayList<ImgChannelStackDTO>)mapBySpot.get(spotId);
                if (spotChannelStacks == null) {
                    spotChannelStacks = new ArrayList<ImgChannelStackDTO>();
                }
                spotChannelStacks.add(channelStack);
                mapBySpot.put(spotId, spotChannelStacks);
            }
            return mapBySpot;
        }
    }

    private static class ImagesToCreate {
        private final List<ImgImageDTO> images;
        private final List<ImgAcquiredImageDTO> acquiredImages;
        private final List<ImgAcquiredImageDTO> acquiredImagesToUpdate;

        public ImagesToCreate(List<ImgImageDTO> images, List<ImgAcquiredImageDTO> acquiredImages, List<ImgAcquiredImageDTO> acquiredImagesToUpdate) {
            this.images = images;
            this.acquiredImages = acquiredImages;
            this.acquiredImagesToUpdate = acquiredImagesToUpdate;
        }

        public List<ImgImageDTO> getImages() {
            return this.images;
        }

        public List<ImgAcquiredImageDTO> getAcquiredImages() {
            return this.acquiredImages;
        }

        public List<ImgAcquiredImageDTO> getAcquiredImagesToUpdate() {
            return this.acquiredImagesToUpdate;
        }
    }

    protected static interface ISpotProvider {
        public Long tryGetSpotId(AcquiredSingleImage var1);
    }

    protected static class AcquiredImageInStack {
        private final String channelCode;
        private final RelativeImageReference imageFilePath;
        private final RelativeImageReference thumbnailPathOrNull;
        private final IImageTransformerFactory imageTransformerFactoryOrNull;

        public AcquiredImageInStack(String channelCode, RelativeImageReference imageFilePath, RelativeImageReference thumbnailPathOrNull, IImageTransformerFactory imageTransformerFactoryOrNull) {
            this.channelCode = CodeNormalizer.normalize((String)channelCode);
            this.imageFilePath = imageFilePath;
            this.thumbnailPathOrNull = thumbnailPathOrNull;
            this.imageTransformerFactoryOrNull = imageTransformerFactoryOrNull;
        }

        public String getChannelCode() {
            return this.channelCode;
        }

        public RelativeImageReference getImageFilePath() {
            return this.imageFilePath;
        }

        public final RelativeImageReference getThumbnailPathOrNull() {
            return this.thumbnailPathOrNull;
        }

        public IImageTransformerFactory getImageTransformerFactoryOrNull() {
            return this.imageTransformerFactoryOrNull;
        }
    }
}

