/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueDecorator;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformationBuffer;
import ch.systemsx.cisd.openbis.dss.etl.jython.v1.SimpleImageDataSetRegistrator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingTransformerDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageEnrichedDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageTransformationDTO;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class ComputeIntensityLevelTransformationsMaintenanceTask
implements IMaintenanceTask {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ComputeIntensityLevelTransformationsMaintenanceTask.class);
    private static final String COMPUTE_MIN_MAX_LEVELS_KEY = "compute-min-max-levels";
    private static final String DEFAULT_COMPUTE_MIN_MAX_LEVELS = "true";
    private static final String MIN_LEVEL_KEY = "min-level";
    private static final String MAX_LEVEL_KEY = "max-level";
    private static final String INTENSITY_THRESHOLD_KEY = "intensity-threshold";
    private static final String TRASNFORMATION_CODE_KEY = "transformation-code";
    private static final String TRASNFORMATION_LABEL_KEY = "transformation-label";
    private static final String TRANSFORMATION_DESC_KEY = "transformation-description";
    private static final String IS_DEFAULT_TRANSFORMATION_KEY = "is-default-transformation";
    private static final String STATUS_FILENAME_KEY = "status-filename";
    private static final String BATCH_SIZE_KEY = "batch-size";
    private boolean computeMinMaxLevels;
    private int minLevel;
    private int maxLevel;
    private float intensityThreshold;
    private String transformationCode;
    private String transformationLabel;
    private String transformationDescription;
    private boolean isDefaultTransformation;
    private int batchSize;
    private File queueFile;
    private DataSource dataSource;
    private IImagingTransformerDAO dao;
    private IEncapsulatedOpenBISService service;
    private IHierarchicalContentProvider contentProvider;

    public void setUp(String pluginName, Properties properties) {
        this.dataSource = ServiceProvider.getDataSourceProvider().getDataSource(properties);
        this.dao = (IImagingTransformerDAO)QueryTool.getQuery((DataSource)this.dataSource, IImagingTransformerDAO.class);
        this.dao.listSpots(0L);
        this.service = ServiceProvider.getOpenBISService();
        this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        this.computeMinMaxLevels = Boolean.valueOf(properties.getProperty(COMPUTE_MIN_MAX_LEVELS_KEY, DEFAULT_COMPUTE_MIN_MAX_LEVELS));
        this.minLevel = PropertyUtils.getInt((Properties)properties, (String)MIN_LEVEL_KEY, (int)-1);
        this.maxLevel = PropertyUtils.getInt((Properties)properties, (String)MAX_LEVEL_KEY, (int)-1);
        if (!(this.computeMinMaxLevels || this.minLevel != -1 && this.maxLevel != -1)) {
            throw new ConfigurationFailureException("The intensity ranges levels must be correctly defined if calculating them is disabled.");
        }
        this.intensityThreshold = (float)PropertyUtils.getDouble((Properties)properties, (String)INTENSITY_THRESHOLD_KEY, (double)-1.0);
        if (this.computeMinMaxLevels && (this.intensityThreshold < 0.0f || this.intensityThreshold > 1.0f)) {
            throw new ConfigurationFailureException("The intensity-threshold property must be provided as a real number between 0 and 1 if the levels are calculated.");
        }
        this.transformationCode = PropertyUtils.getMandatoryProperty((Properties)properties, (String)TRASNFORMATION_CODE_KEY);
        this.transformationLabel = properties.getProperty(TRASNFORMATION_LABEL_KEY, "Fixed rescaling");
        this.transformationDescription = properties.getProperty(TRANSFORMATION_DESC_KEY, "Optimal intensity rescaling for a series of images. It allows to compare images of one plate's dataset to each other.At the same time it causes that the conversion to 8 bit color depth looses less information, especially when images use only a small part of available intensities range.");
        String isDefaultTransformationString = PropertyUtils.getMandatoryProperty((Properties)properties, (String)IS_DEFAULT_TRANSFORMATION_KEY);
        this.isDefaultTransformation = Boolean.valueOf(isDefaultTransformationString);
        String queueFilePath = PropertyUtils.getMandatoryProperty((Properties)properties, (String)STATUS_FILENAME_KEY);
        this.queueFile = new File(queueFilePath);
        this.batchSize = PropertyUtils.getInt((Properties)properties, (String)BATCH_SIZE_KEY, (int)1);
        if (this.batchSize < 1) {
            throw new ConfigurationFailureException("Batch size must be at least 1");
        }
    }

    public void execute() {
        PersistentExtendedBlockingQueueDecorator queue = PersistentExtendedBlockingQueueFactory.createSmartPersist((File)this.queueFile);
        try {
            this.executeTransformations((PersistentExtendedBlockingQueueDecorator<Long>)queue);
        }
        catch (Exception e) {
            operationLog.error((Object)e);
        }
        queue.close();
    }

    private void executeTransformations(PersistentExtendedBlockingQueueDecorator<Long> queue) {
        for (int i = 0; i < this.batchSize; ++i) {
            boolean result = this.executeOnce(queue);
            if (result) continue;
            return;
        }
    }

    private boolean executeOnce(PersistentExtendedBlockingQueueDecorator<Long> queue) {
        long lastSeenId = this.getLastSeenIDFromQueue(queue);
        Long nextId = this.dao.tryGetNextDatasetId(lastSeenId);
        if (nextId != null) {
            if (!this.dao.hasDatasetDefinedTransformation(nextId, this.transformationCode)) {
                this.executeTransformations(nextId);
            }
            this.storeLastSeenInTheQueue(queue, nextId);
            return true;
        }
        return false;
    }

    private void executeTransformations(long datasetId) {
        IntensityRescaling.Levels intensityRange;
        ImgImageDatasetDTO imageDataset = this.dao.tryGetImageDatasetById(datasetId);
        List channels = this.dao.getChannelsByDatasetId(datasetId);
        operationLog.info((Object)("Will create transformation " + this.transformationCode + " for the dataset " + imageDataset.getPermId()));
        if (this.computeMinMaxLevels) {
            intensityRange = this.computeIntensityRange(imageDataset, channels);
            if (intensityRange != null) {
                operationLog.info((Object)("Calculated intensity ranges for dataset " + imageDataset.getPermId() + ". " + intensityRange));
            }
        } else {
            intensityRange = new IntensityRescaling.Levels(this.minLevel, this.maxLevel);
            operationLog.info((Object)("Using default intensity range values " + intensityRange));
        }
        if (intensityRange != null) {
            IImageTransformerFactory factory = this.createImageTransformerFactory(intensityRange);
            for (ImgChannelDTO ch : channels) {
                this.addCommonIntensityRangeTransformation(ch, factory);
            }
            this.dao.commit();
            operationLog.info((Object)("Succesfully applied intensity ranges transformation to " + imageDataset.getPermId() + " on " + channels.size() + " channels."));
        } else {
            operationLog.warn((Object)("Could not calculate intensity ranges for dataset " + imageDataset.getPermId() + ". Will be skipped."));
        }
    }

    private IImageTransformerFactory createImageTransformerFactory(IntensityRescaling.Levels intensityRange) {
        ImageTransformationBuffer buffer = new ImageTransformationBuffer();
        ImageTransformation imageTransformation = buffer.appendRescaleGrayscaleIntensity(intensityRange.getMinLevel(), intensityRange.getMaxLevel(), "N/A");
        IImageTransformerFactory factory = imageTransformation.getImageTransformerFactory();
        return factory;
    }

    private IntensityRescaling.Levels computeIntensityRange(ImgImageDatasetDTO imageDataset, List<ImgChannelDTO> channels) {
        AbstractExternalData dataset = this.service.tryGetDataSet(imageDataset.getPermId());
        if (dataset == null) {
            operationLog.warn((Object)"The dataset specified in the image_data_set doesn't exist in openbis.");
            return null;
        }
        IHierarchicalContent content = this.contentProvider.asContent(dataset);
        LinkedList<File> imagePaths = new LinkedList<File>();
        for (ImgChannelDTO ch : channels) {
            List images = this.dao.listHCSImages(imageDataset.getPermId(), ch.getCode());
            for (ImgImageEnrichedDTO img : images) {
                File imageFile = content.getNode(img.getFilePath()).getFile();
                imagePaths.add(imageFile);
                if (imageFile.exists()) continue;
                throw new IllegalStateException("The image file for dataset " + imageDataset.getPermId() + " doesn't exist.");
            }
        }
        return SimpleImageDataSetRegistrator.tryComputeCommonIntensityRange(null, imagePaths, this.intensityThreshold);
    }

    private void addCommonIntensityRangeTransformation(ImgChannelDTO channel, IImageTransformerFactory factory) {
        ImgImageTransformationDTO dto = new ImgImageTransformationDTO(this.transformationCode, this.transformationLabel, this.transformationDescription, this.isDefaultTransformation, channel.getId(), factory, false);
        this.dao.addImageTransformation(dto);
    }

    private void storeLastSeenInTheQueue(PersistentExtendedBlockingQueueDecorator<Long> queue, long lastSeenId) {
        queue.offer((Serializable)Long.valueOf(lastSeenId));
        while (queue.size() > 1) {
            queue.remove();
        }
    }

    private long getLastSeenIDFromQueue(PersistentExtendedBlockingQueueDecorator<Long> queue) {
        long lastSeenId = -1L;
        if (queue.size() > 0) {
            lastSeenId = (Long)queue.peek();
        }
        return lastSeenId;
    }
}

