/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.openbis.dss.etl.AbstractImageDatasetUploader;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.HCSContainerDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.ImagingDatabaseHelper;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageZoomLevel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgSpotDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HCSImageDatasetUploader
extends AbstractImageDatasetUploader {
    public static void upload(IImagingQueryDAO dao, HCSImageDatasetInfo info, List<AcquiredSingleImage> images, List<Channel> channels) {
        new HCSImageDatasetUploader(dao).upload(info, images, channels);
    }

    private HCSImageDatasetUploader(IImagingQueryDAO dao) {
        super(dao);
    }

    private void upload(HCSImageDatasetInfo info, List<AcquiredSingleImage> images, List<Channel> channels) {
        long contId;
        ImagingDatabaseHelper.ImagingChannelsMap channelsMap = null;
        if (info.isStoreChannelsOnExperimentLevel()) {
            ImagingDatabaseHelper.ExperimentWithChannelsAndContainer basicStruct = ImagingDatabaseHelper.getOrCreateExperimentWithChannelsAndContainer(this.dao, info, channels);
            contId = basicStruct.getContainerId();
            channelsMap = basicStruct.getChannelsMap();
        } else {
            contId = ImagingDatabaseHelper.getOrCreateExperimentAndContainer(this.dao, info);
        }
        Long[][] spotIds = this.getOrCreateSpots(contId, info, images);
        AbstractImageDatasetUploader.ISpotProvider spotProvider = HCSImageDatasetUploader.getSpotProvider(spotIds);
        long datasetId = this.getOrCreateDataset(contId, info);
        if (!info.isStoreChannelsOnExperimentLevel()) {
            channelsMap = ImagingDatabaseHelper.getOrCreateDatasetChannels(this.dao, datasetId, channels);
        }
        assert (channelsMap != null);
        for (ImageZoomLevel imageZoomLevel : info.getImageDatasetInfo().getImageZoomLevels()) {
            long zoomLevelId = this.dao.addImageZoomLevel(this.convert(datasetId, imageZoomLevel));
            for (Map.Entry<String, String> entry : imageZoomLevel.getTransformation().entrySet()) {
                this.dao.addImageZoomLevelTransformation(zoomLevelId, channelsMap.getChannelId(entry.getKey()), entry.getValue());
            }
        }
        this.createImages(images, spotProvider, channelsMap, datasetId);
    }

    private ImgImageZoomLevelDTO convert(long imageContainerDatasetId, ImageZoomLevel imageZoomLevel) {
        return new ImgImageZoomLevelDTO(imageZoomLevel.getPhysicalDatasetPermId(), imageZoomLevel.isOriginal(), imageZoomLevel.getRootPath(), imageZoomLevel.getWidth(), imageZoomLevel.getHeight(), imageZoomLevel.getColorDepth(), imageZoomLevel.getFileType(), imageContainerDatasetId);
    }

    private static AbstractImageDatasetUploader.ISpotProvider getSpotProvider(final Long[][] spotIds) {
        return new AbstractImageDatasetUploader.ISpotProvider(){

            @Override
            public Long tryGetSpotId(AcquiredSingleImage image) {
                return HCSImageDatasetUploader.findSpotId(image, spotIds);
            }
        };
    }

    private static long findSpotId(AcquiredSingleImage image, Long[][] spotIds) {
        int wellRow = image.getWellRow();
        int wellColumn = image.getWellColumn();
        Long spotId = spotIds[wellRow - 1][wellColumn - 1];
        assert (spotId != null) : "no spot for " + (Object)((Object)image);
        return spotId;
    }

    private Long[][] getOrCreateSpots(long contId, HCSContainerDatasetInfo info, List<AcquiredSingleImage> images) {
        List oldSpots = this.dao.listSpots(contId);
        List<ImgSpotDTO> newSpots = this.createNewSpots(contId, images, oldSpots, info.getContainerRows(), info.getContainerColumns(), info.getContainerSamplePermId());
        newSpots.addAll(oldSpots);
        return HCSImageDatasetUploader.makeTechIdMatrix(newSpots, info.getContainerRows(), info.getContainerColumns());
    }

    private List<ImgSpotDTO> createNewSpots(long contId, List<AcquiredSingleImage> images, List<ImgSpotDTO> existingSpots, int rows, int columns, String containerPermId) {
        Boolean[][] newSpotMatrix = HCSImageDatasetUploader.extractNewSpots(rows, columns, images, existingSpots);
        List<ImgSpotDTO> newSpots = HCSImageDatasetUploader.makeSpotDTOs(newSpotMatrix, contId);
        for (ImgSpotDTO spot : newSpots) {
            long id = this.dao.addSpot(spot);
            spot.setId(id);
        }
        return newSpots;
    }

    private static Boolean[][] extractNewSpots(int rows, int columns, List<AcquiredSingleImage> images, List<ImgSpotDTO> existingSpots) {
        Boolean[][] spots = HCSImageDatasetUploader.extractExistingSpots(rows, columns, images);
        HCSImageDatasetUploader.unmarkSpots(existingSpots, spots);
        return spots;
    }

    private static Boolean[][] extractExistingSpots(int rows, int columns, List<AcquiredSingleImage> images) {
        Boolean[][] spots = new Boolean[rows][columns];
        for (AcquiredSingleImage image : images) {
            spots[image.getWellRow() - 1][image.getWellColumn() - 1] = true;
        }
        return spots;
    }

    private static Long[][] makeTechIdMatrix(List<ImgSpotDTO> existingSpots, int rows, int columns) {
        Long[][] matrix = new Long[rows][columns];
        for (ImgSpotDTO spot : existingSpots) {
            matrix[spot.getRow().intValue() - 1][spot.getColumn().intValue() - 1] = spot.getId();
        }
        return matrix;
    }

    private static List<ImgSpotDTO> makeSpotDTOs(Boolean[][] spots, long contId) {
        ArrayList<ImgSpotDTO> newSpots = new ArrayList<ImgSpotDTO>();
        for (int row = 0; row < spots.length; ++row) {
            Boolean[] spotRow = spots[row];
            for (int col = 0; col < spotRow.length; ++col) {
                Boolean wanted = spotRow[col];
                if (wanted == null || !wanted.booleanValue()) continue;
                newSpots.add(new ImgSpotDTO(row + 1, col + 1, contId));
            }
        }
        return newSpots;
    }

    private static void unmarkSpots(List<ImgSpotDTO> existingSpots, Boolean[][] spotMatrix) {
        for (ImgSpotDTO existingSpot : existingSpots) {
            spotMatrix[existingSpot.getRow().intValue() - 1][existingSpot.getColumn().intValue() - 1] = false;
        }
    }

    private long getOrCreateDataset(long containerId, HCSImageDatasetInfo info) {
        return this.getOrCreateImageDataset(info.getDatasetPermId(), info.getImageDatasetInfo(), containerId);
    }
}

