/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageFileExtractor;
import ch.systemsx.cisd.openbis.dss.etl.dto.UnparsedImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class HCSImageFileExtractor
extends AbstractImageFileExtractor {
    private static final String CHECK_PLATE_NAME_FLAG_PROPERTY_NAME = "validate-plate-name";
    private final boolean shouldValidatePlateName;

    public HCSImageFileExtractor(Properties properties) {
        super(properties, HCSImageFileExtractor.extractSkipChannelsWithoutImages(properties));
        this.shouldValidatePlateName = PropertyUtils.getBoolean((Properties)properties, (String)CHECK_PLATE_NAME_FLAG_PROPERTY_NAME, (boolean)true);
    }

    private static boolean extractSkipChannelsWithoutImages(Properties properties) {
        return !PropertyUtils.getBoolean((Properties)properties, (String)"define-channels-per-experiment", (boolean)true);
    }

    protected static Location tryGetWellLocation(String plateLocation) {
        return Location.tryCreateLocationFromTransposedMatrixCoordinate((String)plateLocation);
    }

    protected Location tryGetTileLocation(String wellLocation) {
        Integer tileNumber = HCSImageFileExtractor.tryAsInt(wellLocation);
        if (tileNumber == null) {
            return null;
        }
        Location tileLoc = this.tryGetTileLocation(tileNumber);
        if (tileLoc == null) {
            tileLoc = Location.tryCreateLocationFromRowwisePosition((int)tileNumber, (Geometry)this.tileGeometry);
        }
        return tileLoc;
    }

    private static final UnparsedImageFileInfo tryExtractImageInfo(File imageFile, File incomingDataSetDirectory, SampleIdentifier datasetSample, boolean shouldValidatePlateName) {
        String baseName = FilenameUtils.getBaseName((String)imageFile.getPath());
        String[] tokens = StringUtils.split((String)baseName, (char)'_');
        if (tokens == null || tokens.length < 4) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("The name of image file '%s' could not be splitted into enough entities.", imageFile));
            }
            return null;
        }
        String sampleCode = tokens[tokens.length - 4];
        if (shouldValidatePlateName && sampleCode != null && !sampleCode.equalsIgnoreCase(datasetSample.getSampleCode())) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("Image file '%s' belongs to the wrong sample [expected=%s,found=%s].", imageFile, datasetSample, sampleCode));
            }
            return null;
        }
        String channelToken = tokens[tokens.length - 1];
        if (StringUtils.isBlank((CharSequence)channelToken)) {
            operationLog.info((Object)("Channel token is empty for image: " + imageFile));
            return null;
        }
        UnparsedImageFileInfo info = new UnparsedImageFileInfo();
        info.setWellLocationToken(tokens[tokens.length - 3]);
        info.setTileLocationToken(tokens[tokens.length - 2]);
        info.setChannelToken(channelToken);
        info.setTimepointToken(null);
        info.setDepthToken(null);
        return info;
    }

    @Override
    protected ImageFileInfo tryExtractImageInfo(File imageFile, File incomingDataSetDirectory, SampleIdentifier datasetSample) {
        UnparsedImageFileInfo unparsedInfo = HCSImageFileExtractor.tryExtractImageInfo(imageFile, incomingDataSetDirectory, datasetSample, this.shouldValidatePlateName);
        if (unparsedInfo == null) {
            return null;
        }
        return this.tryExtractHCSImageInfo(unparsedInfo, imageFile, incomingDataSetDirectory);
    }

    protected final ImageFileInfo tryExtractHCSImageInfo(UnparsedImageFileInfo unparsedInfo, File imageFile, File incomingDataSetDirectory) {
        assert (unparsedInfo != null);
        Location tileLocation = this.tryGetTileLocation(unparsedInfo.getTileLocationToken());
        if (tileLocation == null) {
            operationLog.info((Object)("Cannot extract tile location (a.k.a. tile/field/side) from token " + unparsedInfo.getTileLocationToken()));
            return null;
        }
        String channelCode = CodeNormalizer.normalize((String)unparsedInfo.getChannelToken());
        String imageRelativePath = HCSImageFileExtractor.getRelativeImagePath(incomingDataSetDirectory, imageFile);
        ImageFileInfo info = new ImageFileInfo(channelCode, tileLocation.getY(), tileLocation.getX(), imageRelativePath);
        boolean ok = info.setWell(unparsedInfo.getWellLocationToken());
        if (!ok) {
            operationLog.info((Object)("Cannot extract well location from token " + unparsedInfo.getWellLocationToken()));
            return null;
        }
        Float timepointOrNull = HCSImageFileExtractor.tryAsFloat(unparsedInfo.getTimepointToken());
        info.setTimepoint(timepointOrNull);
        Float depthOrNull = HCSImageFileExtractor.tryAsFloat(unparsedInfo.getDepthToken());
        info.setDepth(depthOrNull);
        Integer seriesNumberOrNull = HCSImageFileExtractor.tryAsInt(unparsedInfo.getSeriesNumberToken());
        info.setSeriesNumber(seriesNumberOrNull);
        return info;
    }
}

