/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.IImageProvider;
import ch.systemsx.cisd.openbis.dss.etl.Utils;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageIdentifier;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;

public class ImageCache
implements IImageProvider {
    private final Map<String, BufferedImage> images = new ReferenceMap();
    private final Map<String, Size> imageSizes = new ReferenceMap();
    private final Map<String, Integer> imageColorDepths = new ReferenceMap();
    private final Map<String, List<ImageIdentifier>> imageIdentifiers = new ReferenceMap();

    @Override
    public synchronized BufferedImage getImage(IHierarchicalContentNode contentNode, String imageIdOrNull, ImageLibraryInfo imageLibraryOrNull) {
        String key = this.createKey(contentNode, imageIdOrNull, imageLibraryOrNull);
        BufferedImage image = this.images.get(key);
        if (image == null) {
            image = Utils.loadUnchangedImage(contentNode, imageIdOrNull, imageLibraryOrNull);
            this.images.put(key, image);
        }
        return image;
    }

    @Override
    public Size getImageSize(IHierarchicalContentNode contentNode, String imageIdOrNull, ImageLibraryInfo imageLibraryOrNull) {
        String key = this.createKey(contentNode, imageIdOrNull, imageLibraryOrNull);
        Size size = this.imageSizes.get(key);
        if (size == null) {
            size = Utils.loadUnchangedImageSize(contentNode, imageIdOrNull, imageLibraryOrNull);
            this.imageSizes.put(key, size);
        }
        return size;
    }

    @Override
    public int getImageColorDepth(IHierarchicalContentNode contentNode, String imageIdOrNull, ImageLibraryInfo imageLibraryOrNull) {
        String key = this.createKey(contentNode, imageIdOrNull, imageLibraryOrNull);
        Integer colorDepth = this.imageColorDepths.get(key);
        if (colorDepth == null) {
            colorDepth = Utils.loadUnchangedImageColorDepth(contentNode, imageIdOrNull, imageLibraryOrNull);
            this.imageColorDepths.put(key, colorDepth);
        }
        return colorDepth;
    }

    @Override
    public List<ImageIdentifier> getImageIdentifiers(IImageReader imageReaderOrNull, File file) {
        String key = (imageReaderOrNull == null ? "" : imageReaderOrNull.getName() + ":") + file;
        List<ImageIdentifier> identifiers = this.imageIdentifiers.get(key);
        if (identifiers == null) {
            identifiers = ImageCache.readImageIdentifiers(imageReaderOrNull, file);
            this.imageIdentifiers.put(key, identifiers);
        }
        return identifiers;
    }

    public int size() {
        return this.images.size();
    }

    private String createKey(IHierarchicalContentNode contentNode, String imageIdOrNull, ImageLibraryInfo imageLibraryOrNull) {
        return contentNode.getName() + ":" + imageIdOrNull + " [" + imageLibraryOrNull + "]";
    }

    private static List<ImageIdentifier> readImageIdentifiers(IImageReader readerOrNull, File imageFile) {
        ArrayList<ImageIdentifier> ids = new ArrayList<ImageIdentifier>();
        if (readerOrNull == null) {
            ids.add(ImageIdentifier.NULL);
        } else {
            List imageIDs = readerOrNull.getImageIDs(imageFile);
            for (ImageID imageID : imageIDs) {
                ids.add(new ImageIdentifier(imageID.getSeriesIndex(), imageID.getTimeSeriesIndex(), imageID.getFocalPlaneIndex(), imageID.getColorChannelIndex()));
            }
        }
        Collections.sort(ids);
        return Collections.unmodifiableList(ids);
    }
}

