/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IDataStoreLockingMaintenanceTask;
import ch.systemsx.cisd.common.utilities.Counters;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.etl.AbsoluteImageReference;
import ch.systemsx.cisd.openbis.dss.etl.IImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.ImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class ImageSizeFeedingMaintenanceTask
implements IDataStoreLockingMaintenanceTask {
    private static final String THUMBNAIL = "thumbnail";
    private static final String ORIGINAL = "original";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ImageSizeFeedingMaintenanceTask.class);
    private static final int MAX_NUMBER_OF_EXCEPTIONS_SHOWN = 10;
    private static final Pattern DATA_SET_TYPE_PATTERN = Pattern.compile("HCS_IMAGE.*");
    private IImagingQueryDAO dao;
    private IEncapsulatedOpenBISService service;
    private IHierarchicalContentProvider contentProvider;

    public ImageSizeFeedingMaintenanceTask() {
    }

    ImageSizeFeedingMaintenanceTask(IImagingQueryDAO dao, IEncapsulatedOpenBISService service, IHierarchicalContentProvider contentProvider) {
        this.dao = dao;
        this.service = service;
        this.contentProvider = contentProvider;
    }

    public boolean requiresDataStoreLock() {
        return true;
    }

    public void setUp(String pluginName, Properties properties) {
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource(properties);
        this.dao = (IImagingQueryDAO)QueryTool.getQuery((DataSource)dataSource, IImagingQueryDAO.class);
        this.dao.listSpots(0L);
        this.service = ServiceProvider.getOpenBISService();
        this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
    }

    public void execute() {
        List dataSets = this.service.listPhysicalDataSets();
        operationLog.info((Object)("Scan " + dataSets.size() + " data sets."));
        ArrayList<String> exceptions = new ArrayList<String>();
        Counters counters = new Counters();
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            if (!this.matchingType(dataSet)) continue;
            this.handleDataSet(dataSet.getDataSetCode(), exceptions, (Counters<String>)counters);
        }
        this.logExceptionsIfAny(exceptions);
        operationLog.info((Object)(counters.getCountOf((Object)ORIGINAL) + " original image sizes and " + counters.getCountOf((Object)THUMBNAIL) + " thumbnail image sizes are added to the database."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataSet(String dataSetCode, List<String> exceptions, Counters<String> counters) {
        try (IHierarchicalContent content = null;){
            long dataSetId;
            List zoomLevels;
            content = this.contentProvider.asContentWithoutModifyingAccessTimestamp(dataSetCode);
            ImgImageDatasetDTO imageDataSet = this.dao.tryGetImageDatasetByPermId(dataSetCode);
            if (imageDataSet != null && (zoomLevels = this.dao.listImageZoomLevels(dataSetId = imageDataSet.getId())).isEmpty()) {
                IImagingDatasetLoader loader = this.createImageLoader(dataSetCode, content);
                AbsoluteImageReference originalImage = loader.tryFindAnyOriginalImage();
                String logEntryOriginal = this.addZoomLevel(dataSetCode, dataSetId, originalImage, true);
                AbsoluteImageReference thumbnail = loader.tryFindAnyThumbnail();
                String logEntryThumbnail = this.addZoomLevel(dataSetCode, dataSetId, thumbnail, false);
                this.dao.commit();
                if (logEntryOriginal != null) {
                    operationLog.info((Object)logEntryOriginal);
                    counters.count((Object)ORIGINAL);
                }
                if (logEntryThumbnail != null) {
                    operationLog.info((Object)logEntryThumbnail);
                    counters.count((Object)THUMBNAIL);
                }
            }
        }
    }

    protected IImagingDatasetLoader createImageLoader(String dataSetCode, IHierarchicalContent content) {
        return ImagingDatasetLoader.tryCreate(this.dao, dataSetCode, content);
    }

    private void logExceptionsIfAny(List<String> exceptions) {
        if (!exceptions.isEmpty()) {
            boolean more = exceptions.size() > 10;
            operationLog.error((Object)(exceptions.size() + " exceptions occured" + (more ? " (only the first 10 are logged):" : ":")));
            for (int i = 0; i < Math.min(10, exceptions.size()); ++i) {
                operationLog.error((Object)exceptions.get(i));
            }
        }
    }

    private String addZoomLevel(String dataSetCode, long dataSetId, AbsoluteImageReference image, boolean original) {
        if (image == null) {
            return null;
        }
        Size size = image.getUnchangedImageSize();
        int width = size.getWidth();
        int height = size.getHeight();
        int colorDepth = image.getColorDepth();
        this.dao.addImageZoomLevel(new ImgImageZoomLevelDTO(dataSetCode, original, "", width, height, colorDepth, null, dataSetId));
        return (original ? "Original" : "Thumbnail") + " size " + width + "x" + height + " added for data set " + dataSetCode;
    }

    private boolean matchingType(SimpleDataSetInformationDTO dataSet) {
        String dataSetType = dataSet.getDataSetType();
        return DATA_SET_TYPE_PATTERN.matcher(dataSetType).matches();
    }
}

