/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageChecklist;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.HCSContainerDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageCheckList;
import ch.systemsx.cisd.openbis.dss.etl.ImageFileExtractionResult;
import ch.systemsx.cisd.openbis.dss.etl.MicroscopyImageChecklist;
import ch.systemsx.cisd.openbis.dss.etl.PlateStorageProcessor;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateDimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ImageValidator {
    private final PlateStorageProcessor.DatasetOwnerInformation dataSetInformation;
    private final IMailClient mailClient;
    private final File incomingDataSetDirectory;
    private final ImageFileExtractionResult extractionResult;
    private final Logger operationLog;
    private final Logger notificationLog;
    private final boolean notifyIfPlateIncomplete;
    private AbstractImageChecklist imageCheckList;

    public ImageValidator(PlateStorageProcessor.DatasetOwnerInformation dataSetInformation, IMailClient mailClient, File incomingDataSetDirectory, ImageFileExtractionResult extractionResult, Logger operationLog, Logger notificationLog, boolean notifyIfPlateIncomplete) {
        this.dataSetInformation = dataSetInformation;
        this.mailClient = mailClient;
        this.incomingDataSetDirectory = incomingDataSetDirectory;
        this.extractionResult = extractionResult;
        this.operationLog = operationLog;
        this.notificationLog = notificationLog;
        this.notifyIfPlateIncomplete = notifyIfPlateIncomplete;
    }

    public boolean validateImages() {
        this.initializeImageCheckList();
        this.checkImagesForDuplicates();
        if (this.extractionResult.getInvalidFiles().size() > 0) {
            throw UserFailureException.fromTemplate((String)"Following invalid files %s have been found.", (Object[])new Object[]{CollectionUtils.abbreviate(this.extractionResult.getInvalidFiles(), (int)10)});
        }
        if (this.extractionResult.getImages().size() == 0) {
            throw UserFailureException.fromTemplate((String)"No extractable files were found inside a dataset '%s'. Have you changed your naming convention?", (Object[])new Object[]{this.incomingDataSetDirectory.getAbsolutePath()});
        }
        return this.checkCompleteness();
    }

    private void initializeImageCheckList() {
        PlateDimension plateGeometry;
        List<Channel> channels = this.extractionResult.getChannels();
        Geometry tileGeometry = this.extractionResult.getTileGeometry();
        try {
            plateGeometry = this.getPlateGeometry();
        }
        catch (EnvironmentFailureException e) {
            plateGeometry = null;
        }
        ArrayList<String> channelCodes = new ArrayList<String>();
        for (Channel channel : channels) {
            channelCodes.add(channel.getCode());
        }
        this.imageCheckList = null == plateGeometry ? new MicroscopyImageChecklist(channelCodes, tileGeometry) : new HCSImageCheckList(channelCodes, plateGeometry, tileGeometry);
    }

    private void checkImagesForDuplicates() {
        List<AcquiredSingleImage> images = this.extractionResult.getImages();
        for (AcquiredSingleImage image : images) {
            this.imageCheckList.checkOff(image);
        }
        this.imageCheckList.checkForDuplicates();
    }

    private boolean checkCompleteness() {
        boolean complete;
        String dataSetFileName = this.incomingDataSetDirectory.getName();
        boolean bl = complete = this.imageCheckList.getCheckedOnFullLocationsSize() == 0;
        if (!complete) {
            String message = this.imageCheckList.getIncompleteDataSetErrorMessage(dataSetFileName);
            this.operationLog.warn((Object)message);
            if (this.mailClient != null && this.notifyIfPlateIncomplete) {
                Experiment experiment = this.dataSetInformation.tryGetExperiment();
                assert (experiment != null) : "dataset not connected to an experiment: " + (Object)((Object)this.dataSetInformation);
                String email = null;
                if (experiment.getRegistrator() != null) {
                    email = experiment.getRegistrator().getEmail();
                }
                if (!StringUtils.isBlank(email)) {
                    try {
                        this.mailClient.sendMessage("Incomplete data set '" + dataSetFileName + "'", message, null, null, new String[]{email});
                    }
                    catch (EnvironmentFailureException e) {
                        this.notificationLog.error((Object)("Couldn't send the following e-mail to '" + email + "': " + message), (Throwable)e);
                    }
                } else {
                    this.notificationLog.error((Object)("Unspecified e-mail address of experiment registrator " + experiment.getRegistrator()));
                }
            }
        }
        return complete;
    }

    private PlateDimension getPlateGeometry() {
        return HCSContainerDatasetInfo.getPlateGeometry(this.dataSetInformation);
    }
}

