/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.common.concurrent.FailureRecord;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.concurrent.ParallelizedExecutor;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluator;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.ICredentials;
import ch.systemsx.cisd.etlserver.plugins.AbstractMaintenanceTaskWithStateFile;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetUpdatable;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.etl.ImageCache;
import ch.systemsx.cisd.openbis.dss.etl.Utils;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.IImageGenerationAlgorithm;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageContainerDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.JythonBasedProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.dss.screening.server.plugins.jython.ScreeningJythonIngestionService;
import ch.systemsx.cisd.openbis.dss.screening.server.plugins.jython.ScreeningPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class MicroscopyThumbnailsCreationTask
extends AbstractMaintenanceTaskWithStateFile {
    private static final String DATA_SET_CONTAINER_TYPE_KEY = "data-set-container-type";
    private static final String DATA_SET_CONTAINER_TYPE_DEFAULT = "MICROSCOPY_IMG_CONTAINER";
    private static final String DATA_SET_THUMBNAIL_TYPE_REGEX_KEY = "data-set-thumbnail-type-regex";
    private static final String DATA_SET_THUMBNAIL_TYPE_REGEX_DEFAULT = "MICROSCOPY_IMG_THUMBNAIL";
    private static final String MAIN_DATA_SET_TYPE_REGEX_KEY = "main-data-set-type-regex";
    private static final String MAIN_DATA_SET_TYPE_REGEX_DEFAULT = "MICROSCOPY_IMG";
    private static final String MAX_NUMBER_OF_DATA_SETS_KEY = "max-number-of-data-sets";
    private static final int MAX_NUMBER_OF_DATA_SETS_DEFAULT = 1000;
    private static final String MAX_NUMBER_OF_WORKERS_KEY = "maximum-number-of-workers";
    private static final int MAX_NUMBER_OF_WORKERS_DEFAULT = 1;
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MicroscopyThumbnailsCreationTask.class);
    private Properties properties;
    private String dataSetContainerType;
    private Pattern dataSetThumbnailTypePattern;
    private Pattern mainDataSetTypePattern;
    private int maxCount;
    private int maxNumberOfWorkers;

    public void setUp(String pluginName, Properties properties) {
        this.properties = properties;
        this.defineStateFile(properties, this.getDirectoryProvider().getStoreRoot());
        this.dataSetContainerType = properties.getProperty(DATA_SET_CONTAINER_TYPE_KEY, DATA_SET_CONTAINER_TYPE_DEFAULT);
        this.dataSetThumbnailTypePattern = PropertyUtils.getPattern((Properties)properties, (String)DATA_SET_THUMBNAIL_TYPE_REGEX_KEY, (String)DATA_SET_THUMBNAIL_TYPE_REGEX_DEFAULT);
        this.mainDataSetTypePattern = PropertyUtils.getPattern((Properties)properties, (String)MAIN_DATA_SET_TYPE_REGEX_KEY, (String)MAIN_DATA_SET_TYPE_REGEX_DEFAULT);
        this.maxCount = PropertyUtils.getInt((Properties)properties, (String)MAX_NUMBER_OF_DATA_SETS_KEY, (int)1000);
        this.maxNumberOfWorkers = PropertyUtils.getInt((Properties)properties, (String)MAX_NUMBER_OF_WORKERS_KEY, (int)1);
    }

    public void execute() {
        final String sessionToken = this.login();
        Date lastRegistrationDate = this.getLastRegistrationDate(new Date(0L));
        String lastCode = this.getLastCode();
        operationLog.info((Object)("Search for data sets of type " + this.dataSetContainerType + " which are younger than " + this.renderTimeStamp(lastRegistrationDate) + (lastCode != null ? " and code after " + lastCode : "")));
        SearchResult<DataSet> searchResult = this.searchForNewDataSets(sessionToken, lastRegistrationDate, lastCode);
        List containerDataSets = searchResult.getObjects();
        int totalCount = searchResult.getTotalCount();
        operationLog.info((Object)(totalCount + " data sets found." + (totalCount > containerDataSets.size() ? " Handle the first " + containerDataSets.size() : "")));
        final AtomicInteger numberOfCreatedThumbnailDataSets = new AtomicInteger(0);
        Collection result = ParallelizedExecutor.process((List)containerDataSets, (ITaskExecutor)new ITaskExecutor<DataSet>(){

            public Status execute(DataSet containerDataSet) {
                if (MicroscopyThumbnailsCreationTask.this.hasNoThumbnails(containerDataSet) && !containerDataSet.getComponents().isEmpty()) {
                    operationLog.info((Object)("Generate thumbnails for data set " + containerDataSet.getCode()));
                    try {
                        int numberOfDataSets = MicroscopyThumbnailsCreationTask.this.createThumbnailDataSet(sessionToken, containerDataSet);
                        numberOfCreatedThumbnailDataSets.addAndGet(numberOfDataSets);
                    }
                    catch (Throwable t) {
                        operationLog.error((Object)("Generating thumbnails for data set " + containerDataSet.getCode() + " failed:"), t);
                        return Status.createError((String)t.toString());
                    }
                }
                return Status.OK;
            }
        }, (double)this.getMachineLoad(), (int)this.maxNumberOfWorkers, (String)"thumbnail creation", (int)0, (boolean)false);
        List<DataSet> failedDataSets = this.extractFailedDataSets(result);
        this.updateTimeStampFile(numberOfCreatedThumbnailDataSets.get(), containerDataSets, failedDataSets);
        operationLog.info((Object)(numberOfCreatedThumbnailDataSets + " thumbnail data sets have been created."));
    }

    double getMachineLoad() {
        return 0.5;
    }

    private SearchResult<DataSet> searchForNewDataSets(String sessionToken, Date lastRegistrationDate, String lastCode) {
        DataSetSearchCriteria searchCriteria = new DataSetSearchCriteria();
        searchCriteria.withType().withCode().thatEquals(this.dataSetContainerType);
        searchCriteria.withRegistrationDate().thatIsLaterThanOrEqualTo(lastRegistrationDate);
        if (lastCode != null) {
            searchCriteria.withCode().thatIsGreaterThan(lastCode);
        }
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withComponents().withType();
        fetchOptions.withComponents().withExperiment();
        fetchOptions.withComponents().withSample();
        fetchOptions.sortBy().registrationDate();
        fetchOptions.sortBy().code();
        if (this.maxCount > 0) {
            fetchOptions.from(Integer.valueOf(0));
            fetchOptions.count(Integer.valueOf(this.maxCount));
        }
        return this.getService().searchDataSets(sessionToken, searchCriteria, fetchOptions);
    }

    private List<DataSet> extractFailedDataSets(Collection<FailureRecord<DataSet>> result) {
        if (result == null) {
            return null;
        }
        List<DataSet> failedDataSets = result.stream().map(FailureRecord::getFailedItem).collect(Collectors.toList());
        this.sortDataSets(failedDataSets);
        return failedDataSets;
    }

    private void updateTimeStampFile(int numberOfCreatedThumbnailDataSets, List<DataSet> containerDataSets, List<DataSet> failedDataSets) {
        if (failedDataSets.isEmpty()) {
            this.updateTimeStampFileWithLastDataSet(containerDataSets);
        } else {
            DataSet oldestFailedDataSet = failedDataSets.get(0);
            if (numberOfCreatedThumbnailDataSets > 0) {
                DataSet youngestNotFailedDataSet = this.tryGetYoungestNotFailedDataSet(containerDataSets, oldestFailedDataSet);
                if (youngestNotFailedDataSet != null) {
                    operationLog.info((Object)("Oldest failed data set: " + oldestFailedDataSet.getCode() + ", youngest not failed data set: " + youngestNotFailedDataSet.getCode()));
                    this.updateTimeStampFile(this.renderForComparison(youngestNotFailedDataSet));
                } else {
                    operationLog.info((Object)("Oldest failed data set: " + oldestFailedDataSet.getCode() + ", time stamp file not updated."));
                }
            } else {
                operationLog.info((Object)("Ignoring failed data sets " + CollectionUtils.abbreviate(failedDataSets, (int)10)));
                this.updateTimeStampFileWithLastDataSet(containerDataSets);
            }
        }
    }

    private void updateTimeStampFileWithLastDataSet(List<DataSet> containerDataSets) {
        if (!containerDataSets.isEmpty()) {
            DataSet lastDataSet = containerDataSets.get(containerDataSets.size() - 1);
            operationLog.info((Object)("Update time stamp file with data set " + lastDataSet.getCode()));
            this.updateTimeStampFile(this.renderForComparison(lastDataSet));
        }
    }

    private DataSet tryGetYoungestNotFailedDataSet(List<DataSet> dataSets, DataSet oldestFailedDataSet) {
        String renderedOldestFailedDataSet = this.renderForComparison(oldestFailedDataSet);
        for (int i = 0; i < dataSets.size(); ++i) {
            DataSet dataSet = dataSets.get(i);
            if (!this.renderForComparison(dataSet).equals(renderedOldestFailedDataSet)) continue;
            return i > 0 ? dataSets.get(i - 1) : null;
        }
        return null;
    }

    private void sortDataSets(List<DataSet> dataSets) {
        Collections.sort(dataSets, new SimpleComparator<DataSet, String>(){

            public String evaluate(DataSet dataSet) {
                return MicroscopyThumbnailsCreationTask.this.renderForComparison(dataSet);
            }
        });
    }

    private String renderForComparison(DataSet dataSet) {
        return this.renderTimeStampAndCode(dataSet.getRegistrationDate(), dataSet.getCode());
    }

    private int createThumbnailDataSet(String sessionToken, DataSet containerDataSet) {
        List row;
        TableModel tableModel = this.createThumbnailDataSetViaIngestionService(sessionToken, containerDataSet);
        List rows = tableModel.getRows();
        if (!rows.isEmpty() && !(row = ((TableModelRow)rows.get(0)).getValues()).isEmpty()) {
            List headers = tableModel.getHeader();
            if (headers.size() > 1 && ((TableModelColumnHeader)headers.get(1)).getTitle().equals("Error")) {
                throw new RuntimeException(((ISerializableComparable)row.get(1)).toString());
            }
            ISerializableComparable cell = (ISerializableComparable)row.get(0);
            if (cell instanceof IntegerTableCell) {
                return (int)((IntegerTableCell)cell).getNumber();
            }
            operationLog.warn((Object)("Not an integer: " + cell));
        }
        return 0;
    }

    TableModel createThumbnailDataSetViaIngestionService(String sessionToken, final DataSet containerDataSet) {
        String containerCode = containerDataSet.getCode();
        IImagingReadonlyQueryDAO imageDb = this.getImageDb();
        final ImageDataSetStructure imageDataSetStructure = Utils.getImageDataSetStructure(imageDb, containerCode);
        final SimpleImageContainerDataConfig config = new SimpleImageContainerDataConfig();
        ScreeningPluginScriptRunnerFactory scriptRunnerFactory = this.createScriptRunner(imageDataSetStructure, config);
        Properties ingestionServiceProperties = this.createIngestionServiceProperties();
        File storeRoot = this.getDirectoryProvider().getStoreRoot();
        ScreeningJythonIngestionService ingestionService = new ScreeningJythonIngestionService(ingestionServiceProperties, storeRoot, (IPluginScriptRunnerFactory)scriptRunnerFactory){
            private static final long serialVersionUID = 1L;

            public TableModel process(IDataSetRegistrationTransactionV2 transaction, Map<String, Object> parameters, DataSetProcessingContext context) {
                super.process(transaction, parameters, context);
                int numberOfThumbnailDataSets = MicroscopyThumbnailsCreationTask.this.composeThumbnailDataSet(transaction, containerDataSet, imageDataSetStructure, config, context);
                return new TableModel(Arrays.asList(new TableModelColumnHeader()), Arrays.asList(new TableModelRow(Arrays.asList(new IntegerTableCell((long)numberOfThumbnailDataSets)))));
            }
        };
        IHierarchicalContentProvider contentProvider = this.getHierarchicalContentProvider();
        DataSetProcessingContext context = new DataSetProcessingContext(contentProvider, null, null, null, null, null, sessionToken);
        return ingestionService.createAggregationReport(new HashMap(), context);
    }

    private int composeThumbnailDataSet(IDataSetRegistrationTransactionV2 transaction, DataSet containerDataSet, ImageDataSetStructure imageDataSetStructure, SimpleImageDataConfig config, DataSetProcessingContext context) {
        int numberOfThumbnailDataSets = 0;
        String containerCode = containerDataSet.getCode();
        IDataSetUpdatable container = transaction.getDataSetForUpdate(containerCode);
        DataSet mainDataSet = this.getMainDataSet(containerDataSet);
        IImageGenerationAlgorithm imageGenerationAlgorithm = config.getImageGenerationAlgorithm();
        if (imageGenerationAlgorithm != null) {
            Sample sample;
            ArrayList<IDataSet> thumbnailDatasets = new ArrayList<IDataSet>();
            ImageCache imageProvider = new ImageCache();
            IHierarchicalContent content = context.getHierarchicalContentProviderUnfiltered().asContent(containerCode);
            imageGenerationAlgorithm.setContent(content);
            ImageDataSetInformation imageDataSetInformation = new ImageDataSetInformation();
            imageDataSetInformation.setImageDataSetStructure(imageDataSetStructure);
            long t0 = System.currentTimeMillis();
            List<BufferedImage> images = imageGenerationAlgorithm.generateImages(imageDataSetInformation, thumbnailDatasets, imageProvider);
            operationLog.info((Object)(images.size() + " thumbnails have been created for data set " + containerCode + " in " + (System.currentTimeMillis() - t0) + " msec."));
            IDataSet dataSet = Utils.createDataSetAndImageFiles(transaction, imageGenerationAlgorithm, images);
            ArrayList<String> components = new ArrayList<String>(container.getContainedDataSetCodes());
            components.add(dataSet.getDataSetCode());
            container.setContainedDataSetCodes(components);
            ISearchService searchService = transaction.getSearchService();
            Experiment experiment = mainDataSet.getExperiment();
            if (experiment != null) {
                dataSet.setExperiment(searchService.getExperimentByPermId(experiment.getPermId().getPermId()));
            }
            if ((sample = mainDataSet.getSample()) != null) {
                dataSet.setSample(searchService.getSampleByPermId(sample.getPermId().getPermId()));
            }
            ++numberOfThumbnailDataSets;
        }
        List<ThumbnailsStorageFormat> thumbnailFormats = config.getImageStorageConfiguration().getThumbnailsStorageFormat();
        for (ThumbnailsStorageFormat thumbnailsStorageFormat : thumbnailFormats) {
        }
        return numberOfThumbnailDataSets;
    }

    private Properties createIngestionServiceProperties() {
        Properties ingestionServiceProperties = new Properties(this.properties);
        ingestionServiceProperties.setProperty("do-not-create-original-dir", "true");
        return ingestionServiceProperties;
    }

    private ScreeningPluginScriptRunnerFactory createScriptRunner(final ImageDataSetStructure imageDataSetStructure, final SimpleImageContainerDataConfig config) {
        ScreeningPluginScriptRunnerFactory scriptRunnerFactory = new ScreeningPluginScriptRunnerFactory(JythonBasedProcessingPlugin.getScriptPathProperty((Properties)this.properties)){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected IJythonEvaluator createEvaluator(String scriptString, String[] jythonPath, DataSetProcessingContext context) {
                MicroscopyThumbnailsCreationTask microscopyThumbnailsCreationTask = MicroscopyThumbnailsCreationTask.this;
                synchronized (microscopyThumbnailsCreationTask) {
                    IJythonEvaluator evaluator = super.createEvaluator(scriptString, jythonPath, context);
                    evaluator.set("image_data_set_structure", (Object)imageDataSetStructure);
                    evaluator.set("image_config", (Object)config);
                    return evaluator;
                }
            }
        };
        return scriptRunnerFactory;
    }

    private boolean hasNoThumbnails(DataSet containerDataSet) {
        return this.getFirstMatchingComponentOrNull(containerDataSet, this.dataSetThumbnailTypePattern) == null;
    }

    private DataSet getMainDataSet(DataSet containerDataSet) {
        return this.getFirstMatchingComponentOrNull(containerDataSet, this.mainDataSetTypePattern);
    }

    private DataSet getFirstMatchingComponentOrNull(DataSet containerDataSet, Pattern pattern) {
        for (DataSet component : containerDataSet.getComponents()) {
            if (!pattern.matcher(component.getType().getCode()).matches()) continue;
            return component;
        }
        return null;
    }

    private String login() {
        ICredentials credentials = this.getEtlServerCredentials();
        return this.getService().login(credentials.getUserId(), credentials.getPassword());
    }

    protected IApplicationServerApi getService() {
        return ServiceProvider.getV3ApplicationService();
    }

    protected IDataSetDirectoryProvider getDirectoryProvider() {
        return ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
    }

    protected IHierarchicalContentProvider getHierarchicalContentProvider() {
        return ServiceProvider.getHierarchicalContentProvider();
    }

    protected IImagingReadonlyQueryDAO getImageDb() {
        return DssScreeningUtils.getQuery();
    }
}

