/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.geometry.SpatialPoint;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Location;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TileGeometryOracle {
    public static Geometry figureGeometry(Collection<Location> tileLocations) {
        int maxRow = 0;
        int maxCol = 0;
        for (Location location : tileLocations) {
            if (location.getRow() > maxRow) {
                maxRow = location.getRow();
            }
            if (location.getColumn() <= maxCol) continue;
            maxCol = location.getColumn();
        }
        return Geometry.createFromRowColDimensions(maxRow, maxCol);
    }

    public static Map<Integer, Location> tryFigureLocations(Map<Integer, SpatialPoint> tileToSpatialPointMap, double epsilon) {
        ArrayList<Double> xCoords = new ArrayList<Double>();
        ArrayList<Double> yCoords = new ArrayList<Double>();
        for (SpatialPoint point : tileToSpatialPointMap.values()) {
            TileGeometryOracle.addIfNotPresent(xCoords, point.getX(), epsilon);
            TileGeometryOracle.addIfNotPresent(yCoords, point.getY(), epsilon);
        }
        Collections.sort(xCoords);
        Collections.sort(yCoords);
        HashMap<Integer, Location> result = new HashMap<Integer, Location>();
        for (Map.Entry<Integer, SpatialPoint> entry : tileToSpatialPointMap.entrySet()) {
            Integer tileNumber = entry.getKey();
            Location location = TileGeometryOracle.extractLocation(entry.getValue(), xCoords, yCoords, epsilon);
            result.put(tileNumber, location);
        }
        return result;
    }

    private static void addIfNotPresent(List<Double> values, Double value, double epsilon) {
        int idx = TileGeometryOracle.findIdxByEpsilon(values, value, epsilon);
        if (idx < 0) {
            values.add(value);
        }
    }

    private static int findIdxByEpsilon(List<Double> values, double toFind, double epsilon) {
        for (int idx = 0; idx < values.size(); ++idx) {
            if (!(Math.abs(values.get(idx) - toFind) < epsilon)) continue;
            return idx;
        }
        return -1;
    }

    private static Location extractLocation(SpatialPoint point, List<Double> xCoords, List<Double> yCoords, double epsilon) {
        int locationX = TileGeometryOracle.findIdxByEpsilon(xCoords, point.getX(), epsilon);
        int locationY = TileGeometryOracle.findIdxByEpsilon(yCoords, point.getY(), epsilon);
        int row = yCoords.size() - locationY;
        int column = locationX + 1;
        Location location = new Location(row, column);
        return location;
    }
}

