/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.hcs.Location;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class TileMapper {
    private final Map<Integer, Location> map = new HashMap<Integer, Location>();

    public static TileMapper tryCreate(String mappingString, Geometry geometry) {
        if (StringUtils.isBlank((CharSequence)mappingString)) {
            return null;
        }
        return new TileMapper(mappingString, geometry);
    }

    private TileMapper(String mappingString, Geometry geometry) {
        assert (StringUtils.isNotBlank((CharSequence)mappingString));
        assert (geometry != null);
        int max = geometry.getColumns() * geometry.getRows();
        String[] rows = StringUtils.split((String)mappingString, (String)";");
        if (rows == null || rows.length != geometry.getRows()) {
            throw new IllegalArgumentException(String.format("Mapping does not match geometry. Number of rows expected: %d, but was: %d", geometry.getRows(), rows == null ? "null" : Integer.valueOf(rows.length)));
        }
        for (int r = 0; r < rows.length; ++r) {
            String[] columns = StringUtils.split((String)rows[r], (String)",");
            if (columns == null || columns.length != geometry.getColumns()) {
                throw new IllegalArgumentException(String.format("Mapping does not match geometry. Number of columns expected: %s, but was: %s", geometry.getColumns(), columns == null ? "null" : Integer.valueOf(columns.length)));
            }
            for (int c = 0; c < columns.length; ++c) {
                int value = Integer.parseInt(columns[c]);
                if (value > max || value < -1) {
                    throw new IllegalArgumentException(String.format("Tile value out of range. Allowed: [-1, %s], was: %s.", max, value));
                }
                if (value == -1) continue;
                if (this.map.get(value) != null) {
                    throw new IllegalArgumentException(String.format("Tile mapping for '%s' defined more than once.", value));
                }
                this.map.put(value, new Location(c + 1, r + 1));
            }
        }
    }

    public Location tryGetLocation(int position) {
        return this.map.get(position);
    }
}

