/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.dss.etl.dto.UnparsedImageFileInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class UnparsedImageFileInfoLexer {
    private static final String TOKENS_SEPARATOR = "_";
    private static final char WELL_MARKER = 'w';
    private static final char CHANNEL_MARKER = 'c';
    private static final char TILE_MARKER = 's';
    private static final char DEPTH_MARKER = 'z';
    private static final char TIME_MARKER = 't';
    private static final char SERIES_NUMBER_MARKER = 'n';

    public static UnparsedImageFileInfo tryExtractHCSImageFileInfo(File imageFile, File incomingDataSetPath) {
        UnparsedImageFileInfo info = UnparsedImageFileInfoLexer.tryExtractImageFileInfo(imageFile, incomingDataSetPath);
        if (info.getWellLocationToken() == null || info.getTileLocationToken() == null || info.getChannelToken() == null) {
            return null;
        }
        return info;
    }

    public static UnparsedImageFileInfo tryExtractMicroscopyImageFileInfo(File imageFile, File incomingDataSetPath) {
        UnparsedImageFileInfo info = UnparsedImageFileInfoLexer.tryExtractImageFileInfo(imageFile, incomingDataSetPath);
        if (info.getTileLocationToken() == null || info.getChannelToken() == null) {
            return null;
        }
        return info;
    }

    private static UnparsedImageFileInfo tryExtractImageFileInfo(File imageFile, File incomingDataSetPath) {
        UnparsedImageFileInfo info = UnparsedImageFileInfoLexer.extractImageFileInfo(UnparsedImageFileInfoLexer.getFileBaseName(imageFile));
        return info;
    }

    private static String getFileBaseName(File imageFile) {
        return FilenameUtils.getBaseName((String)imageFile.getPath());
    }

    @Private
    static UnparsedImageFileInfo extractImageFileInfo(String text) {
        Map<Character, String> tokensMap = UnparsedImageFileInfoLexer.extractTokensMap(text);
        String wellLocationToken = tokensMap.get(Character.valueOf('w'));
        String tileLocationToken = tokensMap.get(Character.valueOf('s'));
        String channelToken = tokensMap.get(Character.valueOf('c'));
        String timepointToken = tokensMap.get(Character.valueOf('t'));
        String depthToken = tokensMap.get(Character.valueOf('z'));
        String seriesNumberToken = tokensMap.get(Character.valueOf('n'));
        UnparsedImageFileInfo info = new UnparsedImageFileInfo();
        info.setWellLocationToken(wellLocationToken);
        info.setTileLocationToken(tileLocationToken);
        info.setChannelToken(channelToken);
        info.setTimepointToken(timepointToken);
        info.setDepthToken(depthToken);
        info.setSeriesNumberToken(seriesNumberToken);
        return info;
    }

    public static Map<Character, String> extractTokensMap(String text) {
        String[] tokens;
        HashMap<Character, String> tokensMap = new HashMap<Character, String>();
        for (String token : tokens = StringUtils.split((String)text, (String)TOKENS_SEPARATOR)) {
            if (StringUtils.isBlank((CharSequence)token)) continue;
            char marker = token.charAt(0);
            String value = token.substring(1);
            tokensMap.put(Character.valueOf(marker), value);
        }
        return tokensMap;
    }
}

