/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.biozentrum;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.geometry.SpatialPoint;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.openbis.dss.etl.TileGeometryOracle;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Location;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ImageMetadataExtractor {
    static final String POSITION_X_PROP = "stage-position-x";
    static final String POSITION_Y_PROP = "stage-position-y";

    public static Map<String, Object> extractMetadata(File imageFile) {
        IImageReader imageReader = ImageReaderFactory.tryGetReaderForFile((String)"BioFormats", (String)imageFile.getAbsolutePath());
        return imageReader.readMetaData(imageFile, ImageID.NULL, null);
    }

    public static Map<Integer, Location> tryGetTileMapping(Map<Integer, Map<String, Object>> tileToMetadataMap, double epsilon) {
        HashMap<Integer, SpatialPoint> tileToSpatialPointMap = new HashMap<Integer, SpatialPoint>();
        for (Integer tile : tileToMetadataMap.keySet()) {
            Map<String, Object> metadata = tileToMetadataMap.get(tile);
            SpatialPoint point = new SpatialPoint(ImageMetadataExtractor.extractXCoord(metadata).doubleValue(), ImageMetadataExtractor.extractYCoord(metadata).doubleValue());
            tileToSpatialPointMap.put(tile, point);
        }
        return TileGeometryOracle.tryFigureLocations(tileToSpatialPointMap, epsilon);
    }

    private static Double extractXCoord(Map<String, Object> metadata) {
        return ImageMetadataExtractor.extractNumber(metadata, POSITION_X_PROP);
    }

    private static Double extractYCoord(Map<String, Object> metadata) {
        return ImageMetadataExtractor.extractNumber(metadata, POSITION_Y_PROP);
    }

    private static Double extractNumber(Map<String, Object> metadata, String propName) {
        String numberAsString = (String)metadata.get(propName);
        try {
            return Double.valueOf(numberAsString);
        }
        catch (NumberFormatException nfe) {
            throw UserFailureException.fromTemplate((String)"Cannot parse number for property %s with value %s", (Object[])new Object[]{propName, numberAsString});
        }
    }
}

