/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dataaccess;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.AbsoluteImageReference;
import ch.systemsx.cisd.openbis.dss.etl.IImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.etl.PrefixedImage;
import ch.systemsx.cisd.openbis.dss.etl.Utils;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageTransfomationFactories;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.RequestedImageSize;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.HCSDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgContainerDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageTransformationDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelTransformationEnrichedDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgSpotDTO;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ImagingDatasetLoader
extends HCSDatasetLoader
implements IImagingDatasetLoader {
    private final IHierarchicalContent content;

    public static ImagingDatasetLoader tryCreate(IImagingReadonlyQueryDAO query, String datasetPermId, IHierarchicalContent content) {
        ImgImageDatasetDTO dataset = query.tryGetImageDatasetByPermId(datasetPermId);
        if (dataset == null) {
            operationLog.warn((Object)String.format("No dataset with code '%s' found in the imaging database.", datasetPermId));
            return null;
        }
        return new ImagingDatasetLoader(query, dataset, content);
    }

    protected ImagingDatasetLoader(IImagingReadonlyQueryDAO query, ImgImageDatasetDTO dataset, IHierarchicalContent content) {
        super(query, dataset);
        this.content = content;
    }

    @Override
    public AbsoluteImageReference tryGetImage(String chosenChannelCode, ImageChannelStackReference channelStackReference, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull) {
        boolean thumbnailFetched;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)chosenChannelCode)) {
            throw new UserFailureException("Unspecified channel.");
        }
        this.validateChannelStackReference(channelStackReference);
        ImgChannelDTO channel = this.tryLoadChannel(chosenChannelCode);
        if (channel == null) {
            return null;
        }
        long datasetId = this.getDataset().getId();
        long chosenChannelId = channel.getId();
        PrefixedImage imageDTO = null;
        if (imageSize.isThumbnailRequired()) {
            imageDTO = this.tryGetThumbnail(chosenChannelId, channelStackReference, datasetId, imageSize, singleChannelTransformationCodeOrNull);
        }
        boolean bl = thumbnailFetched = imageDTO != null;
        if (imageDTO == null && (imageDTO = this.tryGetOriginalImage(chosenChannelId, channelStackReference, datasetId)) == null && !imageSize.isThumbnailRequired()) {
            imageDTO = this.tryGetThumbnail(chosenChannelId, channelStackReference, datasetId, imageSize, singleChannelTransformationCodeOrNull);
            boolean bl2 = thumbnailFetched = imageDTO != null;
        }
        if (imageDTO == null) {
            return null;
        }
        AbsoluteImageReference imgRef = this.createAbsoluteImageReference(imageDTO, channel, imageSize, thumbnailFetched);
        if (thumbnailFetched && imageSize.isThumbnailRequired() && this.isThumbnailsTooSmall(imageSize, imgRef.getUnchangedImage()) && (imageDTO = this.tryGetOriginalImage(channel.getId(), channelStackReference, datasetId)) != null) {
            thumbnailFetched = false;
            imgRef = this.createAbsoluteImageReference(imageDTO, channel, imageSize, thumbnailFetched);
        }
        return imgRef;
    }

    private boolean isThumbnailsTooSmall(RequestedImageSize imageSize, BufferedImage image) {
        Size requestedThumbnailSize = imageSize.tryGetThumbnailSize();
        double width = 1.5 * (double)image.getWidth();
        double height = 1.5 * (double)image.getHeight();
        boolean thumbnailTooSmall = (double)requestedThumbnailSize.getWidth() > width || (double)requestedThumbnailSize.getHeight() > height;
        return thumbnailTooSmall;
    }

    private AbsoluteImageReference createAbsoluteImageReference(PrefixedImage image, ImgChannelDTO channel, RequestedImageSize imageSize, boolean useNativeImageLibrary) {
        String path = image.getFilePath();
        IHierarchicalContentNode contentNode = this.content.getNode(path);
        ColorComponent colorComponent = image.getColorComponent();
        ImageTransfomationFactories imageTransfomationFactories = this.createImageTransfomationFactories(image, channel);
        ImageLibraryInfo imageLibrary = Utils.tryGetImageLibrary(this.dataset, useNativeImageLibrary);
        return new AbsoluteImageReference(contentNode, path, image.getImageID(), colorComponent, imageSize, ImagingDatasetLoader.getColor(channel), imageTransfomationFactories, imageLibrary, image.tryGetSingleChannelTransformationCode(), channel.getCode());
    }

    private static ChannelColorRGB getColor(ImgChannelDTO channel) {
        return new ChannelColorRGB(channel.getRedColorComponent(), channel.getGreenColorComponent(), channel.getBlueColorComponent());
    }

    private ImageTransfomationFactories createImageTransfomationFactories(PrefixedImage imageDTO, ImgChannelDTO channel) {
        ImageTransfomationFactories imageTransfomationFactories = new ImageTransfomationFactories();
        imageTransfomationFactories.setForMergedChannels(this.tryGetImageTransformerFactoryForMergedChannels());
        Map<String, IImageTransformerFactory> singleChannelMap = this.getAvailableImageTransformationsForChannel(channel);
        imageTransfomationFactories.setForChannel(singleChannelMap);
        ImgImageTransformationDTO defaultTransformationOrNull = this.tryGetDefaultTransformation(channel);
        if (defaultTransformationOrNull != null) {
            imageTransfomationFactories.setDefaultTransformation(defaultTransformationOrNull.getCode(), defaultTransformationOrNull.getImageTransformerFactory());
        }
        imageTransfomationFactories.setForImage(imageDTO.tryGetImageTransformerFactory());
        return imageTransfomationFactories;
    }

    private Map<String, IImageTransformerFactory> getAvailableImageTransformationsForChannel(ImgChannelDTO channel) {
        List availableImageTransformations = (List)this.availableImageTransformationsMap.get(channel.getId());
        HashMap<String, IImageTransformerFactory> singleChannelMap = new HashMap<String, IImageTransformerFactory>();
        if (availableImageTransformations != null) {
            for (ImgImageTransformationDTO transformation : availableImageTransformations) {
                singleChannelMap.put(transformation.getCode(), transformation.getImageTransformerFactory());
            }
        }
        return singleChannelMap;
    }

    private ImgImageTransformationDTO tryGetDefaultTransformation(ImgChannelDTO channel) {
        List availableImageTransformations = (List)this.availableImageTransformationsMap.get(channel.getId());
        if (availableImageTransformations != null) {
            for (ImgImageTransformationDTO transformation : availableImageTransformations) {
                if (!transformation.getIsDefault()) continue;
                return transformation;
            }
        }
        return null;
    }

    private IImageTransformerFactory tryGetImageTransformerFactoryForMergedChannels() {
        IImageTransformerFactory imageTransformerFactory = this.dataset.tryGetImageTransformerFactory();
        if (imageTransformerFactory == null && this.experimentOrNull != null) {
            imageTransformerFactory = this.experimentOrNull.tryGetImageTransformerFactory();
        }
        return imageTransformerFactory;
    }

    private ImgChannelDTO tryLoadChannel(String chosenChannelCode) {
        ImgChannelDTO channel = this.query.tryGetChannelForDataset(this.dataset.getId(), chosenChannelCode);
        if (channel == null && this.containerOrNull != null) {
            channel = this.query.tryGetChannelForExperiment(this.containerOrNull.getExperimentId(), chosenChannelCode);
        }
        return channel;
    }

    private void validateChannelStackReference(ImageChannelStackReference channelStackReference) {
        ImageChannelStackReference.HCSChannelStackByLocationReference hcsRef = channelStackReference.tryGetHCSChannelStack();
        ImageChannelStackReference.MicroscopyChannelStackByLocationReference micRef = channelStackReference.tryGetMicroscopyChannelStack();
        if (hcsRef != null) {
            this.validateTileReference(hcsRef.getTileLocation());
            ImgContainerDTO container = this.tryGetContainer();
            if (container != null) {
                Location wellLocation = hcsRef.getWellLocation();
                if (wellLocation.getX() > container.getNumberOfColumns()) {
                    throw new IllegalArgumentException("Well column coordinate " + wellLocation.getX() + " is bigger then the number of plate's columns " + container.getNumberOfColumns());
                }
                if (wellLocation.getY() > container.getNumberOfRows()) {
                    throw new IllegalArgumentException("Well row coordinate " + wellLocation.getY() + " is bigger then the number of plate's rows " + container.getNumberOfRows());
                }
            }
        } else if (micRef != null) {
            this.validateTileReference(micRef.getTileLocation());
        }
    }

    private void validateTileReference(Location tileLocation) {
        if (tileLocation.getX() > this.getDataset().getFieldNumberOfColumns()) {
            throw new IllegalArgumentException("Tile x coordinate " + tileLocation.getX() + " is bigger then number of well's columns " + this.getDataset().getFieldNumberOfColumns());
        }
        if (tileLocation.getY() > this.getDataset().getFieldNumberOfRows()) {
            throw new IllegalArgumentException("Tile y coordinate " + tileLocation.getY() + " is bigger then number of well's rows " + this.getDataset().getFieldNumberOfRows());
        }
    }

    private PrefixedImage tryGetOriginalImage(long channelId, ImageChannelStackReference channelStackReference, long datasetId) {
        ImgImageDTO image;
        ImageChannelStackReference.HCSChannelStackByLocationReference hcsRef = channelStackReference.tryGetHCSChannelStack();
        ImageChannelStackReference.MicroscopyChannelStackByLocationReference micRef = channelStackReference.tryGetMicroscopyChannelStack();
        if (hcsRef != null) {
            image = this.query.tryGetHCSImage(channelId, datasetId, hcsRef.getTileLocation(), hcsRef.getWellLocation());
        } else if (micRef != null) {
            image = this.query.tryGetMicroscopyImage(channelId, datasetId, micRef.getTileLocation());
        } else {
            Long channelStackId = channelStackReference.tryGetChannelStackId();
            assert (channelStackId != null) : "invalid specification of the channel stack: " + (Object)((Object)channelStackReference);
            image = this.query.tryGetImage(channelId, channelStackId, datasetId);
        }
        return this.checkAccessability("", "", null, image);
    }

    private static ImgImageZoomLevelDTO selectBestZoomLevel(ImgImageZoomLevelDTO current, ImgImageZoomLevelDTO candidate, RequestedImageSize imageSize) {
        Size size = imageSize == null ? null : imageSize.tryGetThumbnailSize();
        Integer height = candidate.getHeight();
        Integer width = candidate.getWidth();
        if (size == null || width == null || height == null) {
            return current;
        }
        if (size.getHeight() <= height && size.getWidth() <= width) {
            if (current == null || current.getWidth() == null || current.getHeight() == null) {
                return candidate;
            }
            if (width <= current.getWidth() && height <= current.getHeight()) {
                return candidate;
            }
        }
        return current;
    }

    private static ImgImageZoomLevelDTO selectHighestZoomLevel(ImgImageZoomLevelDTO current, ImgImageZoomLevelDTO candidate) {
        Integer height = candidate.getHeight();
        Integer width = candidate.getWidth();
        if (current == null || current.getWidth() == null || current.getHeight() == null) {
            return candidate;
        }
        if (width == null || height == null) {
            return current;
        }
        if (width >= current.getWidth() && height >= current.getHeight()) {
            return candidate;
        }
        return current;
    }

    private PrefixedImage tryGetThumbnail(long channelId, ImageChannelStackReference channelStackReference, long datasetId, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNullOrNull) {
        ImgImageDTO image;
        ImageChannelStackReference.HCSChannelStackByLocationReference hcsRef = channelStackReference.tryGetHCSChannelStack();
        ImageChannelStackReference.MicroscopyChannelStackByLocationReference micRef = channelStackReference.tryGetMicroscopyChannelStack();
        String[] pathPrefixAndSuffix = this.findPathPrefixAndSuffix(datasetId, channelId, imageSize, singleChannelTransformationCodeOrNullOrNull);
        if (hcsRef != null) {
            image = this.query.tryGetHCSThumbnail(channelId, datasetId, hcsRef.getTileLocation(), hcsRef.getWellLocation());
        } else if (micRef != null) {
            image = this.query.tryGetMicroscopyThumbnail(channelId, datasetId, micRef.getTileLocation());
        } else {
            Long channelStackId = channelStackReference.tryGetChannelStackId();
            assert (channelStackId != null) : "invalid specification of the channel stack: " + (Object)((Object)channelStackReference);
            image = this.query.tryGetThumbnail(channelId, channelStackId, datasetId);
        }
        return this.checkAccessability(pathPrefixAndSuffix[0], pathPrefixAndSuffix[1], pathPrefixAndSuffix[2], image);
    }

    private String[] findPathPrefixAndSuffix(long datasetId, long channelId, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull) {
        String[] ret = new String[]{"", "", null};
        ImgImageZoomLevelDTO bestZoomLevel = null;
        List<ImgImageZoomLevelDTO> zoomLevels = this.query.listImageZoomLevels(datasetId);
        if (zoomLevels != null && zoomLevels.size() > 0) {
            if (singleChannelTransformationCodeOrNull != null) {
                List<ImgImageZoomLevelTransformationEnrichedDTO> zoomLevelTransformations = this.query.findImageZoomLevelTransformations(datasetId, channelId, singleChannelTransformationCodeOrNull);
                if (!zoomLevelTransformations.isEmpty()) {
                    HashSet<Long> zoomLevelsWithTransformedImages = new HashSet<Long>();
                    for (ImgImageZoomLevelTransformationEnrichedDTO zoomLevelTransformation : zoomLevelTransformations) {
                        zoomLevelsWithTransformedImages.add(zoomLevelTransformation.getImageZoomLevelId());
                    }
                    for (ImgImageZoomLevelDTO zoomLevel : zoomLevels) {
                        if (zoomLevel.getIsOriginal() || !zoomLevelsWithTransformedImages.contains(zoomLevel.getId())) continue;
                        bestZoomLevel = ImagingDatasetLoader.selectBestZoomLevel(bestZoomLevel, zoomLevel, imageSize);
                    }
                }
                if (bestZoomLevel != null) {
                    ret[2] = singleChannelTransformationCodeOrNull;
                }
            }
            if (bestZoomLevel == null) {
                zoomLevels = this.query.listImageZoomLevelsWithNoTransformations(datasetId);
                for (ImgImageZoomLevelDTO zoomLevel : zoomLevels) {
                    if (zoomLevel.getIsOriginal()) continue;
                    bestZoomLevel = ImagingDatasetLoader.selectBestZoomLevel(bestZoomLevel, zoomLevel, imageSize);
                }
            }
            if (bestZoomLevel == null) {
                for (ImgImageZoomLevelDTO zoomLevel : zoomLevels) {
                    if (zoomLevel.getIsOriginal()) continue;
                    bestZoomLevel = ImagingDatasetLoader.selectHighestZoomLevel(bestZoomLevel, zoomLevel);
                }
            }
        }
        if (bestZoomLevel != null && bestZoomLevel.getRootPath() != null) {
            ret[0] = bestZoomLevel.getRootPath();
            ret[1] = bestZoomLevel.getFileType();
        }
        return ret;
    }

    private PrefixedImage checkAccessability(String pathPrefix, String pathSuffix, String singleChannelTransformationCodeOrNull, ImgImageDTO imageOrNull) {
        if (imageOrNull == null) {
            return null;
        }
        return this.isFileAccessible(pathPrefix, pathSuffix, imageOrNull) ? new PrefixedImage(pathPrefix, pathSuffix, singleChannelTransformationCodeOrNull, imageOrNull) : null;
    }

    private boolean isFileAccessible(String pathPrefix, String pathSuffix, ImgImageDTO image) {
        String filePath = image.getFilePath();
        if (StringUtils.isNotBlank((String)pathPrefix)) {
            filePath = pathPrefix + "/" + filePath + (StringUtils.isBlank((String)pathSuffix) ? "" : "." + pathSuffix);
        }
        try {
            this.content.getNode(filePath);
            return true;
        }
        catch (IllegalArgumentException ex) {
            operationLog.warn((Object)String.format("Path '%s' is unaccessible, probably the dataset has been deleted and the imaging db is not yet synchronized.", filePath));
            return false;
        }
    }

    private PrefixedImage tryGetRepresentativeImageDTO(long channelId, Location wellLocationOrNull, boolean thumbnailWanted) {
        long datasetId = this.dataset.getId();
        ImgImageDTO image = null;
        if (wellLocationOrNull == null) {
            if (thumbnailWanted) {
                image = this.query.tryGetMicroscopyRepresentativeThumbnail(datasetId, channelId);
            }
            if (image == null) {
                image = this.query.tryGetMicroscopyRepresentativeImage(datasetId, channelId);
            }
        } else {
            if (thumbnailWanted) {
                image = this.query.tryGetHCSRepresentativeThumbnail(datasetId, wellLocationOrNull, channelId);
            }
            if (image == null) {
                image = this.query.tryGetHCSRepresentativeImage(datasetId, wellLocationOrNull, channelId);
            }
        }
        return this.checkAccessability("", "", null, image);
    }

    @Override
    public AbsoluteImageReference tryFindAnyOriginalImage() {
        List<ImgSpotDTO> wells = this.query.listWellsWithAnyImages(this.dataset.getId());
        List<String> channelCodes = this.getImageParameters().getChannelsCodes();
        RequestedImageSize originalOrThumbnail = RequestedImageSize.createOriginal();
        for (ImgSpotDTO well : wells) {
            for (String channelCode : channelCodes) {
                AbsoluteImageReference image = this.tryGetRepresentativeImage(channelCode, new Location(well.getColumn().intValue(), well.getRow().intValue()), originalOrThumbnail, null);
                if (image == null) continue;
                return image;
            }
        }
        return null;
    }

    @Override
    public AbsoluteImageReference tryGetRepresentativeImage(String channelCode, Location wellLocationOrNull, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull) {
        ImgChannelDTO channel = this.tryLoadChannel(channelCode);
        if (channel == null) {
            return null;
        }
        PrefixedImage imageDTO = this.tryGetRepresentativeImageDTO(channel.getId(), wellLocationOrNull, imageSize.isThumbnailRequired());
        if (imageDTO == null) {
            return null;
        }
        boolean useNativeImageLibrary = false;
        return this.createAbsoluteImageReference(imageDTO, channel, imageSize, useNativeImageLibrary);
    }

    private PrefixedImage tryGetRepresentativeThumbnailImageDTO(long channelId, Location wellLocationOrNull, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull) {
        long datasetId = this.getDataset().getId();
        String[] pathPrefixAndSuffix = this.findPathPrefixAndSuffix(datasetId, channelId, imageSize, singleChannelTransformationCodeOrNull);
        ImgImageDTO image = wellLocationOrNull == null ? this.query.tryGetMicroscopyRepresentativeThumbnail(this.dataset.getId(), channelId) : this.query.tryGetHCSRepresentativeThumbnail(this.dataset.getId(), wellLocationOrNull, channelId);
        return this.checkAccessability(pathPrefixAndSuffix[0], pathPrefixAndSuffix[1], pathPrefixAndSuffix[2], image);
    }

    @Override
    public AbsoluteImageReference tryFindAnyThumbnail() {
        List<ImgSpotDTO> wells = this.query.listWellsWithAnyThumbnails(this.dataset.getId());
        List<String> channelCodes = this.getImageParameters().getChannelsCodes();
        for (ImgSpotDTO well : wells) {
            for (String channelCode : channelCodes) {
                AbsoluteImageReference image = this.tryGetRepresentativeThumbnail(channelCode, new Location(well.getColumn().intValue(), well.getRow().intValue()), null, null);
                if (image == null) continue;
                return image;
            }
        }
        return null;
    }

    @Override
    public AbsoluteImageReference tryGetRepresentativeThumbnail(String channelCode, Location wellLocationOrNull, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull) {
        ImgChannelDTO channel = this.tryLoadChannel(channelCode);
        if (channel == null) {
            return null;
        }
        PrefixedImage imageDTO = this.tryGetRepresentativeThumbnailImageDTO(channel.getId(), wellLocationOrNull, imageSize, singleChannelTransformationCodeOrNull);
        if (imageDTO == null) {
            return null;
        }
        return this.createAbsoluteImageReference(imageDTO, channel, new RequestedImageSize(Size.NULL_SIZE, false), true);
    }

    @Override
    public AbsoluteImageReference tryGetThumbnail(String channelCode, ImageChannelStackReference channelStackReference, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)channelCode)) {
            throw new UserFailureException("Unspecified channel.");
        }
        this.validateChannelStackReference(channelStackReference);
        ImgChannelDTO channel = this.tryLoadChannel(channelCode);
        if (channel == null) {
            return null;
        }
        long datasetId = this.getDataset().getId();
        PrefixedImage thumbnailDTO = this.tryGetThumbnail(channel.getId(), channelStackReference, datasetId, imageSize, singleChannelTransformationCodeOrNull);
        if (thumbnailDTO == null) {
            return null;
        }
        return this.createAbsoluteImageReference(thumbnailDTO, channel, RequestedImageSize.createOriginal(), true);
    }
}

