/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;

public enum ChannelColor {
    BLUE(0),
    GREEN(1),
    RED(2),
    RED_GREEN(3),
    RED_BLUE(4),
    GREEN_BLUE(5);

    private static final int MAX_COLOR;
    private final int orderIndex;

    private ChannelColor(int orderIndex) {
        this.orderIndex = orderIndex;
    }

    private static int calcMaxColorIndex() {
        int max = 0;
        for (ChannelColor color : ChannelColor.values()) {
            max = Math.max(max, color.getColorOrderIndex());
        }
        return max;
    }

    public int getColorOrderIndex() {
        return this.orderIndex;
    }

    public static ChannelColor createFromIndex(int colorIndex) {
        for (ChannelColor color : ChannelColor.values()) {
            if (color.getColorOrderIndex() != colorIndex % (MAX_COLOR + 1)) continue;
            return color;
        }
        throw new IllegalStateException("Invalid color index: " + colorIndex + "!");
    }

    public ChannelColorRGB getRGB() {
        switch (this) {
            case RED: {
                return new ChannelColorRGB(255, 0, 0);
            }
            case GREEN: {
                return new ChannelColorRGB(0, 255, 0);
            }
            case BLUE: {
                return new ChannelColorRGB(0, 0, 255);
            }
            case RED_GREEN: {
                return new ChannelColorRGB(255, 255, 0);
            }
            case GREEN_BLUE: {
                return new ChannelColorRGB(0, 255, 255);
            }
            case RED_BLUE: {
                return new ChannelColorRGB(255, 0, 255);
            }
        }
        throw new IllegalStateException("unhandled enum " + (Object)((Object)this));
    }

    static {
        MAX_COLOR = ChannelColor.calcMaxColorIndex();
    }
}

