/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.io.Serializable;

public class ImageFileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WellLocation wellLocationOrNull;
    private Location tileLocation;
    private String channelCode;
    private final String imageRelativePath;
    private Float timepointOrNull;
    private Float depthOrNull;
    private Integer seriesNumberOrNull;
    private ImageIdentifier imageIdentifier;
    private String uniqueImageIdentifier;
    private String containerDataSetCode;

    public ImageFileInfo(String channelCode, int tileRow, int tileColumn, String imageRelativePath) {
        assert (channelCode != null);
        assert (imageRelativePath != null);
        this.channelCode = channelCode;
        this.imageRelativePath = imageRelativePath;
        this.setTile(tileRow, tileColumn);
    }

    public String tryGetUniqueStringIdentifier() {
        if (this.imageIdentifier != null) {
            return this.imageIdentifier.getUniqueStringIdentifier();
        }
        if (this.uniqueImageIdentifier != null) {
            return this.uniqueImageIdentifier;
        }
        return null;
    }

    public Integer tryGetWellRow() {
        return this.wellLocationOrNull == null ? null : Integer.valueOf(this.wellLocationOrNull.getRow());
    }

    public Integer tryGetWellColumn() {
        return this.wellLocationOrNull == null ? null : Integer.valueOf(this.wellLocationOrNull.getColumn());
    }

    public WellLocation tryGetWellLocation() {
        return this.wellLocationOrNull;
    }

    public boolean hasWellLocation() {
        return this.wellLocationOrNull != null;
    }

    public int getTileRow() {
        return this.tileLocation.getY();
    }

    public int getTileColumn() {
        return this.tileLocation.getX();
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public String getImageRelativePath() {
        return this.imageRelativePath;
    }

    public Float tryGetTimepoint() {
        return this.timepointOrNull;
    }

    public Float tryGetDepth() {
        return this.depthOrNull;
    }

    public Integer tryGetSeriesNumber() {
        return this.seriesNumberOrNull;
    }

    public void setImageIdentifier(ImageIdentifier imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public void setWell(int row, int column) {
        this.wellLocationOrNull = new WellLocation(row, column);
    }

    public boolean setWell(String wellText) {
        try {
            this.wellLocationOrNull = WellLocation.parseLocationStr(wellText);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.wellLocationOrNull != null;
    }

    public void setTile(int row, int column) {
        this.tileLocation = Location.createLocationFromRowAndColumn((int)row, (int)column);
    }

    public void setTimepoint(Float value) {
        this.timepointOrNull = value;
    }

    public void setDepth(Float value) {
        this.depthOrNull = value;
    }

    public void setSeriesNumber(Integer value) {
        this.seriesNumberOrNull = value;
    }

    public void setUniqueImageIdentifier(String uniqueImageIdentifier) {
        this.uniqueImageIdentifier = uniqueImageIdentifier;
    }

    public String getContainerDataSetCode() {
        return this.containerDataSetCode;
    }

    public void setContainerDataSetCode(String containerDataSetCode) {
        this.containerDataSetCode = containerDataSetCode;
    }

    public String toString() {
        return "ImageFileInfo [well=" + this.wellLocationOrNull + ", tile=" + this.tileLocation + ", channel=" + this.channelCode + ", path=" + this.imageRelativePath + ", timepoint=" + this.timepointOrNull + ", depth=" + this.depthOrNull + ", seriesNumber=" + this.seriesNumberOrNull + "]";
    }
}

