/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThumbnailsStorageFormat
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_THUMBNAIL_MAX_SIZE = 200;
    public static final boolean DEFAULT_COMPRESS_THUMBNAILS = false;
    private int maxWidth = 200;
    private int maxHeight = 200;
    private boolean allowEnlarging = true;
    private Double zoomLevel = null;
    private boolean storeCompressed = false;
    private double allowedMachineLoadDuringGeneration = 1.0;
    private boolean highQuality8Bit = false;
    private boolean generateWithImageMagic = false;
    private List<String> imageMagicParams = Collections.emptyList();
    private String thumbnailsFileName;
    private FileFormat fileFormat = FileFormat.PNG;
    private final Map<String, String> transformations = new HashMap<String, String>();

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public boolean isStoreCompressed() {
        return this.storeCompressed;
    }

    public double getAllowedMachineLoadDuringGeneration() {
        return this.allowedMachineLoadDuringGeneration;
    }

    public boolean isHighQuality() {
        return this.highQuality8Bit;
    }

    public boolean isGenerateWithImageMagic() {
        return this.generateWithImageMagic;
    }

    public List<String> getImageMagicParams() {
        return this.imageMagicParams;
    }

    public boolean isAllowEnlarging() {
        return this.allowEnlarging;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setStoreCompressed(boolean storeCompressed) {
        this.storeCompressed = storeCompressed;
    }

    public void setAllowEnlarging(boolean allowEnlarging) {
        this.allowEnlarging = allowEnlarging;
    }

    public void setAllowedMachineLoadDuringGeneration(double machineLoad) {
        this.allowedMachineLoadDuringGeneration = machineLoad;
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality8Bit = highQuality;
    }

    public void setGenerateWithImageMagic(boolean generateWithImageMagic) {
        this.generateWithImageMagic = generateWithImageMagic;
    }

    public void setImageMagicParams(List<String> imageMagicParams) {
        this.imageMagicParams = imageMagicParams;
    }

    public Double getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(Double zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public String getThumbnailsFileName() {
        return this.thumbnailsFileName == null ? "thumbnails.h5ar" : this.thumbnailsFileName;
    }

    public void setThumbnailsFileName(String thumbnailsFileName) {
        this.thumbnailsFileName = thumbnailsFileName;
    }

    public void setFileFormat(String fileFormat) {
        FileFormat value = FileFormat.getValue(fileFormat);
        if (value == null) {
            throw new IllegalArgumentException("File format '" + fileFormat + "' is unknown");
        }
        this.fileFormat = value;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setTransformations(Map<String, String> transformations) {
        this.transformations.putAll(transformations);
    }

    public String getTransformationCode(String channelCode) {
        return this.transformations.get(channelCode.toUpperCase());
    }

    public Map<String, String> getTransformations() {
        return this.transformations;
    }

    public static enum FileFormat {
        PNG{

            @Override
            public void writeImage(BufferedImage image, OutputStream stream) {
                ImageUtil.writeImageToPng((BufferedImage)image, (OutputStream)stream);
            }

            @Override
            public String getFileExtension() {
                return "png";
            }

            @Override
            public String getImageMagickParam() {
                return "png";
            }
        }
        ,
        JPEG{

            @Override
            public void writeImage(BufferedImage image, OutputStream stream) {
                ImageUtil.writeImageUsingImageIO((BufferedImage)image, (OutputStream)stream, (String)"jpg");
            }

            @Override
            public String getFileExtension() {
                return "jpg";
            }

            @Override
            public String getImageMagickParam() {
                return "jpeg";
            }
        }
        ,
        JPEG_2000{

            @Override
            public void writeImage(BufferedImage image, OutputStream stream) {
                ImageUtil.writeImageUsingImageIO((BufferedImage)image, (OutputStream)stream, (String)"jpeg 2000");
            }

            @Override
            public String getFileExtension() {
                return "jp2";
            }

            @Override
            public String getImageMagickParam() {
                return "jp2";
            }
        };

        private static final Map<String, FileFormat> formats;

        public abstract void writeImage(BufferedImage var1, OutputStream var2);

        public abstract String getFileExtension();

        public abstract String getImageMagickParam();

        public String getOpenBISFileType() {
            return this.getFileExtension().toUpperCase();
        }

        public static FileFormat getValue(String fileFormat) {
            return formats.get(fileFormat.toUpperCase());
        }

        static {
            formats = new HashMap<String, FileFormat>();
            for (FileFormat format : FileFormat.values()) {
                formats.put(format.name().toUpperCase(), format);
            }
            formats.put("JP2", JPEG_2000);
            formats.put("JPEG 2000", JPEG_2000);
            formats.put("JPG", JPEG);
        }
    }
}

