/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.impl;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.IFeatureDefinition;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CanonicalFeatureVector;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.FeatureValuesMap;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateFeatureValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureValuesDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureVocabularyTermDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureDefinition
implements IFeatureDefinition,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImgFeatureDefDTO imgFeatureDefDTO;
    private final List<FeatureValuesMap> values;
    private FeatureValuesMap currentFeatureVector;

    public FeatureDefinition(ImgFeatureDefDTO imgFeatureDefDTO) {
        this(imgFeatureDefDTO, new FeatureValuesMap(null, null));
    }

    public FeatureDefinition(ImgFeatureDefDTO imgFeatureDefDTO, FeatureValuesMap currentFeatureVector) {
        assert (imgFeatureDefDTO != null) : "featureDefinition is null";
        this.imgFeatureDefDTO = imgFeatureDefDTO;
        this.values = new ArrayList<FeatureValuesMap>();
        this.currentFeatureVector = currentFeatureVector;
    }

    @Override
    public void changeSeries(Double timeOrNull, Double depthOrNull) {
        this.flushCurrent();
        this.currentFeatureVector = new FeatureValuesMap(timeOrNull, depthOrNull);
    }

    private void flushCurrent() {
        if (this.currentFeatureVector != null && !this.currentFeatureVector.isEmpty()) {
            this.values.add(this.currentFeatureVector);
            this.currentFeatureVector = null;
        }
    }

    @Override
    public void setFeatureLabel(String label) {
        this.imgFeatureDefDTO.setLabel(label);
    }

    public String getFeatureLabel() {
        return this.imgFeatureDefDTO.getLabel();
    }

    @Override
    public void setFeatureDescription(String description) {
        this.imgFeatureDefDTO.setDescription(description);
    }

    @Override
    public void addValue(String well, String value) {
        WellLocation wellPos = WellLocation.parseLocationStr(well);
        this.addValueToCurrent(value, wellPos);
    }

    @Override
    public void addValue(int wellRow, int wellColumn, String value) {
        WellLocation wellPos = new WellLocation(wellRow, wellColumn);
        this.addValueToCurrent(value, wellPos);
    }

    private void addValueToCurrent(String value, WellLocation wellPos) {
        this.currentFeatureVector.addValue(value, wellPos);
    }

    private void validate(Geometry plateGeometry) {
        for (FeatureValuesMap valuesMap : this.values) {
            valuesMap.validate(plateGeometry);
        }
    }

    public CanonicalFeatureVector getCanonicalFeatureVector(Geometry plateGeometry) {
        this.flushCurrent();
        this.validate(plateGeometry);
        CanonicalFeatureVector canonicalFeatureVector = new CanonicalFeatureVector();
        canonicalFeatureVector.setFeatureDef(this.imgFeatureDefDTO);
        Set<String> uniqueValues = this.getUniqueAvailableValues();
        Map<String, Integer> termToSequanceMap = FeatureDefinition.fixVocabularyTermSequences(uniqueValues);
        List<ImgFeatureVocabularyTermDTO> vocabularyTerms = null;
        List<Map<WellLocation, Float>> floatValuesList = this.tryCreateFloatValueList();
        if (floatValuesList == null) {
            floatValuesList = this.calculateWellTermsMappingList(termToSequanceMap);
            vocabularyTerms = FeatureDefinition.tryCreateVocabularyTerms(termToSequanceMap);
        }
        List<ImgFeatureValuesDTO> featureDTOs = this.createValueDTOs(plateGeometry, floatValuesList);
        canonicalFeatureVector.setValues(featureDTOs);
        canonicalFeatureVector.setVocabularyTerms(vocabularyTerms);
        return canonicalFeatureVector;
    }

    private List<ImgFeatureValuesDTO> createValueDTOs(Geometry plateGeometry, List<Map<WellLocation, Float>> floatValuesList) {
        ArrayList<ImgFeatureValuesDTO> featureDTOs = new ArrayList<ImgFeatureValuesDTO>();
        for (int i = 0; i < this.values.size(); ++i) {
            FeatureValuesMap featureValuesMap = this.values.get(i);
            Map<WellLocation, Float> floatValues = floatValuesList.get(i);
            ImgFeatureValuesDTO featureValuesDTO = FeatureDefinition.createFeatureValuesDTO(plateGeometry, featureValuesMap, floatValues);
            featureDTOs.add(featureValuesDTO);
        }
        return featureDTOs;
    }

    private static ImgFeatureValuesDTO createFeatureValuesDTO(Geometry plateGeometry, FeatureValuesMap featureValuesMap, Map<WellLocation, Float> floatValues) {
        PlateFeatureValues valuesValues = FeatureDefinition.convertColumnToByteArray(plateGeometry, floatValues);
        ImgFeatureValuesDTO featureValuesDTO = new ImgFeatureValuesDTO(featureValuesMap.tryGetTime(), featureValuesMap.tryGetDepth(), valuesValues, 0L);
        return featureValuesDTO;
    }

    private static PlateFeatureValues convertColumnToByteArray(Geometry geometry, Map<WellLocation, Float> values) {
        PlateFeatureValues featureValues = new PlateFeatureValues(geometry);
        for (WellLocation loc : values.keySet()) {
            Float value = values.get(loc);
            featureValues.setForWellLocation(value.floatValue(), loc);
        }
        return featureValues;
    }

    private List<Map<WellLocation, Float>> calculateWellTermsMappingList(Map<String, Integer> termToSequanceMap) {
        ArrayList<Map<WellLocation, Float>> list = new ArrayList<Map<WellLocation, Float>>();
        for (FeatureValuesMap featureValuesMap : this.values) {
            Map<WellLocation, Float> floatValues = featureValuesMap.calculateWellTermsMapping(termToSequanceMap);
            list.add(floatValues);
        }
        return list;
    }

    private List<Map<WellLocation, Float>> tryCreateFloatValueList() {
        ArrayList<Map<WellLocation, Float>> list = new ArrayList<Map<WellLocation, Float>>();
        for (FeatureValuesMap featureValuesMap : this.values) {
            Map<WellLocation, Float> floatValues = featureValuesMap.tryExtractFloatValues();
            if (floatValues == null) {
                return null;
            }
            list.add(floatValues);
        }
        return list;
    }

    private static List<ImgFeatureVocabularyTermDTO> tryCreateVocabularyTerms(Map<String, Integer> valueToSequanceMap) {
        if (valueToSequanceMap.isEmpty()) {
            return null;
        }
        ArrayList<ImgFeatureVocabularyTermDTO> vocabularyTerms = new ArrayList<ImgFeatureVocabularyTermDTO>();
        for (Map.Entry<String, Integer> entry : valueToSequanceMap.entrySet()) {
            vocabularyTerms.add(new ImgFeatureVocabularyTermDTO(entry.getKey(), entry.getValue()));
        }
        return vocabularyTerms;
    }

    private static Map<String, Integer> fixVocabularyTermSequences(Set<String> uniqueValues) {
        HashMap<String, Integer> valueToSequanceMap = new HashMap<String, Integer>();
        int sequenceNumber = 0;
        for (String value : uniqueValues) {
            valueToSequanceMap.put(value, sequenceNumber++);
        }
        return valueToSequanceMap;
    }

    private Set<String> getUniqueAvailableValues() {
        List<FeatureValuesMap> valuesMaps = this.values;
        HashSet<String> uniqueValues = new HashSet<String>();
        for (FeatureValuesMap valuesMap : valuesMaps) {
            uniqueValues.addAll(valuesMap.getUniqueAvailableValues());
        }
        return uniqueValues;
    }
}

