/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.impl;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSet;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.Hdf5ThumbnailGenerator;
import ch.systemsx.cisd.openbis.dss.etl.IImageProvider;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.IImageGenerationAlgorithm;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ThumbnailsInfo;
import ch.systemsx.cisd.openbis.dss.generic.server.images.ImageChannelsUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaximumIntensityProjectionGenerationAlgorithm
implements IImageGenerationAlgorithm,
Serializable {
    public static final String DEFAULT_FILE_NAME = "maximum_intensity_projection.png";
    private static final long serialVersionUID = 35L;
    private transient BufferedImage result = null;
    private String dataSetTypeCode;
    private String filename;
    private int width;
    private int height;
    private boolean useThumbnails;
    private IHierarchicalContent content;

    public MaximumIntensityProjectionGenerationAlgorithm(String dataSetTypeCode) {
        this(dataSetTypeCode, 0, 0);
    }

    public MaximumIntensityProjectionGenerationAlgorithm(String dataSetTypeCode, String filename) {
        this(dataSetTypeCode, 0, 0, filename);
    }

    public MaximumIntensityProjectionGenerationAlgorithm(String dataSetTypeCode, int width, int height) {
        this(dataSetTypeCode, width, height, DEFAULT_FILE_NAME);
    }

    public MaximumIntensityProjectionGenerationAlgorithm(String dataSetTypeCode, int width, int height, String filename) {
        this.dataSetTypeCode = dataSetTypeCode;
        this.width = width;
        this.height = height;
        this.filename = filename;
    }

    public MaximumIntensityProjectionGenerationAlgorithm useThumbnails() {
        this.useThumbnails = true;
        return this;
    }

    @Override
    public String getDataSetTypeCode() {
        return this.dataSetTypeCode;
    }

    @Override
    public List<BufferedImage> generateImages(ImageDataSetInformation information, List<IDataSet> thumbnailDatasets, IImageProvider imageProvider) {
        ImageDataSetStructure structure = information.getImageDataSetStructure();
        ImageLibraryInfo library = structure.getImageStorageConfiguraton().tryGetImageLibrary();
        List<ImageFileInfo> images = structure.getImages();
        Map<String, ChannelAndColorComponent> channelsByCode = this.getChannelsByCode(structure);
        File incomingDirectory = information.getIncomingDirectory();
        File thumbnailDataSet = this.tryFindMatchingThumbnailDataSet(information, thumbnailDatasets);
        int maxIntensity = 0;
        for (ImageFileInfo imageFileInfo : images) {
            if (this.imageToBeIgnored(imageFileInfo)) continue;
            String channelCode = imageFileInfo.getChannelCode();
            ChannelAndColorComponent channelAndColorComponent = channelsByCode.get(channelCode);
            BufferedImage image = this.loadImage(imageProvider, library, images, incomingDirectory, thumbnailDataSet, imageFileInfo, channelCode);
            image = ImageChannelsUtils.rescaleIfNot8Bit(image, Float.valueOf(0.0f), channelAndColorComponent.channel.tryGetChannelColor());
            image = ImageChannelsUtils.extractChannel(image, channelAndColorComponent.colorComponent);
            image = ImageChannelsUtils.transformGrayToColor(image, channelAndColorComponent.channel.tryGetChannelColor());
            maxIntensity = this.addImage(image);
        }
        if (this.result == null) {
            return Collections.emptyList();
        }
        for (int y = 0; y < this.result.getHeight(); ++y) {
            for (int x = 0; x < this.result.getWidth(); ++x) {
                this.result.setRGB(x, y, this.adjust(this.result.getRGB(x, y), maxIntensity));
            }
        }
        if (this.width > 0 && this.height > 0) {
            BufferedImage scaled = new BufferedImage(this.width, this.height, 2);
            AffineTransform at = new AffineTransform();
            at.scale((double)this.width / (double)this.result.getWidth(), (double)this.height / (double)this.result.getHeight());
            AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
            this.result = scaleOp.filter(this.result, scaled);
        }
        return Collections.singletonList(this.result);
    }

    private BufferedImage loadImage(IImageProvider imageProvider, ImageLibraryInfo library, List<ImageFileInfo> images, File incomingDirectory, File thumbnailDataSet, ImageFileInfo imageFileInfo, String channelCode) {
        String imagePath = imageFileInfo.getImageRelativePath();
        String identifier = imageFileInfo.tryGetUniqueStringIdentifier();
        BufferedImage image = null;
        if (thumbnailDataSet != null && this.useThumbnails) {
            IHierarchicalContent content = new DefaultFileBasedHierarchicalContentFactory().asHierarchicalContent(thumbnailDataSet, null);
            String thumbnailPath = Hdf5ThumbnailGenerator.createThumbnailPath(imageFileInfo, channelCode);
            IHierarchicalContentNode rootNode = content.getRootNode();
            String containerPath = ((IHierarchicalContentNode)rootNode.getChildNodes().get(0)).getRelativePath();
            IHierarchicalContentNode node = content.tryGetNode(containerPath + "/" + thumbnailPath + ".png");
            if (node != null) {
                image = imageProvider.getImage(node, images.get(0).tryGetUniqueStringIdentifier(), null);
            }
        }
        if (image == null) {
            image = this.loadImage(imageProvider, incomingDirectory, imagePath, identifier, library);
        }
        return image;
    }

    private File tryFindMatchingThumbnailDataSet(ImageDataSetInformation information, List<IDataSet> thumbnailDatasets) {
        ThumbnailsInfo thumbnailsInfos = information.getThumbnailsInfos();
        if (thumbnailsInfos != null) {
            for (String permId : thumbnailsInfos.getThumbnailPhysicalDatasetsPermIds()) {
                IDataSet thumbnailDataSet;
                Size dimension = thumbnailsInfos.tryGetDimension(permId);
                if (dimension == null || dimension.getWidth() != this.width && dimension.getHeight() != this.height || !((thumbnailDataSet = this.tryFindDataSetByPermId(thumbnailDatasets, permId)) instanceof DataSet)) continue;
                return ((DataSet)thumbnailDataSet).getDataSetStagingFolder();
            }
        }
        return null;
    }

    private IDataSet tryFindDataSetByPermId(List<IDataSet> dataSets, String permId) {
        for (IDataSet dataSet : dataSets) {
            if (!dataSet.getDataSetCode().equals(permId)) continue;
            return dataSet;
        }
        return null;
    }

    @Private
    BufferedImage loadImage(IImageProvider imageProvider, File incomingDirectory, String imagePath, String identifier, ImageLibraryInfo library) {
        IHierarchicalContentNode contentNode = this.createContentNode(incomingDirectory, imagePath);
        return imageProvider.getImage(contentNode, identifier, library);
    }

    private IHierarchicalContentNode createContentNode(File incomingDirectory, String imagePath) {
        if (this.content == null) {
            return new FileBasedContentNode(new File(incomingDirectory, imagePath));
        }
        return this.content.getNode(imagePath);
    }

    @Override
    public void setContent(IHierarchicalContent content) {
        this.content = content;
    }

    protected boolean imageToBeIgnored(ImageFileInfo image) {
        return image.tryGetTimepoint() == null || image.tryGetTimepoint().floatValue() != 0.0f;
    }

    private Map<String, ChannelAndColorComponent> getChannelsByCode(ImageDataSetStructure structure) {
        HashMap<String, ChannelAndColorComponent> channelsByCode = new HashMap<String, ChannelAndColorComponent>();
        List<Channel> channels = structure.getChannels();
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = channels.get(i);
            ColorComponent colorComponent = this.tryGetColorComponent(structure, i);
            channelsByCode.put(channel.getCode(), new ChannelAndColorComponent(channel, colorComponent));
        }
        return channelsByCode;
    }

    private ColorComponent tryGetColorComponent(ImageDataSetStructure structure, int i) {
        List<ChannelColorComponent> channelColorComponents = structure.getChannelColorComponents();
        if (channelColorComponents == null || channelColorComponents.isEmpty()) {
            return null;
        }
        return ChannelColorComponent.getColorComponent(channelColorComponents.get(i));
    }

    private int adjust(int rgb, int maximumIntensity) {
        int maxIntensity = Math.min(255, maximumIntensity);
        int r = this.rescale(this.getRed(rgb), maxIntensity);
        int g = this.rescale(this.getGreen(rgb), maxIntensity);
        int b = this.rescale(this.getBlue(rgb), maxIntensity);
        return (r << 16) + (g << 8) + b;
    }

    private int rescale(int intensity, int maxIntensity) {
        return maxIntensity == 0 ? 0 : (intensity * 255 + maxIntensity / 2) / maxIntensity;
    }

    private int addImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        if (this.result == null) {
            this.result = new BufferedImage(w, h, 1);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    this.result.setRGB(x, y, 0);
                }
            }
        }
        int maxIntensity = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int rgb1 = this.result.getRGB(x, y);
                int rgb2 = image.getRGB(x, y);
                int intensity1 = this.intensity(rgb1);
                int intensity2 = this.intensity(rgb2);
                maxIntensity = Math.max(Math.max(maxIntensity, intensity1), intensity2);
                this.result.setRGB(x, y, intensity1 > intensity2 ? rgb1 : rgb2);
            }
        }
        return maxIntensity;
    }

    private int intensity(int rgb) {
        double r = this.getRed(rgb);
        double g = this.getGreen(rgb);
        double b = this.getBlue(rgb);
        return new Double(Math.sqrt(r * r + g * g + b * b)).intValue();
    }

    private int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    private int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    private int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    @Override
    public String getImageFileName(int index) {
        return this.filename;
    }

    private static final class ChannelAndColorComponent {
        private Channel channel;
        private ColorComponent colorComponent;

        ChannelAndColorComponent(Channel channel, ColorComponent colorComponent) {
            this.channel = channel;
            this.colorComponent = colorComponent;
        }
    }
}

