/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.v1.transformations;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import java.awt.image.BufferedImage;

@JsonObject(value="AutoRescaleIntensityImageTransformerFactory_obsolete")
public class AutoRescaleIntensityImageTransformerFactory
implements IImageTransformerFactory {
    private static final long serialVersionUID = 1L;
    private final float threshold;

    public AutoRescaleIntensityImageTransformerFactory(float threshold) {
        this.threshold = threshold;
    }

    public IImageTransformer createTransformer() {
        return new IImageTransformer(){

            public BufferedImage transform(BufferedImage image) {
                if (IntensityRescaling.isNotGrayscale((BufferedImage)image)) {
                    IntensityRescaling.Channel channel = ImageUtil.getRepresentativeChannelIfEffectiveGray((BufferedImage)image);
                    if (channel == null) {
                        return image;
                    }
                    IntensityRescaling.Pixels pixels = DssScreeningUtils.createPixels(image);
                    IntensityRescaling.Levels levels = IntensityRescaling.computeLevels((IntensityRescaling.Pixels)pixels, (float)AutoRescaleIntensityImageTransformerFactory.this.threshold, (IntensityRescaling.Channel[])new IntensityRescaling.Channel[]{channel});
                    return IntensityRescaling.rescaleIntensityLevelTo8Bits((IntensityRescaling.Pixels)pixels, (IntensityRescaling.Levels)levels, (IntensityRescaling.Channel[])IntensityRescaling.Channel.values());
                }
                IntensityRescaling.Pixels pixels = DssScreeningUtils.createPixels(image);
                IntensityRescaling.Levels levels = IntensityRescaling.computeLevels((IntensityRescaling.Pixels)pixels, (float)AutoRescaleIntensityImageTransformerFactory.this.threshold, (IntensityRescaling.Channel[])new IntensityRescaling.Channel[]{IntensityRescaling.Channel.RED});
                return IntensityRescaling.rescaleIntensityLevelTo8Bits((IntensityRescaling.Pixels)pixels, (IntensityRescaling.Levels)levels, (IntensityRescaling.Channel[])new IntensityRescaling.Channel[]{IntensityRescaling.Channel.RED});
            }
        };
    }
}

