/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.v1.transformations;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import java.awt.image.BufferedImage;
import java.util.EnumSet;

@JsonObject(value="IntensityRangeImageTransformerFactory_obsolete")
public class IntensityRangeImageTransformerFactory
implements IImageTransformerFactory {
    private static final long serialVersionUID = 1L;
    private final int blackPointIntensity;
    private final int whitePointIntensity;

    public IntensityRangeImageTransformerFactory(int blackPointIntensity, int whitePointIntensity) {
        this.blackPointIntensity = blackPointIntensity;
        this.whitePointIntensity = whitePointIntensity;
    }

    public int getBlackPointIntensity() {
        return this.blackPointIntensity;
    }

    public int getWhitePointIntensity() {
        return this.whitePointIntensity;
    }

    public IImageTransformer createTransformer() {
        return new IImageTransformer(){

            public BufferedImage transform(BufferedImage image) {
                if (IntensityRescaling.isNotGrayscale((BufferedImage)image)) {
                    EnumSet channels = IntensityRescaling.getUsedRgbChannels((BufferedImage)image);
                    if (channels.size() != 1) {
                        return image;
                    }
                    IntensityRescaling.Levels levels = new IntensityRescaling.Levels(IntensityRangeImageTransformerFactory.this.blackPointIntensity, IntensityRangeImageTransformerFactory.this.whitePointIntensity);
                    IntensityRescaling.Pixels pixels = DssScreeningUtils.createPixels(image);
                    return IntensityRescaling.rescaleIntensityLevelTo8Bits((IntensityRescaling.Pixels)pixels, (IntensityRescaling.Levels)levels, (IntensityRescaling.Channel[])new IntensityRescaling.Channel[]{(IntensityRescaling.Channel)channels.iterator().next()});
                }
                IntensityRescaling.Levels levels = new IntensityRescaling.Levels(IntensityRangeImageTransformerFactory.this.blackPointIntensity, IntensityRangeImageTransformerFactory.this.whitePointIntensity);
                IntensityRescaling.Pixels pixels = DssScreeningUtils.createPixels(image);
                return IntensityRescaling.rescaleIntensityLevelTo8Bits((IntensityRescaling.Pixels)pixels, (IntensityRescaling.Levels)levels, (IntensityRescaling.Channel[])IntensityRescaling.Channel.values());
            }
        };
    }
}

