/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.featurevector;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.common.utilities.Counters;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureDefinition;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.FeatureValuesMap;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.FeatureVectorStorageProcessorConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CodeAndLabelUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CsvFileReaderHelper;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CsvFeatureVectorParser {
    private final CsvFeatureVectorParserConfiguration configuration;
    private final String[] header;
    private final List<String[]> lines;
    private final ArrayList<FeatureColumn> columns = new ArrayList();
    private int xColumn = -1;
    private int yColumn = -1;
    private int maxRowFound = 0;
    private int maxColFound = 0;

    public static List<FeatureDefinition> parse(File dataSet, Properties properties) throws IOException {
        FeatureVectorStorageProcessorConfiguration storageProcessorConfiguration = new FeatureVectorStorageProcessorConfiguration(properties);
        return CsvFeatureVectorParser.parse(dataSet, storageProcessorConfiguration);
    }

    public static List<FeatureDefinition> parse(File dataSet, FeatureVectorStorageProcessorConfiguration configuration) throws IOException {
        CsvFeatureVectorParserConfiguration convertorConfig = new CsvFeatureVectorParserConfiguration(configuration);
        DatasetFileLines datasetFileLines = CsvFileReaderHelper.getDatasetFileLines((File)dataSet, (CsvFileReaderHelper.ICsvFileReaderConfiguration)configuration);
        CsvFeatureVectorParser parser = new CsvFeatureVectorParser(datasetFileLines, convertorConfig);
        return parser.parse();
    }

    public CsvFeatureVectorParser(DatasetFileLines fileLines, CsvFeatureVectorParserConfiguration config) {
        this.configuration = config;
        this.header = fileLines.getHeaderLabels();
        this.lines = fileLines.getDataLines();
    }

    public List<FeatureDefinition> parse() {
        this.initializeColumns();
        this.readLines();
        return this.convertColumnsToFeatureDefinitions();
    }

    private List<FeatureDefinition> convertColumnsToFeatureDefinitions() {
        ArrayList<FeatureDefinition> result = new ArrayList<FeatureDefinition>();
        Counters counters = new Counters();
        for (FeatureColumn column : this.columns) {
            if (column.isWellName || column.isEmpty()) continue;
            FeatureDefinition featureVector = this.convertColumnToFeatureDefinition(column, (Counters<String>)counters);
            result.add(featureVector);
        }
        return result;
    }

    private FeatureDefinition convertColumnToFeatureDefinition(FeatureColumn column, Counters<String> counters) {
        CodeAndLabel codeAndTitle = CodeAndLabelUtil.create((String)column.name);
        ImgFeatureDefDTO featureDef = new ImgFeatureDefDTO();
        featureDef.setLabel(codeAndTitle.getLabel());
        featureDef.setDescription(codeAndTitle.getLabel());
        String code = codeAndTitle.getCode();
        int count = counters.count((Object)code);
        featureDef.setCode(count == 1 ? code : code + count);
        return column.getFeatureDefinition(featureDef);
    }

    private void readLines() {
        for (String[] line : this.lines) {
            this.readLine(line);
        }
    }

    private void readLine(String[] line) {
        WellLocation well = this.readWellLocationFromLine(line);
        for (FeatureColumn column : this.columns) {
            String columnValue;
            if (column.isWellName || StringUtils.isBlank((String)(columnValue = line[column.index]))) continue;
            column.addValue(well, columnValue);
        }
        if (well.getRow() > this.maxRowFound) {
            this.maxRowFound = well.getRow();
        }
        if (well.getColumn() > this.maxColFound) {
            this.maxColFound = well.getColumn();
        }
    }

    private WellLocation readWellLocationFromLine(String[] line) {
        if (this.configuration.isSplit()) {
            String rowString = line[this.xColumn];
            String colString = line[this.yColumn];
            return WellLocation.parseLocationStr(rowString, colString);
        }
        return WellLocation.parseLocationStr(line[this.xColumn]);
    }

    private void initializeColumns() {
        for (int i = 0; i < this.header.length; ++i) {
            String headerName = this.header[i];
            boolean isWellName = true;
            if (this.configuration.getWellRowColumn().equals(headerName)) {
                this.xColumn = i;
            } else if (this.configuration.getWellColumnColumn().equals(headerName)) {
                this.yColumn = i;
            } else if (!this.configuration.shouldColumnBeIgnored(headerName)) {
                isWellName = false;
            }
            FeatureColumn featureColumn = new FeatureColumn(i, headerName, isWellName);
            this.columns.add(featureColumn);
        }
        if (!this.configuration.isSplit()) {
            this.yColumn = this.xColumn;
        }
        if (this.xColumn < 0) {
            throw UserFailureException.fromTemplate((String)"Failed to identify well-row column. The specified input file does not contain header with name '%s'.", (Object[])new Object[]{this.configuration.getWellRowColumn()});
        }
        if (this.yColumn < 0) {
            throw UserFailureException.fromTemplate((String)"Failed to identify well-col column. The specified input file does not contain header with name '%s'.", (Object[])new Object[]{this.configuration.getWellColumnColumn()});
        }
    }

    private static class FeatureColumn {
        private final int index;
        private final String name;
        private final boolean isWellName;
        private final FeatureValuesMap values;

        private FeatureColumn(int index, String name, boolean isWellName) {
            this.index = index;
            this.name = name;
            this.isWellName = isWellName;
            this.values = new FeatureValuesMap(0.0, 0.0);
        }

        public void addValue(WellLocation well, String columnValue) {
            this.values.addValue(columnValue, well);
        }

        public FeatureDefinition getFeatureDefinition(ImgFeatureDefDTO featureDef) {
            return new FeatureDefinition(featureDef, this.values);
        }

        public boolean isEmpty() {
            return this.values.isEmpty();
        }
    }

    public static class CsvFeatureVectorParserConfiguration {
        private final String wellRowColumn;
        private final String wellColumnColumn;
        private final boolean isSplit;
        private final Set<String> columnsToBeIgnored;

        public CsvFeatureVectorParserConfiguration(FeatureVectorStorageProcessorConfiguration config) {
            this(config.getWellRow(), config.getWellColumn(), config.getColumnsToBeIgnored());
        }

        public CsvFeatureVectorParserConfiguration(String wellRow, String wellColumn) {
            this(wellRow, wellColumn, Collections.emptySet());
        }

        public CsvFeatureVectorParserConfiguration(String wellRow, String wellColumn, Set<String> columnsToBeIgnored) {
            this.wellRowColumn = wellRow;
            this.wellColumnColumn = wellColumn;
            this.columnsToBeIgnored = columnsToBeIgnored;
            this.isSplit = false == wellRow.equals(wellColumn);
        }

        public String getWellRowColumn() {
            return this.wellRowColumn;
        }

        public String getWellColumnColumn() {
            return this.wellColumnColumn;
        }

        public boolean isSplit() {
            return this.isSplit;
        }

        public boolean shouldColumnBeIgnored(String column) {
            return this.columnsToBeIgnored.contains(column);
        }
    }
}

