/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.featurevector;

import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FeatureValuesMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<WellLocation, String> valuesMap;
    private final Double depthOrNull;
    private final Double timeOrNull;

    public FeatureValuesMap(Double timeOrNull, Double depthOrNull) {
        this.depthOrNull = depthOrNull;
        this.timeOrNull = timeOrNull;
        this.valuesMap = new HashMap<WellLocation, String>();
    }

    public Double tryGetDepth() {
        return this.depthOrNull;
    }

    public Double tryGetTime() {
        return this.timeOrNull;
    }

    public void addValue(String value, WellLocation wellPos) {
        if (this.valuesMap.get(wellPos) != null) {
            throw new IllegalStateException("Value for the well " + wellPos + " has been already defined!");
        }
        this.valuesMap.put(wellPos, value);
    }

    public Set<String> getUniqueAvailableValues() {
        HashSet<String> uniqueValues = new HashSet<String>();
        for (String value : this.valuesMap.values()) {
            uniqueValues.add(value);
        }
        return uniqueValues;
    }

    public Map<WellLocation, Float> tryExtractFloatValues() {
        HashMap<WellLocation, Float> map = new HashMap<WellLocation, Float>();
        for (Map.Entry<WellLocation, String> entry : this.valuesMap.entrySet()) {
            try {
                WellLocation wellLocation = entry.getKey();
                String value = entry.getValue();
                float floatValue = this.parseFloatOrEmptyString(value);
                map.put(wellLocation, Float.valueOf(floatValue));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return map;
    }

    private float parseFloatOrEmptyString(String value) {
        float floatValue = StringUtils.isBlank((CharSequence)value) ? Float.NaN : Float.parseFloat(value);
        return floatValue;
    }

    public Map<WellLocation, Float> calculateWellTermsMapping(Map<String, Integer> valueToSequanceMap) {
        HashMap<WellLocation, Float> wellTermsMapping = new HashMap<WellLocation, Float>();
        for (Map.Entry<WellLocation, String> entry : this.valuesMap.entrySet()) {
            WellLocation wellLocation = entry.getKey();
            String value = entry.getValue();
            int sequenceNumber = valueToSequanceMap.get(value);
            wellTermsMapping.put(wellLocation, Float.valueOf(sequenceNumber));
        }
        return wellTermsMapping;
    }

    public boolean isEmpty() {
        return this.valuesMap.isEmpty();
    }

    public void validate(Geometry plateGeometry) {
        for (WellLocation well : this.valuesMap.keySet()) {
            FeatureValuesMap.validate(well, plateGeometry);
        }
    }

    private static void validate(WellLocation wellPos, Geometry plateGeometry) {
        if (wellPos.getRow() > plateGeometry.getNumberOfRows() || wellPos.getColumn() > plateGeometry.getNumberOfColumns()) {
            throw new IllegalStateException(String.format("Feature value if defined for the well '%s' which is outside of the plate matrix '%s'", wellPos, plateGeometry));
        }
    }
}

