/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.genedata;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.DefaultStorageProcessor;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.utils.Column;
import ch.systemsx.cisd.etlserver.utils.TableBuilder;
import ch.systemsx.cisd.openbis.dss.etl.HCSContainerDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.CanonicalFeatureVector;
import ch.systemsx.cisd.openbis.dss.etl.featurevector.FeatureVectorUploader;
import ch.systemsx.cisd.openbis.dss.etl.genedata.GenedataFormatToCanonicalFeatureVector;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;

public class FeatureStorageProcessor
extends AbstractDelegatingStorageProcessor {
    private static final char DELIMITER = ';';
    public static final String LAYER_PREFIX = "<Layer=";
    private final DataSource dataSource;
    private final IEncapsulatedOpenBISService openBisService;

    public FeatureStorageProcessor(Properties properties) {
        super(properties);
        this.dataSource = this.createDataSource(properties);
        this.openBisService = this.createOpenBisService();
    }

    protected DataSource createDataSource(Properties properties) {
        return ServiceProvider.getDataSourceProvider().getDataSource(properties);
    }

    protected IEncapsulatedOpenBISService createOpenBisService() {
        return ServiceProvider.getOpenBISService();
    }

    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        IStorageProcessorTransactional.IStorageProcessorTransaction superTransaction = super.createTransaction(parameters);
        return new FeatureStorageProcessorTransaction(parameters, superTransaction, this);
    }

    protected void transform(IImagingQueryDAO dataAccessObject, File originalDataSet, File targetFolderForTransformedDataSet, DataSetInformation dataSetInformation) {
        List lines = FileUtilities.loadToStringList((File)originalDataSet);
        if (lines.isEmpty()) {
            throw new UserFailureException("Empty file: " + originalDataSet.getName());
        }
        String barCode = this.extractBarCode((String)lines.get(0));
        ColumnsBuilder columnsBuilder = this.convertLinesIntoColumns(lines);
        String columnsString = this.convertColumnsToString(barCode, columnsBuilder);
        File originalDirectory = DefaultStorageProcessor.getOriginalDirectory((File)targetFolderForTransformedDataSet);
        File file = new File(originalDirectory, originalDataSet.getName() + ".txt");
        FileUtilities.writeToFile((File)file, (String)columnsString);
        try {
            this.loadDataSetIntoDatabase(dataAccessObject, lines, dataSetInformation);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    private void loadDataSetIntoDatabase(IImagingQueryDAO dataAccessObject, List<String> lines, DataSetInformation dataSetInformation) throws IOException {
        GenedataFormatToCanonicalFeatureVector convertor = new GenedataFormatToCanonicalFeatureVector(lines, LAYER_PREFIX);
        ArrayList<CanonicalFeatureVector> fvecs = convertor.convert();
        FeatureVectorUploader uploader = new FeatureVectorUploader(dataAccessObject, this.createScreeningDatasetInfo(dataSetInformation), dataSetInformation.getDataSetCode());
        uploader.uploadFeatureVectors(fvecs);
    }

    private HCSContainerDatasetInfo createScreeningDatasetInfo(DataSetInformation dataSetInformation) {
        Sample sampleOrNull = this.tryFindSampleForDataSet(dataSetInformation);
        if (sampleOrNull == null) {
            throw new IllegalStateException("Cannot find a sample to which a plate should be (directly or indirectly) connected: " + dataSetInformation);
        }
        return HCSContainerDatasetInfo.createScreeningDatasetInfoWithSample(dataSetInformation, sampleOrNull);
    }

    private Sample tryFindSampleForDataSet(DataSetInformation dataSetInformation) {
        Sample sampleOrNull = dataSetInformation.tryToGetSample();
        if (null == sampleOrNull) {
            List parentDataSetCodes = dataSetInformation.getParentDataSetCodes();
            for (String dataSetCode : parentDataSetCodes) {
                AbstractExternalData externalData = this.openBisService.tryGetDataSet(dataSetCode);
                if (externalData == null) {
                    throw new UserFailureException("Cannot find a parent dataset in openBIS: " + dataSetCode);
                }
                if (externalData.getSample() == null) continue;
                sampleOrNull = externalData.getSample();
                break;
            }
        }
        return sampleOrNull;
    }

    protected IImagingQueryDAO createDAO() {
        return (IImagingQueryDAO)QueryTool.getQuery((DataSource)this.dataSource, IImagingQueryDAO.class);
    }

    private String convertColumnsToString(String barCode, ColumnsBuilder columnsBuilder) {
        List<Column> columns = columnsBuilder.getColumns();
        StringBuilder builder = new StringBuilder();
        builder.append("barcode").append(';').append("row").append(';').append("col");
        for (Column column : columns) {
            builder.append(';').append(column.getHeader());
        }
        int n = columnsBuilder.getNumberOfWells();
        for (int i = 0; i < n; ++i) {
            builder.append('\n').append(barCode);
            builder.append(';').append(columnsBuilder.getRowLetter(i));
            builder.append(';').append(columnsBuilder.getColumnNumber(i));
            for (Column column : columns) {
                builder.append(';').append((String)column.getValues().get(i));
            }
        }
        String columnsString = builder.toString();
        return columnsString;
    }

    private ColumnsBuilder convertLinesIntoColumns(List<String> lines) {
        ColumnsBuilder columnsBuilder = new ColumnsBuilder();
        for (int i = 1; i < lines.size(); ++i) {
            String line = lines.get(i).trim();
            if (line.length() == 0) continue;
            if (line.startsWith(LAYER_PREFIX)) {
                columnsBuilder.startNewColumn(this.extractLayer(line, i));
                continue;
            }
            if (line.startsWith("1")) {
                columnsBuilder.checkColumnsLine(i, line);
                continue;
            }
            columnsBuilder.addRow(i, line);
        }
        columnsBuilder.finish();
        return columnsBuilder;
    }

    private String extractBarCode(String firstLine) {
        int indexOfEqual = firstLine.indexOf(61);
        if (indexOfEqual < 0) {
            throw this.error(0, firstLine, "Missing '='");
        }
        return firstLine.substring(indexOfEqual + 1).trim();
    }

    private String extractLayer(String line, int lineIndex) {
        String layer = line.substring(LAYER_PREFIX.length());
        if (!layer.endsWith(">")) {
            throw this.error(lineIndex, line, "Missing '>' at the end");
        }
        return layer.substring(0, layer.length() - 1);
    }

    private UserFailureException error(int lineIndex, String line, String reason) {
        return new UserFailureException("Error in line " + lineIndex + 1 + ": " + reason + ": " + line);
    }

    private static class FeatureStorageProcessorTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final transient FeatureStorageProcessor processor;
        private transient IImagingQueryDAO dataAccessObject = null;

        FeatureStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction nestedTransaction, FeatureStorageProcessor processor) {
            super(parameters, nestedTransaction);
            this.processor = processor;
        }

        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            this.nestedTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            this.dataAccessObject = this.processor.createDAO();
            File storedDataSet = this.nestedTransaction.getStoredDataDirectory();
            File originalDir = DefaultStorageProcessor.getOriginalDirectory((File)storedDataSet);
            File targetFile = new File(originalDir, this.incomingDataSetDirectory.getName());
            this.processor.transform(this.dataAccessObject, targetFile, storedDataSet, this.dataSetInformation);
            return this.nestedTransaction.getStoredDataDirectory();
        }

        protected void executeCommit() {
            this.nestedTransaction.commit();
            if (null == this.dataAccessObject) {
                return;
            }
            this.dataAccessObject.commit();
            this.closeDataAccessObject();
        }

        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            if (null != this.dataAccessObject) {
                this.dataAccessObject.rollback();
                this.closeDataAccessObject();
            }
            return this.nestedTransaction.rollback(ex);
        }

        private void closeDataAccessObject() {
            this.dataAccessObject.close();
            this.dataAccessObject = null;
        }
    }

    private final class ColumnsBuilder {
        private final List<Column> columns = new ArrayList<Column>();
        private final List<String> rowLetters = new ArrayList<String>();
        private TableBuilder tableBuilder;
        private int numberOfColumns;

        private ColumnsBuilder() {
        }

        public void startNewColumn(String columnName) {
            this.addColumn();
            this.tableBuilder = new TableBuilder(new String[]{columnName});
        }

        public void checkColumnsLine(int lineIndex, String line) {
            int columnCount = new StringTokenizer(line).countTokens();
            if (this.numberOfColumns == 0) {
                this.numberOfColumns = columnCount;
            }
            if (this.numberOfColumns != columnCount) {
                throw FeatureStorageProcessor.this.error(lineIndex, line, "Inconsistent number of columns: Expected " + this.numberOfColumns + " but was " + columnCount);
            }
        }

        public void addRow(int lineIndex, String line) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            int countTokens = tokenizer.countTokens();
            if (countTokens != this.numberOfColumns + 1) {
                throw FeatureStorageProcessor.this.error(lineIndex, line, "Inconsistent number of columns: Expected " + this.numberOfColumns + " but was " + (countTokens - 1));
            }
            String rowLetter = tokenizer.nextToken();
            if (!this.rowLetters.contains(rowLetter)) {
                this.rowLetters.add(rowLetter);
            }
            while (tokenizer.hasMoreTokens()) {
                if (this.tableBuilder == null) continue;
                this.tableBuilder.addRow(new String[]{tokenizer.nextToken()});
            }
        }

        public void finish() {
            this.addColumn();
        }

        public int getNumberOfWells() {
            return this.numberOfColumns * this.rowLetters.size();
        }

        public String getRowLetter(int index) {
            return this.rowLetters.get(index / this.numberOfColumns % this.rowLetters.size());
        }

        public int getColumnNumber(int index) {
            return index % this.numberOfColumns + 1;
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        private void addColumn() {
            if (this.tableBuilder != null) {
                this.columns.addAll(this.tableBuilder.getColumns());
            }
        }
    }
}

