/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.jython.v2;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.IImageProvider;
import ch.systemsx.cisd.openbis.dss.etl.Utils;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageIdentifier;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageMetadata;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.IntensityRange;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Location;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleOverviewImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformationBuffer;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class SimpleImageDataSetRegistrator {
    public static final String OPTIMAL_DATASET_INTENSITY_RESCALING_DESCRIPTION = "Optimal intensity rescaling for a series of images. It allows to compare images of one plate's dataset to each other.At the same time it causes that the conversion to 8 bit color depth looses less information, especially when images use only a small part of available intensities range.";
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SimpleImageDataSetRegistrator.class);
    private final SimpleImageDataConfig simpleImageConfig;
    private final IImageReaderFactory readerFactory;
    private final IImageProvider imageProvider;

    public static DataSetRegistrationDetails<ImageDataSetInformation> createImageDatasetDetails(SimpleImageDataConfig simpleImageConfig, File incoming, IDataSetRegistrationDetailsFactory<ImageDataSetInformation> factory, IImageProvider imageProvider) {
        return SimpleImageDataSetRegistrator.createImageDatasetDetails(simpleImageConfig, incoming, factory, imageProvider, new IImageReaderFactory(){

            @Override
            public IImageReader tryGetReaderForFile(String libraryName, String fileName) {
                return ImageReaderFactory.tryGetReaderForFile((String)libraryName, (String)fileName);
            }

            @Override
            public IImageReader tryGetReader(String libraryName, String readerName) {
                return ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
            }
        });
    }

    private static DataSetRegistrationDetails<ImageDataSetInformation> createImageDatasetDetails(SimpleImageDataConfig simpleImageConfig, File incoming, IDataSetRegistrationDetailsFactory<ImageDataSetInformation> factory, IImageProvider imageProvider, IImageReaderFactory readerFactory) {
        SimpleImageDataSetRegistrator registrator = new SimpleImageDataSetRegistrator(simpleImageConfig, imageProvider, readerFactory);
        return registrator.createImageDatasetDetails(incoming, factory);
    }

    private SimpleImageDataSetRegistrator(SimpleImageDataConfig simpleImageConfig, IImageProvider imageProvider, IImageReaderFactory readerFactory) {
        this.simpleImageConfig = simpleImageConfig;
        this.imageProvider = imageProvider;
        this.readerFactory = readerFactory;
    }

    private DataSetRegistrationDetails<ImageDataSetInformation> createImageDatasetDetails(File incoming, IDataSetRegistrationDetailsFactory<ImageDataSetInformation> imageDatasetFactory) {
        DataSetRegistrationDetails registrationDetails = imageDatasetFactory.createDataSetRegistrationDetails();
        ImageDataSetInformation imageDataset = (ImageDataSetInformation)registrationDetails.getDataSetInformation();
        if (this.simpleImageConfig instanceof SimpleOverviewImageDataConfig) {
            SimpleOverviewImageDataConfig simpleOverviewImageConfig = (SimpleOverviewImageDataConfig)this.simpleImageConfig;
            imageDataset.setContainerDatasetPermId(simpleOverviewImageConfig.getContainerDataSetCode());
            imageDataset.setGenerateOverviewImagesFromRegisteredImages(simpleOverviewImageConfig.isGenerateOverviewImagesFromRegisteredImages());
            imageDataset.setRegisterAsOverviewImageDataSet(true);
        }
        this.setImageDataset(incoming, imageDataset);
        List<Channel> channels = this.simpleImageConfig.getChannels();
        if (channels != null) {
            List<ChannelColorComponent> channelColorComponentsOrNull = this.simpleImageConfig.getChannelColorComponentsOrNull();
            if (channelColorComponentsOrNull == null) {
                imageDataset.setChannels(channels);
            } else {
                imageDataset.setChannels(channels, channelColorComponentsOrNull);
            }
        }
        imageDataset.setColorDepth(this.simpleImageConfig.getColorDepth());
        this.setRegistrationDetails(registrationDetails, imageDataset);
        ((ImageDataSetInformation)registrationDetails.getDataSetInformation()).setImageGenerationAlgorithm(this.simpleImageConfig.getImageGenerationAlgorithm());
        return registrationDetails;
    }

    private List<File> listImageFiles(File incoming) {
        String[] extensions = this.simpleImageConfig.getRecognizedImageExtensions();
        if (incoming.isFile()) {
            ArrayList<File> list = new ArrayList<File>();
            if (this.extensionMatches(incoming, extensions)) {
                list.add(incoming);
            }
            return list;
        }
        return FileOperations.getInstance().listFiles(incoming, extensions, true);
    }

    private boolean extensionMatches(File incoming, String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            return true;
        }
        String fileExt = FilenameUtils.getExtension((String)incoming.getName());
        if (fileExt == null) {
            fileExt = "";
        }
        for (String ext : extensions) {
            if (!ext.equalsIgnoreCase(fileExt)) continue;
            return true;
        }
        return false;
    }

    private List<ImageTokensWithPath> parseImageTokens(List<File> imageFiles, File incomingDirectory, IImageReader imageReaderOrNull) {
        ArrayList<ImageTokensWithPath> imageTokensList = new ArrayList<ImageTokensWithPath>();
        for (File imageFile : imageFiles) {
            try {
                File file = new File(imageFile.getPath());
                List<ImageIdentifier> identifiers = this.imageProvider.getImageIdentifiers(imageReaderOrNull, file);
                String imageRelativePath = FileUtilities.getRelativeFilePath((File)incomingDirectory, (File)file);
                ImageMetadata[] imageTokens = this.simpleImageConfig.extractImagesMetadata(imageRelativePath, identifiers);
                if (imageTokens == null) continue;
                for (ImageMetadata imageToken : imageTokens) {
                    imageToken.ensureValid(this.simpleImageConfig.isMicroscopyData());
                    imageTokensList.add(new ImageTokensWithPath(imageToken, imageRelativePath));
                }
            }
            catch (Exception ex) {
                throw new UserFailureException("Error ocured when processing image " + imageFile.getPath(), (Throwable)ex);
            }
        }
        if (imageTokensList.isEmpty()) {
            throw UserFailureException.fromTemplate((String)"No image tokens could be parsed from incoming directory '%s' for extensions %s!\n Method extractImagesMetadata did not return any image tokens for any of the input image files", (Object[])new Object[]{incomingDirectory.getPath(), CollectionUtils.abbreviate((Object[])this.simpleImageConfig.getRecognizedImageExtensions(), (int)-1)});
        }
        return imageTokensList;
    }

    private List<File> extractImageFiles(File incoming) {
        List<File> imageFiles = this.listImageFiles(incoming);
        if (imageFiles.isEmpty()) {
            throw UserFailureException.fromTemplate((String)"Incoming directory '%s' contains no images with extensions %s!", (Object[])new Object[]{incoming.getPath(), CollectionUtils.abbreviate((Object[])this.simpleImageConfig.getRecognizedImageExtensions(), (int)-1)});
        }
        return imageFiles;
    }

    private IImageReader tryCreateAndSaveImageReader(List<File> imageFiles) {
        IImageReader readerOrNull = null;
        ImageLibraryInfo imageLibraryInfoOrNull = this.tryGetImageLibrary();
        if (imageLibraryInfoOrNull != null) {
            readerOrNull = this.tryCreateImageReader(imageFiles, imageLibraryInfoOrNull);
            if (readerOrNull != null) {
                imageLibraryInfoOrNull.setReaderName(readerOrNull.getName());
            } else {
                throw ConfigurationFailureException.fromTemplate((String)"Cannot find any reader for '%s' library.", (Object[])new Object[]{imageLibraryInfoOrNull});
            }
        }
        return readerOrNull;
    }

    private IImageReader tryCreateImageReader(List<File> imageFiles, ImageLibraryInfo imageLibraryInfo) {
        if (imageFiles.isEmpty()) {
            return null;
        }
        File imageFile = imageFiles.get(0);
        String libraryName = imageLibraryInfo.getName();
        String readerNameOrNull = imageLibraryInfo.getReaderName();
        if (readerNameOrNull != null) {
            return this.readerFactory.tryGetReader(libraryName, readerNameOrNull);
        }
        return this.readerFactory.tryGetReaderForFile(libraryName, imageFile.getPath());
    }

    private ImageLibraryInfo tryGetImageLibrary() {
        return this.simpleImageConfig.getImageStorageConfiguration().tryGetImageLibrary();
    }

    protected ImageFileInfo createImageInfo(ImageTokensWithPath imageTokens, Geometry tileGeometry) {
        Location tileCoords = this.simpleImageConfig.getTileCoordinates(imageTokens.getTileNumber(), tileGeometry);
        ImageFileInfo img = new ImageFileInfo(imageTokens.getChannelCode(), tileCoords.getRow(), tileCoords.getColumn(), imageTokens.getImagePath());
        img.setTimepoint(imageTokens.tryGetTimepoint());
        img.setDepth(imageTokens.tryGetDepth());
        img.setSeriesNumber(imageTokens.tryGetSeriesNumber());
        img.setWell(imageTokens.getWell());
        img.setImageIdentifier(imageTokens.tryGetImageIdentifier());
        return img;
    }

    protected List<ImageFileInfo> createImageInfos(List<ImageTokensWithPath> imageTokensList, Geometry tileGeometry) {
        ArrayList<ImageFileInfo> images = new ArrayList<ImageFileInfo>();
        for (ImageTokensWithPath imageTokens : imageTokensList) {
            ImageFileInfo image = this.createImageInfo(imageTokens, tileGeometry);
            images.add(image);
        }
        return images;
    }

    private List<Channel> getAvailableChannels(List<ImageFileInfo> images) {
        LinkedHashSet<String> channelCodes = new LinkedHashSet<String>();
        for (ImageFileInfo image : images) {
            channelCodes.add(image.getChannelCode());
        }
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (String channelCode : channelCodes) {
            Channel channel = this.simpleImageConfig.createChannel(channelCode);
            channels.add(channel);
        }
        return channels;
    }

    private static int getMaxTileNumber(List<ImageTokensWithPath> imageTokensList) {
        int max = 0;
        for (ImageMetadata imageMetadata : imageTokensList) {
            max = Math.max(max, imageMetadata.getTileNumber());
        }
        return max;
    }

    private void computeAndAppendCommonFixedIntensityRangeTransformation(List<ImageFileInfo> images, File incomingDir, List<Channel> channels, IImageReader readerOrNull) {
        List<Channel> channelsForComputation = this.findChannelsToComputeFixedCommonIntensityRange(channels);
        Map<String, IntensityRange> map = this.simpleImageConfig.getFixedIntensityRangeForAllImages();
        IntensityRange defaultLevelsOrNull = map.get(null);
        for (Channel channel : channelsForComputation) {
            IntensityRange levelsOrNull = map.get(channel.getCode());
            IntensityRescaling.Levels intensityRange = levelsOrNull == null ? new IntensityRescaling.Levels(defaultLevelsOrNull.getBlackPoint(), defaultLevelsOrNull.getWhitePoint()) : new IntensityRescaling.Levels(levelsOrNull.getBlackPoint(), levelsOrNull.getWhitePoint());
            operationLog.info((Object)String.format("Set intensity range for channel '%s' to fixed value: %s (incoming directory '%s').", channel.getCode(), intensityRange.toString(), incomingDir.getName()));
            this.appendCommonIntensityRangeTransformation(channel, intensityRange);
        }
    }

    private List<Channel> findChannelsToComputeFixedCommonIntensityRange(List<Channel> channels) {
        Map<String, IntensityRange> map = this.simpleImageConfig.getFixedIntensityRangeForAllImages();
        IntensityRange defaultLevelOrNull = map.get(null);
        if (defaultLevelOrNull != null) {
            return channels;
        }
        Set<String> channelCodesSet = map.keySet();
        ArrayList<Channel> chosenChannels = new ArrayList<Channel>();
        for (Channel channel : channels) {
            if (!channelCodesSet.contains(channel.getCode())) continue;
            chosenChannels.add(channel);
        }
        return chosenChannels;
    }

    private void computeAndAppendCommonIntensityRangeTransformation(List<ImageFileInfo> images, File incomingDir, List<Channel> channels, IImageReader readerOrNull) {
        List<Channel> channelsForComputation = this.tryFindChannelsToComputeCommonIntensityRange(channels);
        if (channelsForComputation == null) {
            return;
        }
        for (Channel channel : channelsForComputation) {
            String channelCode = channel.getCode();
            List<ImageFileInfo> channelImages = SimpleImageDataSetRegistrator.chooseChannelImages(images, channelCode);
            operationLog.info((Object)String.format("Computing intensity range for channel '%s'. Found %d images for the channel in incoming directory '%s'.", channelCode, channelImages.size(), incomingDir.getName()));
            IntensityRescaling.Levels intensityRange = this.tryComputeCommonIntensityRange(readerOrNull, channelImages, incomingDir, this.simpleImageConfig.getComputeCommonIntensityRangeOfAllImagesThreshold());
            if (intensityRange != null) {
                operationLog.info((Object)String.format("Computed intensity range for channel '%s': %s (incoming directory '%s').", channelCode, intensityRange.toString(), incomingDir.getName()));
                this.appendCommonIntensityRangeTransformation(channel, intensityRange);
                continue;
            }
            operationLog.warn((Object)String.format("Transformation cannot be generated for channel '%s' (incoming directory '%s').", channelCode, incomingDir.getName()));
        }
    }

    private void appendCommonIntensityRangeTransformation(Channel channel, IntensityRescaling.Levels intensityRange) {
        ImageTransformationBuffer buffer = new ImageTransformationBuffer();
        String label = this.simpleImageConfig.getComputeCommonIntensityRangeOfAllImagesLabel();
        ImageTransformation imageTransformation = buffer.appendRescaleGrayscaleIntensity(intensityRange.getMinLevel(), intensityRange.getMaxLevel(), label);
        imageTransformation.setDescription(OPTIMAL_DATASET_INTENSITY_RESCALING_DESCRIPTION);
        boolean isDefault = this.simpleImageConfig.isComputeCommonIntensityRangeOfAllImagesDefault();
        imageTransformation.setDefault(isDefault);
        buffer.appendAll(channel.getAvailableTransformations());
        channel.setAvailableTransformations(buffer.getTransformations());
    }

    private static List<ImageFileInfo> chooseChannelImages(List<ImageFileInfo> images, String channelCode) {
        String normalizedChannelCode = CodeNormalizer.normalize((String)channelCode);
        ArrayList<ImageFileInfo> channelImages = new ArrayList<ImageFileInfo>();
        for (ImageFileInfo imageFileInfo : images) {
            String imageChannelCode = CodeNormalizer.normalize((String)imageFileInfo.getChannelCode());
            if (!imageChannelCode.equals(normalizedChannelCode)) continue;
            channelImages.add(imageFileInfo);
        }
        return channelImages;
    }

    private List<Channel> tryFindChannelsToComputeCommonIntensityRange(List<Channel> channels) {
        List<String> channelCodes = this.simpleImageConfig.getComputeCommonIntensityRangeOfAllImagesForChannels();
        if (channelCodes == null) {
            return null;
        }
        if (channelCodes.isEmpty()) {
            return channels;
        }
        Set<String> channelCodesSet = SimpleImageDataSetRegistrator.createNormalizedCodesSet(channelCodes);
        ArrayList<Channel> chosenChannels = new ArrayList<Channel>();
        for (Channel channel : channels) {
            if (!channelCodesSet.contains(channel.getCode())) continue;
            chosenChannels.add(channel);
        }
        return chosenChannels;
    }

    private static Set<String> createNormalizedCodesSet(Collection<String> channelCodes) {
        HashSet<String> normalizedCodes = new HashSet<String>();
        for (String code : channelCodes) {
            normalizedCodes.add(CodeNormalizer.normalize((String)code));
        }
        return normalizedCodes;
    }

    private IntensityRescaling.Levels tryComputeCommonIntensityRange(IImageReader readerOrNull, List<ImageFileInfo> channelImages, File incomingDir, float threshold) {
        String libraryName = readerOrNull == null ? null : readerOrNull.getLibraryName();
        String readerName = readerOrNull == null ? null : readerOrNull.getName();
        ImageLibraryInfo libraryInfo = new ImageLibraryInfo(libraryName, readerName);
        IntensityRescaling.PixelHistogram histogram = new IntensityRescaling.PixelHistogram();
        for (ImageFileInfo imageFileInfo : channelImages) {
            String imageId = imageFileInfo.tryGetUniqueStringIdentifier();
            File imageFile = new File(incomingDir, imageFileInfo.getImageRelativePath());
            String humanReadableImageId = String.format("image '%s' of image file '%s'", imageId, imageFile);
            try {
                FileBasedContentNode contentNode = new FileBasedContentNode(imageFile);
                BufferedImage image = this.imageProvider.getImage((IHierarchicalContentNode)contentNode, imageId, libraryInfo);
                if (IntensityRescaling.isNotGrayscale((BufferedImage)image)) {
                    operationLog.warn((Object)("Intensity range cannot be computed because " + humanReadableImageId + " is not in grayscale."));
                    return null;
                }
                IntensityRescaling.addToLevelStats((IntensityRescaling.PixelHistogram)histogram, (IntensityRescaling.Pixels)DssScreeningUtils.createPixels(image), (IntensityRescaling.Channel[])new IntensityRescaling.Channel[]{IntensityRescaling.Channel.RED});
            }
            catch (Exception ex) {
                throw new UserFailureException("Error ocured when processing " + humanReadableImageId, (Throwable)ex);
            }
        }
        return IntensityRescaling.computeLevels((IntensityRescaling.PixelHistogram)histogram, (float)threshold);
    }

    private void setImageDataset(File incoming, ImageDataSetInformation dataset) {
        dataset.setDatasetTypeCode(this.simpleImageConfig.getDataSetType());
        dataset.setDataSetKind(DataSetKind.PHYSICAL);
        dataset.setFileFormatCode(this.simpleImageConfig.getFileFormatType());
        dataset.setMeasured(this.simpleImageConfig.isMeasuredData());
        dataset.setSample(this.simpleImageConfig.getPlateSpace(), this.simpleImageConfig.getProjectCode(), this.simpleImageConfig.getPlateCode());
        dataset.setIncomingDirectory(incoming);
        ImageDataSetStructure imageStruct = this.createImageDataSetStructure(incoming, dataset);
        dataset.setImageDataSetStructure(imageStruct);
    }

    private ImageDataSetStructure createImageDataSetStructure(File incoming, ImageDataSetInformation dataset) {
        List<ImageFileInfo> images = null;
        List<Channel> channels = null;
        Geometry tileGeometry = null;
        if (dataset.isGenerateOverviewImagesFromRegisteredImages()) {
            images = new ArrayList<ImageFileInfo>();
            channels = new ArrayList<Channel>();
            String permId = dataset.tryGetContainerDatasetPermId();
            tileGeometry = Utils.gatherImageFileInfos(DssScreeningUtils.getQuery(), permId, images, channels);
        } else {
            List<File> imageFiles = this.extractImageFiles(incoming);
            IImageReader imageReaderOrNull = this.tryCreateAndSaveImageReader(imageFiles);
            List<ImageTokensWithPath> imageTokensList = this.parseImageTokens(imageFiles, incoming, imageReaderOrNull);
            int maxTileNumber = SimpleImageDataSetRegistrator.getMaxTileNumber(imageTokensList);
            tileGeometry = this.simpleImageConfig.getTileGeometry(imageTokensList, maxTileNumber);
            images = this.createImageInfos(imageTokensList, tileGeometry);
            channels = this.getAvailableChannels(images);
            if (this.simpleImageConfig.isFixedIntensityRangeForAllImagesDefined()) {
                this.computeAndAppendCommonFixedIntensityRangeTransformation(images, incoming, channels, imageReaderOrNull);
            } else {
                this.computeAndAppendCommonIntensityRangeTransformation(images, incoming, channels, imageReaderOrNull);
            }
        }
        ImageDataSetStructure imageStruct = new ImageDataSetStructure();
        imageStruct.setImages(images);
        imageStruct.setChannels(channels);
        imageStruct.setTileGeometry(tileGeometry.getNumberOfRows(), tileGeometry.getNumberOfColumns());
        imageStruct.setImageStorageConfiguraton(this.simpleImageConfig.getImageStorageConfiguration());
        return imageStruct;
    }

    private <T extends DataSetInformation> void setRegistrationDetails(DataSetRegistrationDetails<T> registrationDetails, T dataset) {
        registrationDetails.setDataSetInformation(dataset);
        registrationDetails.setFileFormatType(new FileFormatType(this.simpleImageConfig.getFileFormatType()));
        registrationDetails.setDataSetType(new DataSetType(this.simpleImageConfig.getDataSetType()));
        registrationDetails.setDataSetKind(DataSetKind.PHYSICAL);
        registrationDetails.setMeasuredData(this.simpleImageConfig.isMeasuredData());
    }

    private static class ImageTokensWithPath
    extends ImageMetadata {
        private String imageRelativePath;

        public ImageTokensWithPath(ImageMetadata imageTokens, String imageRelativePath) {
            this.setWell(imageTokens.getWell());
            this.setChannelCode(imageTokens.getChannelCode());
            this.setTileNumber(imageTokens.getTileNumber());
            this.setDepth(imageTokens.tryGetDepth());
            this.setTimepoint(imageTokens.tryGetTimepoint());
            this.setSeriesNumber(imageTokens.tryGetSeriesNumber());
            this.setImageIdentifier(imageTokens.tryGetImageIdentifier());
            this.imageRelativePath = imageRelativePath;
        }

        public String getImagePath() {
            return this.imageRelativePath;
        }
    }

    @Private
    static interface IImageReaderFactory {
        public IImageReader tryGetReader(String var1, String var2);

        public IImageReader tryGetReaderForFile(String var1, String var2);
    }
}

