/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.postregistration;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.postregistration.Hdf5CompressingPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class ScreeningHdf5PostRegistrationTask
extends Hdf5CompressingPostRegistrationTask {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ScreeningHdf5PostRegistrationTask.class);

    public ScreeningHdf5PostRegistrationTask(Properties properties, IEncapsulatedOpenBISService service) {
        super(properties, service);
        ScreeningHdf5PostRegistrationTask.checkDatabaseConnection(properties);
    }

    public IPostRegistrationTaskExecutor createExecutor(String dataSetCode) {
        return new ScreeningExecutor(dataSetCode, this.properties);
    }

    private static void checkDatabaseConnection(Properties props) {
        Connection c = null;
        try {
            c = ScreeningHdf5PostRegistrationTask.createConnection(props);
        }
        catch (SQLException sqlEx) {
            throw new ConfigurationFailureException("Initialization failed", (Throwable)sqlEx);
        }
        finally {
            ScreeningHdf5PostRegistrationTask.closeConnection(c);
        }
    }

    private static void closeConnection(Connection connectionOrNull) {
        if (connectionOrNull != null) {
            try {
                connectionOrNull.close();
            }
            catch (SQLException ex) {
                operationLog.error((Object)ex);
            }
        }
    }

    private static Connection createConnection(Properties props) throws SQLException {
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource(props);
        return dataSource.getConnection();
    }

    private final class ScreeningExecutor
    extends Hdf5CompressingPostRegistrationTask.Executor {
        private final Properties configProperties;

        ScreeningExecutor(String dataSetCode, Properties properties) {
            super((Hdf5CompressingPostRegistrationTask)ScreeningHdf5PostRegistrationTask.this, dataSetCode);
            this.configProperties = properties;
        }

        protected void notifyTwinDataSetCreated(String hdf5DataSetCode) {
            Connection connection = null;
            try {
                connection = ScreeningHdf5PostRegistrationTask.createConnection(this.configProperties);
                String statement = String.format("UPDATE  image_zoom_levels  set physical_dataset_perm_id='%s'  where physical_dataset_perm_id='%s'", hdf5DataSetCode, this.dataSetCode);
                connection.createStatement().executeUpdate(statement);
            }
            catch (SQLException ex) {
                throw new ConfigurationFailureException("Connecting to imaging database failed", (Throwable)ex);
            }
            finally {
                ScreeningHdf5PostRegistrationTask.closeConnection(connection);
            }
        }
    }
}

