/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.dss.generic.server.AbstractTabularDataGraphServlet;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import ch.systemsx.cisd.openbis.dss.screening.server.util.FeatureVectorLoaderMetadataProviderFactory;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.PlateUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.FeatureTableRow;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class TabularDataGraphServlet
extends AbstractTabularDataGraphServlet {
    private static final long serialVersionUID = 1L;
    private IImagingReadonlyQueryDAO imagingDbDao;
    private FeatureVectorLoader.IMetadataProvider service;
    public static final String WELL_ROW_COLUMN = "Row";
    public static final String WELL_COLUMN_COLUMN = "Column";

    protected ITabularData getDatasetLines(HttpServletRequest request, String dataSetCode, String filePathOrNull) throws IOException {
        return new ImagingTabularData(this.getDAO(), this.getMetadataProvider(), dataSetCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImagingReadonlyQueryDAO getDAO() {
        TabularDataGraphServlet tabularDataGraphServlet = this;
        synchronized (tabularDataGraphServlet) {
            if (this.imagingDbDao == null) {
                this.imagingDbDao = DssScreeningUtils.getQuery();
            }
        }
        return this.imagingDbDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureVectorLoader.IMetadataProvider getMetadataProvider() {
        TabularDataGraphServlet tabularDataGraphServlet = this;
        synchronized (tabularDataGraphServlet) {
            if (this.service == null) {
                this.service = TabularDataGraphServlet.createFeatureVectorsMetadataProvider();
            }
        }
        return this.service;
    }

    private static FeatureVectorLoader.IMetadataProvider createFeatureVectorsMetadataProvider() {
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        return FeatureVectorLoaderMetadataProviderFactory.createMetadataProvider(openBISService);
    }

    private final class ImagingTabularData
    implements ITabularData {
        private static final String WELL_NAME_COLUMN = "WellName";
        private final IImagingReadonlyQueryDAO dao;
        private final FeatureVectorLoader.IMetadataProvider metadataProvider;
        private final String dataSetCode;
        private String[] headerCodes;
        private String[] headerLabels;
        private ArrayList<String[]> lines;

        private ImagingTabularData(IImagingReadonlyQueryDAO dao, FeatureVectorLoader.IMetadataProvider service, String dataSetCode) {
            this.dao = dao;
            this.metadataProvider = service;
            this.dataSetCode = dataSetCode;
            this.initialize();
        }

        private void initialize() {
            FeatureVectorLoader.WellFeatureCollection<FeatureTableRow> featureCollection = FeatureVectorLoader.fetchDatasetFeatures(Arrays.asList(this.dataSetCode), new ArrayList<String>(), this.dao, this.metadataProvider);
            List<CodeAndLabel> featureCodeAndLabels = featureCollection.getFeatureCodesAndLabels();
            int headerTokensLength = featureCodeAndLabels.size() + 3;
            this.headerLabels = new String[headerTokensLength];
            this.headerLabels[0] = WELL_NAME_COLUMN;
            this.headerLabels[1] = TabularDataGraphServlet.WELL_ROW_COLUMN;
            this.headerLabels[2] = TabularDataGraphServlet.WELL_COLUMN_COLUMN;
            this.headerCodes = new String[headerTokensLength];
            this.headerCodes[0] = CodeNormalizer.normalize((String)WELL_NAME_COLUMN);
            this.headerCodes[1] = CodeNormalizer.normalize((String)TabularDataGraphServlet.WELL_ROW_COLUMN);
            this.headerCodes[2] = CodeNormalizer.normalize((String)TabularDataGraphServlet.WELL_COLUMN_COLUMN);
            int i = 3;
            for (CodeAndLabel featureCodeAndLabel : featureCodeAndLabels) {
                this.headerCodes[i] = featureCodeAndLabel.getCode();
                this.headerLabels[i++] = featureCodeAndLabel.getLabel();
            }
            this.lines = new ArrayList();
            List<FeatureTableRow> rows = featureCollection.getFeatures();
            for (FeatureTableRow row : rows) {
                FeatureValue[] values;
                String[] line = new String[headerTokensLength];
                WellLocation pos = row.getWellLocation();
                String rowLetter = PlateUtils.translateRowNumberIntoLetterCode(pos.getRow());
                String columnNumber = Integer.toString(row.getWellLocation().getColumn());
                line[0] = rowLetter + columnNumber;
                line[1] = Integer.toString(pos.getRow());
                line[2] = Integer.toString(pos.getColumn());
                i = 3;
                for (FeatureValue value : values = row.getFeatureValues()) {
                    line[i++] = this.toString(value);
                }
                this.lines.add(line);
            }
        }

        private String toString(FeatureValue value) {
            if (value.isFloat()) {
                return Float.toString(value.asFloat());
            }
            return "";
        }

        public List<String[]> getDataLines() {
            return this.lines;
        }

        public String[] getHeaderLabels() {
            return this.headerLabels;
        }

        public String[] getHeaderCodes() {
            return this.headerCodes;
        }
    }
}

