/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.common.image.MixColors;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.common.io.ByteArrayBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.AbsoluteImageReference;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageDatasetLoaderFactory;
import ch.systemsx.cisd.openbis.dss.etl.IImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.etl.IImagingLoaderStrategy;
import ch.systemsx.cisd.openbis.dss.etl.ImagingLoaderStrategyFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageTransfomationFactories;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.AutoRescaleIntensityImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.IntensityRangeImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.dss.generic.server.images.ColorComponentImageChannelMerger;
import ch.systemsx.cisd.openbis.dss.generic.server.images.ImageLoadingHelper;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.DatasetAcquiredImagesReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageGenerationDescription;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageTransformationParams;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.RequestedImageSize;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImageChannelsUtils {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ImageChannelsUtils.class);
    public static final String IMAGES_CONTENT_TYPE = "image/png";

    static IHierarchicalContentNode tryGetRawContentOfExistingThumbnail(ImageGenerationDescription params, ImageRepresentationFormat format) {
        String sessionToken = params.getSessionId();
        String dataSetCode = params.tryGetImageChannels().getDatasetCode();
        ImageChannelStackReference channelStackRef = params.tryGetImageChannels().getChannelStackReference();
        String transformation = params.tryGetSingleChannelTransformationCode();
        String channel = params.tryGetImageChannels().getChannelCodes(null).get(0);
        IHierarchicalContentProvider contentProvider = ServiceProvider.getHierarchicalContentProvider();
        OpenBISSessionHolder sessionTokenHolder = new OpenBISSessionHolder();
        sessionTokenHolder.setSessionToken(sessionToken);
        contentProvider = contentProvider.cloneFor((ISessionTokenProvider)sessionTokenHolder);
        IHierarchicalContent content = contentProvider.asContent(dataSetCode);
        IImagingDatasetLoader loader = HCSImageDatasetLoaderFactory.tryCreate(content, dataSetCode);
        if (format.isOriginal()) {
            return loader.tryGetImage(channel, channelStackRef, new RequestedImageSize(null, false, false), transformation).tryGetRawContent();
        }
        return loader.tryGetThumbnail(channel, channelStackRef, new RequestedImageSize(params.tryGetThumbnailSize(), false, false), transformation).tryGetRawContent();
    }

    public static ResponseContentStream getImageStream(ImageGenerationDescription params, IHierarchicalContentProvider contentProvider) {
        BufferedImage image = ImageChannelsUtils.calculateImage(params, contentProvider);
        if ((image = ImageChannelsUtils.drawOverlays(image, params, contentProvider)) == null) {
            throw new UserFailureException("No image is available for parameters: " + params);
        }
        return ImageChannelsUtils.createResponseContentStream(image, null);
    }

    private static BufferedImage calculateImage(ImageGenerationDescription params, IHierarchicalContentProvider contentProvider) {
        ImageTransformationParams transformationInfo;
        DatasetAcquiredImagesReference imageChannels = params.tryGetImageChannels();
        if (imageChannels == null) {
            return null;
        }
        RequestedImageSize imageSize = new RequestedImageSize(params.tryGetThumbnailSize(), false);
        String transformationCode = params.tryGetSingleChannelTransformationCode();
        Map<String, String> transformationsPerChannel = params.tryGetTransformationsPerChannel();
        ImageLoadingHelper imageLoadingHelper = new ImageLoadingHelper(imageChannels, contentProvider, imageSize, transformationCode);
        boolean mergeAllChannels = imageLoadingHelper.isMergeAllChannels(imageChannels);
        List<AbsoluteImageReference> imageContents = imageLoadingHelper.fetchImageContents(imageChannels, mergeAllChannels, true, transformationInfo = new ImageTransformationParams(true, mergeAllChannels, transformationCode, transformationsPerChannel));
        return imageContents.isEmpty() ? null : ImageChannelsUtils.calculateBufferedImage(imageContents, transformationInfo);
    }

    private static BufferedImage drawOverlays(BufferedImage imageOrNull, ImageGenerationDescription params, IHierarchicalContentProvider contentProvider) {
        RequestedImageSize overlaySize = ImageChannelsUtils.calcOverlaySize(imageOrNull, params.tryGetThumbnailSize());
        BufferedImage imageWithOverlays = imageOrNull;
        for (DatasetAcquiredImagesReference overlayChannels : params.getOverlayChannels()) {
            String transformationCode = params.tryGetSingleChannelTransformationCode();
            List<ImageWithReference> overlayImages = ImageChannelsUtils.getSingleImagesSkipNonExisting(overlayChannels, overlaySize, transformationCode, contentProvider);
            for (ImageWithReference overlayImage : overlayImages) {
                if (imageWithOverlays != null) {
                    ImageChannelsUtils.drawOverlay(imageWithOverlays, overlayImage);
                    continue;
                }
                imageWithOverlays = overlayImage.getBufferedImage();
            }
        }
        return imageWithOverlays;
    }

    private static List<ImageWithReference> getSingleImagesSkipNonExisting(DatasetAcquiredImagesReference imagesReference, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull, IHierarchicalContentProvider contentProvider) {
        ImageLoadingHelper imageLoadingHelper = new ImageLoadingHelper(imagesReference, contentProvider, imageSize, singleChannelTransformationCodeOrNull);
        boolean mergeAllChannels = imageLoadingHelper.isMergeAllChannels(imagesReference);
        final ImageTransformationParams transformationInfo = new ImageTransformationParams(true, mergeAllChannels, null, new HashMap<String, String>());
        List<AbsoluteImageReference> imageContents = imageLoadingHelper.fetchImageContents(imagesReference, mergeAllChannels, true, transformationInfo);
        return ImageChannelsUtils.calculateSingleImages(imageContents, new IImageCalculator(){

            @Override
            public BufferedImage create(AbsoluteImageReference imageContent) {
                return ImageChannelsUtils.calculateAndTransformSingleImageForDisplay(imageContent, transformationInfo, Float.valueOf(0.0f));
            }
        });
    }

    private static RequestedImageSize getSize(BufferedImage img, boolean highQuality) {
        return new RequestedImageSize(new Size(img.getWidth(), img.getHeight()), true, highQuality);
    }

    private static RequestedImageSize calcOverlaySize(BufferedImage imageOrNull, Size thumbnailSizeOrNull) {
        if (thumbnailSizeOrNull == null) {
            return RequestedImageSize.createOriginal();
        }
        boolean highQuality = true;
        if (imageOrNull != null) {
            return ImageChannelsUtils.getSize(imageOrNull, highQuality);
        }
        return new RequestedImageSize(thumbnailSizeOrNull, false, highQuality);
    }

    private static ResponseContentStream createResponseContentStream(BufferedImage image, String nameOrNull) {
        IHierarchicalContentNode imageContent = ImageChannelsUtils.createPngContent(image, nameOrNull);
        return ImageChannelsUtils.asResponseContentStream(imageContent);
    }

    public static ResponseContentStream getRepresentativeImageStream(IHierarchicalContent dataSetRoot, String datasetCode, Location wellLocationOrNull, Size imageSizeLimitOrNull, String singleChannelTransformationCodeOrNull) {
        IImagingDatasetLoader imageAccessor = HCSImageDatasetLoaderFactory.create(dataSetRoot, datasetCode);
        IImagingLoaderStrategy loaderStrategy = ImagingLoaderStrategyFactory.createImageLoaderStrategy(imageAccessor);
        ImageLoadingHelper imageLoadingHelper = new ImageLoadingHelper(loaderStrategy, imageSizeLimitOrNull, singleChannelTransformationCodeOrNull);
        List<AbsoluteImageReference> imageReferences = imageLoadingHelper.getRepresentativeImageReferences(wellLocationOrNull);
        ImageTransformationParams transformationParams = new ImageTransformationParams(true, true, null, new HashMap<String, String>());
        BufferedImage image = ImageChannelsUtils.calculateBufferedImage(imageReferences, transformationParams);
        String name = ImageChannelsUtils.createFileName(datasetCode, wellLocationOrNull, imageSizeLimitOrNull);
        return ImageChannelsUtils.createResponseContentStream(image, name);
    }

    private static String createFileName(String datasetCode, Location wellLocationOrNull, Size imageSizeLimitOrNull) {
        String name = "dataset_" + datasetCode;
        if (wellLocationOrNull != null) {
            name = name + "_row" + wellLocationOrNull.getY();
            name = name + "_col" + wellLocationOrNull.getX();
        }
        if (imageSizeLimitOrNull != null) {
            name = name + "_small";
        }
        name = name + ".png";
        return name;
    }

    private static ResponseContentStream asResponseContentStream(IHierarchicalContentNode imageContent) {
        return ResponseContentStream.create((InputStream)imageContent.getInputStream(), (long)imageContent.getFileLength(), (String)IMAGES_CONTENT_TYPE, (String)imageContent.getName());
    }

    public static IHierarchicalContentNode getImage(IImagingLoaderStrategy imageLoaderStrategy, ImageChannelStackReference channelStackReference, String chosenChannelCode, Size imageSizeLimitOrNull, String singleChannelImageTransformationCodeOrNull, boolean convertToPng, boolean transform) {
        ImageTransformationParams transformationInfo;
        boolean mergeAllChannels;
        ImageLoadingHelper imageLoadingHelper = new ImageLoadingHelper(imageLoaderStrategy, imageSizeLimitOrNull, singleChannelImageTransformationCodeOrNull);
        DatasetAcquiredImagesReference imagesReference = ImageChannelsUtils.createDatasetAcquiredImagesReference(imageLoaderStrategy, channelStackReference, chosenChannelCode == null ? "Merged Channels" : chosenChannelCode);
        List<AbsoluteImageReference> imageContents = imageLoadingHelper.fetchImageContents(imagesReference, mergeAllChannels = imageLoadingHelper.isMergeAllChannels(imagesReference), false, transformationInfo = new ImageTransformationParams(transform, mergeAllChannels, singleChannelImageTransformationCodeOrNull, new HashMap<String, String>()));
        IHierarchicalContentNode contentNode = ImageChannelsUtils.tryGetRawContent(convertToPng, imageContents);
        if (contentNode != null) {
            return contentNode;
        }
        BufferedImage image = ImageChannelsUtils.calculateBufferedImage(imageContents, transformationInfo);
        return ImageChannelsUtils.createPngContent(image, null);
    }

    private static DatasetAcquiredImagesReference createDatasetAcquiredImagesReference(IImagingLoaderStrategy imageLoaderStrategy, ImageChannelStackReference channelStackReference, String chosenChannelCode) {
        String datasetCode = imageLoaderStrategy.getImageParameters().getDatasetCode();
        boolean isMergedChannels = "Merged Channels".equalsIgnoreCase(chosenChannelCode);
        if (isMergedChannels) {
            return DatasetAcquiredImagesReference.createForMergedChannels(datasetCode, channelStackReference);
        }
        return DatasetAcquiredImagesReference.createForSingleChannel(datasetCode, channelStackReference, chosenChannelCode);
    }

    private static IHierarchicalContentNode tryGetRawContent(boolean convertToPng, List<AbsoluteImageReference> imageContents) {
        if (imageContents.size() == 1 && !convertToPng) {
            AbsoluteImageReference imageReference = imageContents.get(0);
            return imageReference.tryGetRawContentForOriginalImage();
        }
        return null;
    }

    private static BufferedImage calculateAndTransformSingleImageForDisplay(AbsoluteImageReference imageReference, ImageTransformationParams transformationInfo, Float threshold) {
        BufferedImage image = imageReference.getUnchangedImage();
        ChannelColorRGB channelColor = imageReference.getChannelColor();
        image = ImageChannelsUtils.rescaleIfNot8Bit(image, threshold, channelColor);
        image = ImageChannelsUtils.resize(image, imageReference.getRequestedSize());
        image = ImageChannelsUtils.extractChannel(image, imageReference.tryGetColorComponent());
        image = ImageChannelsUtils.transform(image, imageReference, transformationInfo, threshold);
        image = ImageChannelsUtils.transformGrayToColor(image, channelColor);
        return image;
    }

    public static BufferedImage rescaleIfNot8Bit(BufferedImage image, Float threshold, ChannelColorRGB channelColorOrNull) {
        if (channelColorOrNull == null) {
            return ImageChannelsUtils.rescaleIfNot8Bit(image, threshold, IntensityRescaling.Channel.values());
        }
        IntensityRescaling.Channel channel = IntensityRescaling.Channel.RED;
        int max = channelColorOrNull.getR();
        if (max < channelColorOrNull.getG()) {
            max = channelColorOrNull.getG();
            channel = IntensityRescaling.Channel.GREEN;
        }
        if (max < channelColorOrNull.getB()) {
            channel = IntensityRescaling.Channel.BLUE;
        }
        return ImageChannelsUtils.rescaleIfNot8Bit(image, threshold, channel);
    }

    private static BufferedImage rescaleIfNot8Bit(BufferedImage image, Float threshold, IntensityRescaling.Channel ... channels) {
        IntensityRescaling.Channel[] channelArray;
        if (ImageUtil.getMaxNumberOfBitsPerComponent((BufferedImage)image) <= 8) {
            return image;
        }
        IntensityRescaling.Pixels pixels = DssScreeningUtils.createPixels(image);
        float thresholdValue = ImageChannelsUtils.getThresholdValue(threshold);
        if (pixels.getPixelData().length == 1) {
            IntensityRescaling.Channel[] channelArray2 = new IntensityRescaling.Channel[1];
            channelArray = channelArray2;
            channelArray2[0] = IntensityRescaling.Channel.RED;
        } else {
            channelArray = channels;
        }
        IntensityRescaling.Channel[] channelsForComputation = channelArray;
        IntensityRescaling.Levels levels = IntensityRescaling.computeLevels((IntensityRescaling.Pixels)pixels, (float)thresholdValue, (IntensityRescaling.Channel[])channelsForComputation);
        return IntensityRescaling.rescaleIntensityLevelTo8Bits((IntensityRescaling.Pixels)pixels, (IntensityRescaling.Levels)levels, (IntensityRescaling.Channel[])channelsForComputation);
    }

    private static float getThresholdValue(Float threshold) {
        return threshold == null ? 0.01f : threshold.floatValue();
    }

    public static BufferedImage transformGrayToColor(BufferedImage image, ChannelColorRGB channelColor) {
        IntensityRescaling.Channel channel = ImageUtil.getRepresentativeChannelIfEffectiveGray((BufferedImage)image);
        if (channel == null) {
            return image;
        }
        return ImageChannelsUtils.transformColor(image, ImageChannelsUtils.createColorTransformation(channel, channelColor));
    }

    private static BufferedImage resize(BufferedImage image, RequestedImageSize requestedSize) {
        Size size = requestedSize.tryGetThumbnailSize();
        if (size == null) {
            return image;
        }
        boolean enlarge = requestedSize.enlargeIfNecessary();
        boolean highQuality8Bit = requestedSize.isHighQualityRescalingRequired();
        return ImageUtil.rescale((BufferedImage)image, (int)size.getWidth(), (int)size.getHeight(), (boolean)enlarge, (boolean)highQuality8Bit, (IntensityRescaling.IImageToPixelsConverter)DssScreeningUtils.CONVERTER);
    }

    private static IColorTransformation createColorTransformation(final IntensityRescaling.Channel channel, ChannelColorRGB channelColor) {
        float[] channelHSB = Color.RGBtoHSB(channelColor.getR(), channelColor.getG(), channelColor.getB(), null);
        final float hue = channelHSB[0];
        final float saturation = channelHSB[1];
        final float brightnessScale = channelHSB[2] / 255.0f;
        return new IColorTransformation(){

            @Override
            public int transform(int rgb) {
                int gray = rgb >> channel.getShift() & 0xFF;
                return Color.HSBtoRGB(hue, saturation, brightnessScale * (float)gray);
            }
        };
    }

    @Private
    static BufferedImage calculateBufferedImage(List<AbsoluteImageReference> imageReferences, ImageTransformationParams transformationInfo) {
        AbsoluteImageReference singleImageReference = imageReferences.get(0);
        if (imageReferences.size() == 1) {
            return ImageChannelsUtils.calculateAndTransformSingleImageForDisplay(singleImageReference, transformationInfo, null);
        }
        IImageTransformerFactory mergedChannelTransformationOrNull = singleImageReference.getImageTransformationFactories().tryGetForMerged();
        return ImageChannelsUtils.mergeChannels(imageReferences, transformationInfo, mergedChannelTransformationOrNull);
    }

    private static BufferedImage mergeChannels(List<AbsoluteImageReference> imageReferences, ImageTransformationParams transformationInfo, IImageTransformerFactory mergedChannelTransformationOrNull) {
        assert (transformationInfo != null);
        ArrayList<ImageWithReference> images = new ArrayList<ImageWithReference>();
        for (AbsoluteImageReference imageReference : imageReferences) {
            images.add(new ImageWithReference(imageReference.getUnchangedImage(), imageReference));
        }
        ImageChannelsUtils.calculateImagesForMerging(images, transformationInfo);
        BufferedImage mergedImage = ImageChannelsUtils.mergeImages(images);
        Map<String, String> transMap = transformationInfo.tryGetTransformationCodeForChannels();
        IImageTransformerFactory channelTransformation = mergedChannelTransformationOrNull;
        if ((transMap == null || transMap.isEmpty()) && channelTransformation == null) {
            IntensityRescaling.Levels levels = IntensityRescaling.computeLevels((IntensityRescaling.Pixels)DssScreeningUtils.createPixels(mergedImage), (int)30);
            int minLevel = levels.getMinLevel();
            int maxLevel = levels.getMaxLevel();
            channelTransformation = new IntensityRangeImageTransformerFactory(minLevel, maxLevel);
        }
        if (transformationInfo.isApplyNonImageLevelTransformation()) {
            mergedImage = ImageChannelsUtils.applyImageTransformation(mergedImage, channelTransformation);
        }
        return mergedImage;
    }

    private static void calculateImagesForMerging(List<ImageWithReference> images, ImageTransformationParams transformationInfo) {
        for (ImageWithReference imageWithReference : images) {
            BufferedImage image = imageWithReference.getBufferedImage();
            AbsoluteImageReference imageReference = imageWithReference.getReference();
            image = ImageChannelsUtils.rescaleIfNot8Bit(image, Float.valueOf(0.0f), imageReference.getChannelColor());
            image = ImageChannelsUtils.resize(image, imageReference.getRequestedSize());
            image = ImageChannelsUtils.transformForChannel(image, imageReference, transformationInfo);
            image = ImageChannelsUtils.transformGrayToColor(image, imageReference.getChannelColor());
            imageWithReference.setImage(image);
        }
    }

    private static BufferedImage transformForChannel(BufferedImage image, AbsoluteImageReference imageReference, ImageTransformationParams transformationInfo) {
        String channelCode = imageReference.tryGetChannelCode();
        String transformationCode = transformationInfo.tryGetTransformationCodeForChannel(channelCode);
        boolean applyNonImageLevelTransformation = false;
        if (transformationCode != null) {
            applyNonImageLevelTransformation = transformationInfo.isApplyNonImageLevelTransformation();
        }
        ImageTransformationParams info = new ImageTransformationParams(applyNonImageLevelTransformation, false, transformationCode, null);
        return ImageChannelsUtils.transform(image, imageReference, info, Float.valueOf(0.0f));
    }

    private static BufferedImage transform(BufferedImage image, AbsoluteImageReference imageReference, ImageTransformationParams transformationInfo, Float threshold) {
        BufferedImage resultImage = image;
        ImageTransfomationFactories transformations = imageReference.getImageTransformationFactories();
        resultImage = ImageChannelsUtils.applyImageTransformation(resultImage, transformations.tryGetForImage());
        if (!transformationInfo.isApplyNonImageLevelTransformation()) {
            return resultImage;
        }
        IImageTransformerFactory channelLevelTransformationOrNull = null;
        if (transformationInfo.isUseMergedChannelsTransformation()) {
            channelLevelTransformationOrNull = transformations.tryGetForMerged();
        } else {
            String transformationCode;
            String channelTransformationCode = transformationCode = transformationInfo.tryGetSingleChannelTransformationCode();
            if (transformationCode == null) {
                channelTransformationCode = transformations.tryGetDefaultTransformationCode();
            }
            if (channelTransformationCode != null && !channelTransformationCode.equals(imageReference.tryGetSingleChannelTransformationCode())) {
                channelLevelTransformationOrNull = transformations.tryGetForChannel(transformationCode);
            }
            if (channelLevelTransformationOrNull == null) {
                channelLevelTransformationOrNull = new AutoRescaleIntensityImageTransformerFactory(ImageChannelsUtils.getThresholdValue(threshold));
            }
        }
        return ImageChannelsUtils.applyImageTransformation(resultImage, channelLevelTransformationOrNull);
    }

    private static BufferedImage applyImageTransformation(BufferedImage image, IImageTransformerFactory transformerFactoryOrNull) {
        if (transformerFactoryOrNull == null) {
            return image;
        }
        IImageTransformer transformer = transformerFactoryOrNull.createTransformer();
        BufferedImage transformedImage = transformer.transform(image);
        return transformedImage;
    }

    private static List<ImageWithReference> calculateSingleImages(List<AbsoluteImageReference> imageContents, IImageCalculator imageCalculator) {
        ArrayList<ImageWithReference> images = new ArrayList<ImageWithReference>();
        for (AbsoluteImageReference imageContent : imageContents) {
            BufferedImage image = imageCalculator.create(imageContent);
            images.add(new ImageWithReference(image, imageContent));
        }
        return images;
    }

    private static BufferedImage mergeImages(List<ImageWithReference> images) {
        BufferedImage[] bufferedImages = new BufferedImage[images.size()];
        Color[] colors = new Color[images.size()];
        for (int i = 0; i < images.size(); ++i) {
            ImageWithReference image = images.get(i);
            bufferedImages[i] = image.getBufferedImage();
            colors[i] = ImageChannelsUtils.getColor(image);
        }
        ColorComponent[] colorComponents = ImageChannelsUtils.tryExtractColorComponent(images);
        if (colorComponents != null) {
            return ColorComponentImageChannelMerger.mergeByExtractingComponents(bufferedImages, colorComponents);
        }
        return MixColors.mixImages((BufferedImage[])bufferedImages, (Color[])colors, (boolean)false, (float)0.0f);
    }

    private static Color getColor(ImageWithReference image) {
        return ImageChannelsUtils.getColor(image.getReference().getChannelColor());
    }

    private static Color getColor(ChannelColorRGB color) {
        return new Color(color.getR(), color.getG(), color.getB());
    }

    private static ColorComponent[] tryExtractColorComponent(List<ImageWithReference> images) {
        ColorComponent[] components = new ColorComponent[images.size()];
        int i = 0;
        for (ImageWithReference image : images) {
            ColorComponent colorComponent = image.getReference().tryGetColorComponent();
            if (colorComponent == null) {
                if (i == 0) {
                    return null;
                }
                throw new IllegalStateException("Some images have color component set and some have it unset.");
            }
            components[i++] = colorComponent;
        }
        return components;
    }

    private static void drawOverlay(BufferedImage image, ImageWithReference overlayImage) {
        BufferedImage overlayBufferedImage = overlayImage.getBufferedImage();
        if (ImageChannelsUtils.supportsTransparency(overlayImage)) {
            ImageChannelsUtils.drawTransparentOverlayFast(image, overlayBufferedImage);
        } else {
            ImageChannelsUtils.drawOverlaySlow(image, overlayBufferedImage);
        }
    }

    private static void drawTransparentOverlayFast(BufferedImage image, BufferedImage overlayBufferedImage) {
        Graphics2D graphics = image.createGraphics();
        AlphaComposite ac = AlphaComposite.getInstance(3);
        graphics.setComposite(ac);
        graphics.drawImage(overlayBufferedImage, null, null);
    }

    private static void drawOverlaySlow(BufferedImage image, BufferedImage overlayImage) {
        int width = Math.min(image.getWidth(), overlayImage.getWidth());
        int height = Math.min(image.getHeight(), overlayImage.getHeight());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int imageRGB = image.getRGB(x, y);
                int overlayRGB = overlayImage.getRGB(x, y);
                int overlayedRGB = ImageChannelsUtils.overlayRGBColor(imageRGB, overlayRGB);
                image.setRGB(x, y, overlayedRGB);
            }
        }
    }

    private static int overlayRGBColor(int imageRGB, int overlayRGB) {
        Color imageColor = new Color(imageRGB);
        Color overlayColor = new Color(overlayRGB, true);
        if (overlayColor.getAlpha() == 0) {
            return imageRGB;
        }
        int r = Math.max(imageColor.getRed(), overlayColor.getRed());
        int g = Math.max(imageColor.getGreen(), overlayColor.getGreen());
        int b = Math.max(imageColor.getBlue(), overlayColor.getBlue());
        return new Color(r, g, b).getRGB();
    }

    private static boolean supportsTransparency(ImageWithReference image) {
        return image.getBufferedImage().getColorModel().hasAlpha();
    }

    public static BufferedImage extractChannel(BufferedImage bufferedImage, final ColorComponent colorComponent) {
        if (colorComponent == null) {
            return bufferedImage;
        }
        return ImageChannelsUtils.transformColor(bufferedImage, new IColorTransformation(){

            @Override
            public int transform(int rgb) {
                return colorComponent.extractSingleComponent(rgb).getRGB();
            }
        });
    }

    public static BufferedImage transformColor(BufferedImage bufferedImage, IColorTransformation transformation) {
        IntensityRescaling.Pixels pixels = DssScreeningUtils.createPixels(bufferedImage);
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        int[][] pixelData = pixels.getPixelData();
        BufferedImage newImage = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int pixelIndex = offset + x;
                int rgb = 0;
                for (int i = 0; i < 3; ++i) {
                    int band = Math.min(i, pixelData.length - 1);
                    rgb = (rgb << 8) + (pixelData[band][pixelIndex] & 0xFF);
                }
                newImage.setRGB(x, y, transformation.transform(rgb));
            }
        }
        return newImage;
    }

    private static IHierarchicalContentNode createPngContent(BufferedImage image, String nameOrNull) {
        byte[] output = ImageUtil.imageToPngFast((BufferedImage)image);
        return new ByteArrayBasedContentNode(output, nameOrNull);
    }

    private static class ImageWithReference {
        private BufferedImage image;
        private final AbsoluteImageReference reference;

        public ImageWithReference(BufferedImage image, AbsoluteImageReference reference) {
            this.image = image;
            this.reference = reference;
        }

        public BufferedImage getBufferedImage() {
            return this.image;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public AbsoluteImageReference getReference() {
            return this.reference;
        }
    }

    private static interface IImageCalculator {
        public BufferedImage create(AbsoluteImageReference var1);
    }

    private static interface IColorTransformation {
        public int transform(int var1);
    }
}

