/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.etl.AbsoluteImageReference;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageDatasetLoaderFactory;
import ch.systemsx.cisd.openbis.dss.etl.IImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.etl.IImagingLoaderStrategy;
import ch.systemsx.cisd.openbis.dss.etl.ImagingLoaderStrategyFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.DatasetAcquiredImagesReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageTransformationParams;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.RequestedImageSize;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import java.util.ArrayList;
import java.util.List;

class ImageLoadingHelper {
    private final IImagingLoaderStrategy imageLoaderStrategy;
    private final RequestedImageSize imageSizeLimit;
    private final String singleChannelTransformationCodeOrNull;

    private static IImagingLoaderStrategy createLoaderStrategy(DatasetAcquiredImagesReference imageChannels, IHierarchicalContentProvider contentProvider) {
        String datasetCode = imageChannels.getDatasetCode();
        IHierarchicalContent dataSetRoot = contentProvider.asContent(datasetCode);
        IImagingDatasetLoader loader = HCSImageDatasetLoaderFactory.create(dataSetRoot, datasetCode);
        return ImagingLoaderStrategyFactory.createImageLoaderStrategy(loader);
    }

    @Private
    ImageLoadingHelper(IImagingLoaderStrategy imageLoaderStrategy, RequestedImageSize imageSizeLimit, String singleChannelTransformationCodeOrNull) {
        this.imageLoaderStrategy = imageLoaderStrategy;
        this.imageSizeLimit = imageSizeLimit;
        this.singleChannelTransformationCodeOrNull = singleChannelTransformationCodeOrNull;
    }

    ImageLoadingHelper(IImagingLoaderStrategy imageLoaderStrategy, Size imageSizeLimitOrNull, String singleChannelTransformationCodeOrNull) {
        this(imageLoaderStrategy, new RequestedImageSize(imageSizeLimitOrNull, false), singleChannelTransformationCodeOrNull);
    }

    ImageLoadingHelper(DatasetAcquiredImagesReference imageChannels, IHierarchicalContentProvider contentProvider, RequestedImageSize imageSizeLimit, String singleChannelTransformationCodeOrNull) {
        this(ImageLoadingHelper.createLoaderStrategy(imageChannels, contentProvider), imageSizeLimit, singleChannelTransformationCodeOrNull);
    }

    boolean isMergeAllChannels(DatasetAcquiredImagesReference imageChannels) {
        return imageChannels.isMergeAllChannels(this.getAllChannelCodes());
    }

    List<AbsoluteImageReference> fetchImageContents(DatasetAcquiredImagesReference imagesReference, boolean mergeAllChannels, boolean skipNonExisting, ImageTransformationParams transformationInfo) {
        AbsoluteImageReference allChannelsImageReference;
        List<String> channelCodes = imagesReference.getChannelCodes(this.getAllChannelCodes());
        ArrayList<AbsoluteImageReference> images = new ArrayList<AbsoluteImageReference>();
        for (String channelCode : channelCodes) {
            ImageChannelStackReference channelStackReference;
            AbsoluteImageReference image = this.imageLoaderStrategy.tryGetImage(channelCode, channelStackReference = imagesReference.getChannelStackReference(), this.imageSizeLimit, this.singleChannelTransformationCodeOrNull);
            if (image == null && !skipNonExisting) {
                String item = this.imageSizeLimit.isThumbnailRequired() ? "thumbnail" : "image";
                throw EnvironmentFailureException.fromTemplate((String)"No %s found for channel stack %s and channel %s", (Object[])new Object[]{item, channelStackReference, channelCode});
            }
            if (image == null) continue;
            images.add(image);
        }
        if (mergeAllChannels && !this.shouldApplySingleChannelsTransformations(transformationInfo) && (allChannelsImageReference = this.tryCreateAllChannelsImageReference(images)) != null) {
            images.clear();
            images.add(allChannelsImageReference);
        }
        return images;
    }

    List<AbsoluteImageReference> getRepresentativeImageReferences(Location wellLocationOrNull) {
        ArrayList<AbsoluteImageReference> images = new ArrayList<AbsoluteImageReference>();
        for (String chosenChannel : this.getAllChannelCodes()) {
            images.add(this.getRepresentativeImageReference(chosenChannel, wellLocationOrNull));
        }
        return images;
    }

    private List<String> getAllChannelCodes() {
        return this.imageLoaderStrategy.getImageParameters().getChannelsCodes();
    }

    private AbsoluteImageReference getRepresentativeImageReference(String channelCode, Location wellLocationOrNull) {
        AbsoluteImageReference image = this.imageLoaderStrategy.tryGetRepresentativeImage(channelCode, wellLocationOrNull, this.imageSizeLimit, this.singleChannelTransformationCodeOrNull);
        if (image != null) {
            return image;
        }
        String item = this.imageSizeLimit.isThumbnailRequired() ? "thumbnail" : "image";
        throw EnvironmentFailureException.fromTemplate((String)"No representative %s found for well %s and channel %s", (Object[])new Object[]{item, wellLocationOrNull, channelCode});
    }

    private boolean shouldApplySingleChannelsTransformations(ImageTransformationParams transformationInfo) {
        return transformationInfo != null && transformationInfo.tryGetTransformationCodeForChannels() != null && transformationInfo.tryGetTransformationCodeForChannels().size() > 0;
    }

    private AbsoluteImageReference tryCreateAllChannelsImageReference(List<AbsoluteImageReference> imageReferences) {
        AbsoluteImageReference lastFound = null;
        for (AbsoluteImageReference image : imageReferences) {
            if (lastFound == null) {
                lastFound = image;
                continue;
            }
            if (ImageLoadingHelper.equals(image.tryGetImageID(), lastFound.tryGetImageID()) && image.getUniqueId().equals(lastFound.getUniqueId())) continue;
            return null;
        }
        if (lastFound != null) {
            return lastFound.createWithoutColorComponent();
        }
        return null;
    }

    private static boolean equals(String i1OrNull, String i2OrNull) {
        return i1OrNull == null ? i2OrNull == null : i1OrNull.equals(i2OrNull);
    }
}

