/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.imagereaders.ReadParams;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColorRangeCalculator {
    public static ImagePixelsRange rescaleRange(ImagePixelsRange imageRange, ImagePixelsRange globalRange) {
        double globalRangeLength = globalRange.getMax() - globalRange.getMin();
        int min = (int)((double)(255 * (imageRange.getMin() - globalRange.getMin())) / globalRangeLength);
        int max = (int)((double)(255 * (imageRange.getMax() - globalRange.getMin())) / globalRangeLength);
        return new ImagePixelsRange(min, max);
    }

    public static ImagePixelsRange calculateOverlapRange(Collection<ImagePixelsRange> ranges) {
        ImagePixelsRange globalRange = null;
        for (ImagePixelsRange imageRange : ranges) {
            globalRange = imageRange.createOverlap(globalRange);
        }
        return globalRange;
    }

    public static ImagePixelsRange calculatePixelsRange(BufferedImage bufferedImage, int minRescaledColor, int maxRescaledColor) {
        int minColor = maxRescaledColor;
        int maxColor = minRescaledColor;
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int dominantColorComponent = bufferedImage.getRaster().getSample(x, y, 0);
                if (dominantColorComponent < minRescaledColor || dominantColorComponent > maxRescaledColor) continue;
                if (dominantColorComponent > maxColor) {
                    maxColor = dominantColorComponent;
                    continue;
                }
                if (dominantColorComponent >= minColor) continue;
                minColor = dominantColorComponent;
            }
        }
        return new ImagePixelsRange(minColor, maxColor);
    }

    public static ImagePixelsRange calculatePixelsRange(List<File> imageFiles) throws IOException {
        ArrayList<ImagePixelsRange> ranges = new ArrayList<ImagePixelsRange>();
        IImageReader reader = ColorRangeCalculator.tryFindReader(imageFiles.get(0));
        if (reader == null) {
            throw new IOException("Cannot find a proper reader for the images");
        }
        for (File imageFile : imageFiles) {
            BufferedImage image = ColorRangeCalculator.loadImage(reader, imageFile);
            ImagePixelsRange range = ColorRangeCalculator.calculatePixelsRange(image, 0, Integer.MAX_VALUE);
            ranges.add(range);
        }
        return ColorRangeCalculator.calculateOverlapRange(ranges);
    }

    private static BufferedImage loadImage(IImageReader reader, File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("File does not exist: " + file.getPath());
        }
        ReadParams params = new ReadParams();
        return reader.readImage(file, ImageID.NULL, (IReadParams)params);
    }

    private static IImageReader tryFindReader(File file) throws IOException {
        String[] libraries;
        if (!file.isFile()) {
            throw new IOException("File does not exist: " + file.getPath());
        }
        for (String libraryName : libraries = new String[]{"JAI", "ImageIO", "IJ", "BioFormats"}) {
            IImageReader reader = ImageReaderFactory.tryGetReaderForFile((String)libraryName, (String)file.getPath());
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("No files specified!");
            System.exit(1);
        }
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            imageFiles.add(new File(args[i]));
        }
        ImagePixelsRange range = ColorRangeCalculator.calculatePixelsRange(imageFiles);
        System.out.println(range.getMin() + " " + range.getMax());
    }

    public static class ImagePixelsRange {
        private final int min;
        private final int max;

        public ImagePixelsRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public ImagePixelsRange createOverlap(ImagePixelsRange rangeOrNull) {
            if (rangeOrNull == null) {
                return this;
            }
            int newMin = Math.min(this.min, rangeOrNull.getMin());
            int newMax = Math.max(this.max, rangeOrNull.getMax());
            return new ImagePixelsRange(newMin, newMax);
        }

        public String toString() {
            return "[" + this.min + ", " + this.max + "]";
        }
    }
}

