/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.screening.shared.api.internal;

import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.v1.IDssServiceRpcScreening;

public class DssServiceRpcScreeningHolder {
    private final IDssServiceRpcScreening service;
    private final String serverUrl;
    private Integer majorVersion;
    private Integer minorVersion;

    public DssServiceRpcScreeningHolder(String serverUrl, IDssServiceRpcScreening service) {
        this.serverUrl = serverUrl;
        this.service = service;
    }

    public DssServiceRpcScreeningHolder(String serverUrl, int majorVersion, long timeout) {
        this(serverUrl, DssServiceRpcScreeningHolder.createService(serverUrl, majorVersion, timeout));
    }

    private static IDssServiceRpcScreening createService(String serverUrl, int majorVersion, long timeout) {
        return (IDssServiceRpcScreening)HttpInvokerUtils.createStreamSupportingServiceStub(IDssServiceRpcScreening.class, (String)(serverUrl + "/rmi-datastore-server-screening-api-v" + majorVersion + "/"), (long)timeout);
    }

    public IDssServiceRpcScreening getService() {
        return this.service;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public int getMajorVersion() {
        if (this.majorVersion == null) {
            this.majorVersion = this.service.getMajorVersion();
        }
        return this.majorVersion;
    }

    public int getMinorVersion() {
        if (this.minorVersion == null) {
            this.minorVersion = this.service.getMinorVersion();
        }
        return this.minorVersion;
    }
}

