/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.shared;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingTransformerDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.TransformerFactoryMapper;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.sql.DataSource;
import loci.formats.gui.Index16ColorModel;
import net.lemnik.eodsql.QueryTool;

public class DssScreeningUtils {
    public static final IntensityRescaling.IImageToPixelsConverter CONVERTER = new IntensityRescaling.IImageToPixelsConverter(){

        public IntensityRescaling.Pixels convert(BufferedImage image) {
            return DssScreeningUtils.createPixels(image);
        }
    };
    private static IImagingReadonlyQueryDAO query;

    public static IImagingReadonlyQueryDAO getQuery() {
        if (query == null) {
            query = DssScreeningUtils.createQuery();
        }
        return query;
    }

    private static IImagingReadonlyQueryDAO createQuery() {
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource("imaging-db");
        return (IImagingReadonlyQueryDAO)QueryTool.getQuery((DataSource)dataSource, IImagingReadonlyQueryDAO.class);
    }

    public static IImagingTransformerDAO createImagingTransformerDAO() {
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource("imaging-db");
        return (IImagingTransformerDAO)QueryTool.getQuery((DataSource)dataSource, IImagingTransformerDAO.class);
    }

    public static IntensityRescaling.Pixels createPixels(BufferedImage image) {
        return new IntensityRescaling.Pixels(image){

            protected int[][] tryCreateColorIndexMap(ColorModel colorModel) {
                int[][] indexMap = super.tryCreateColorIndexMap(colorModel);
                if (indexMap == null && colorModel instanceof Index16ColorModel) {
                    Index16ColorModel indexColorModel = (Index16ColorModel)colorModel;
                    indexMap = new int[3][65536];
                    this.copyTo(indexColorModel.getReds(), indexMap[0]);
                    this.copyTo(indexColorModel.getGreens(), indexMap[1]);
                    this.copyTo(indexColorModel.getBlues(), indexMap[2]);
                }
                return indexMap;
            }

            private void copyTo(short[] shorts, int[] integers) {
                for (int i = 0; i < shorts.length; ++i) {
                    integers[i] = shorts[i] & 0xFFFF;
                }
            }
        };
    }

    static {
        QueryTool.getTypeMap().put(IImageTransformerFactory.class, new TransformerFactoryMapper());
    }
}

