/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class LoadImagesScreeningClientApiTest {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: <user> <password> <openbis-server-url>");
            System.err.println("Example parameters: test-user my-password http://localhost:8888");
            System.exit(1);
            return;
        }
        LoadImagesScreeningClientApiTest.configureLogging();
        String userId = args[0];
        String userPassword = args[1];
        String serverUrl = args[2];
        LoadImagesScreeningClientApiTest.print(String.format("Connecting to the server '%s' as a user '%s.", serverUrl, userId));
        IScreeningOpenbisServiceFacade facade = ScreeningOpenbisServiceFacadeFactory.INSTANCE.tryToCreate(userId, userPassword, serverUrl);
        if (facade == null) {
            System.err.println("Authentication failed: check the user name and password.");
            System.exit(1);
            return;
        }
        String plateCode = "PLATE-2-A";
        PlateIdentifier plate = new PlateIdentifier(plateCode, "TEST", null);
        List<ImageDatasetReference> imageDatasets = facade.listRawImageDatasets(Arrays.asList(plate));
        if (imageDatasets.size() == 0) {
            System.err.println("No image datasets connected to plate " + plate);
            System.exit(1);
        }
        LoadImagesScreeningClientApiTest.printImagesMetadata(facade, imageDatasets);
        LoadImagesScreeningClientApiTest.loadOneImage(facade, imageDatasets.get(0));
        facade.logout();
    }

    private static void printImagesMetadata(IScreeningOpenbisServiceFacade facade, List<ImageDatasetReference> imageDatasets) {
        List<ImageDatasetMetadata> imageMetadatas = facade.listImageMetadata(imageDatasets);
        for (ImageDatasetMetadata imageMetadata : imageMetadatas) {
            System.out.println(imageMetadata);
        }
    }

    private static void loadOneImage(IScreeningOpenbisServiceFacade facade, ImageDatasetReference imageDataset) throws IOException {
        int tile = 0;
        String channel = "DAPI";
        int row = 1;
        int column = 3;
        WellPosition well = new WellPosition(row, column);
        PlateImageReference imageRef = new PlateImageReference(tile, channel, well, imageDataset);
        LoadImagesScreeningClientApiTest.loadImage(facade, imageRef);
    }

    private static File createImageFile(PlateImageReference imageRef) {
        File dir = new File(imageRef.getDatasetCode());
        dir.mkdir();
        return new File(dir, LoadImagesScreeningClientApiTest.createImageFileName(imageRef));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadImage(IScreeningOpenbisServiceFacade facade, PlateImageReference imageReference) throws IOException {
        File imageOutputFile = LoadImagesScreeningClientApiTest.createImageFile(imageReference);
        try (final BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(imageOutputFile));){
            facade.loadImages(Arrays.asList(imageReference), new ScreeningOpenbisServiceFacade.IImageOutputStreamProvider(){

                @Override
                public OutputStream getOutputStream(PlateImageReference imageRef) throws IOException {
                    return out;
                }
            }, false);
        }
    }

    private static void print(String msg) {
        System.out.println(new Date() + "\t" + msg);
    }

    private static String createImageFileName(PlateImageReference image) {
        WellPosition well = image.getWellPosition();
        return "img_row" + well.getWellRow() + "_col" + well.getWellColumn() + "_" + image.getChannel() + "_tile" + image.getTile() + ".png";
    }

    private static void configureLogging() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d %-5p [%t] %c - %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        PropertyConfigurator.configure((Properties)props);
    }
}

