/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.openbis.dss.screening.shared.api.v1.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IPlateImageHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.PropertyConfigurator;

public class LoadImagesWithTransformationTest {
    private final IScreeningOpenbisServiceFacade facade;
    private final String permIdOfPlateInterest;

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: <user> <password> <openbis-server-url>");
            System.err.println("Example parameters: test-user my-password http://localhost:8888");
            System.exit(1);
            return;
        }
        LoadImagesWithTransformationTest.configureLogging();
        String userId = args[0];
        String userPassword = args[1];
        String serverUrl = args[2];
        LoadImagesWithTransformationTest.print(String.format("Connecting to the server '%s' as a user '%s.", serverUrl, userId));
        IScreeningOpenbisServiceFacade facade = ScreeningOpenbisServiceFacadeFactory.tryCreate(userId, userPassword, serverUrl);
        if (facade == null) {
            System.err.println("Authentication failed: check the user name and password.");
            System.exit(1);
            return;
        }
        LoadImagesWithTransformationTest newMe = new LoadImagesWithTransformationTest(facade, "20110203103943504-79775");
        newMe.runTest();
        newMe.logout();
    }

    private LoadImagesWithTransformationTest(IScreeningOpenbisServiceFacade facade, String permIdOfInterest) {
        this.facade = facade;
        this.permIdOfPlateInterest = permIdOfInterest;
    }

    public void runTest() throws IOException {
        List<PlateImageReference> imageReferences = this.findPlateImagesToLoad();
        LoadImageConfiguration config = new LoadImageConfiguration();
        config.setDesiredImageFormatPng(true);
        config.setOpenBisImageTransformationApplied(false);
        this.loadImages(imageReferences, config);
        config.setOpenBisImageTransformationApplied(true);
        this.loadImages(imageReferences, config);
        LoadImagesWithTransformationTest.print("Finished.");
    }

    private void loadImages(List<PlateImageReference> imageReferences, final LoadImageConfiguration config) throws IOException {
        this.facade.loadImages(imageReferences, config, new IPlateImageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void handlePlateImage(PlateImageReference plateImageReference, byte[] imageFileBytes) {
                String userHome = System.getProperty("user.home");
                StringBuffer sb = new StringBuffer();
                sb.append(userHome);
                sb.append("/Desktop/");
                sb.append("Well-");
                sb.append(plateImageReference.getWellPosition().getWellRow());
                sb.append("-");
                sb.append(plateImageReference.getWellPosition().getWellColumn());
                sb.append("-");
                sb.append(plateImageReference.getTile());
                sb.append("-");
                sb.append(plateImageReference.getChannel());
                if (config.isOpenBisImageTransformationApplied()) {
                    sb.append("-transformed");
                }
                sb.append(".png");
                LoadImagesWithTransformationTest.print("Writing " + sb.toString() + "...");
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(sb.toString());
                    fos.write(imageFileBytes);
                    fos.close();
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    IOUtils.closeQuietly((OutputStream)fos);
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fos);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
        });
    }

    private List<PlateImageReference> findPlateImagesToLoad() {
        LoadImagesWithTransformationTest.print("Looking for images to load...");
        ArrayList<PlateImageReference> plateImages = new ArrayList<PlateImageReference>();
        List<Plate> plates = this.facade.listPlates();
        Plate plateOfInterest = null;
        for (Plate plate : plates) {
            if (!plate.getPermId().equals(this.permIdOfPlateInterest)) continue;
            plateOfInterest = plate;
            break;
        }
        if (null == plateOfInterest) {
            return plateImages;
        }
        List<ImageDatasetReference> imageDatasets = this.facade.listRawImageDatasets(Arrays.asList(plateOfInterest));
        if (imageDatasets.size() == 0) {
            return plateImages;
        }
        for (ImageDatasetReference imageDataset : imageDatasets) {
            this.addAllPlateImagesFromDataset(plateImages, imageDataset, 4);
            if (!this.isNumberOfImagesSufficient(plateImages, 4)) continue;
            break;
        }
        LoadImagesWithTransformationTest.print("...found " + plateImages.size() + " images.");
        return plateImages;
    }

    private void addAllPlateImagesFromDataset(ArrayList<PlateImageReference> plateImages, ImageDatasetReference imageDataset, int numberOfImagesDesired) {
        ImageDatasetMetadata metadata = this.facade.listImageMetadata(imageDataset);
        int numberOfRows = metadata.getTilesRows();
        int numberOfCols = metadata.getTilesCols();
        List<String> channels = metadata.getChannelCodes();
        int numberOfTileRows = metadata.getTilesRows();
        int numberOfTileCols = metadata.getTilesCols();
        for (int row = 1; row <= numberOfRows; ++row) {
            for (int col = 1; col <= numberOfCols; ++col) {
                WellPosition well = new WellPosition(row, col);
                for (String channel : channels) {
                    for (int tileRow = 0; tileRow < numberOfTileRows; ++tileRow) {
                        for (int tileCol = 0; tileCol < numberOfTileCols; ++tileCol) {
                            int tile = tileRow * numberOfTileCols + tileCol;
                            PlateImageReference imageRef = new PlateImageReference(tile, channel, well, imageDataset);
                            plateImages.add(imageRef);
                            if (!this.isNumberOfImagesSufficient(plateImages, numberOfImagesDesired)) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private boolean isNumberOfImagesSufficient(ArrayList<PlateImageReference> plateImages, int numberOfImagesDesired) {
        return plateImages.size() > numberOfImagesDesired - 1;
    }

    public void logout() {
        this.facade.logout();
    }

    private static void print(String msg) {
        System.out.println(new Date() + "\t" + msg);
    }

    private static void configureLogging() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d %-5p [%t] %c - %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        PropertyConfigurator.configure((Properties)props);
    }
}

