/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.openbis.dss.screening.shared.api.v1.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IPlateImageHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.springframework.util.StopWatch;

public class LoadThumbnailsPerformanceTest {
    private final IScreeningOpenbisServiceFacade facade;

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: <user> <password> <openbis-server-url>");
            System.err.println("Example parameters: test-user my-password http://localhost:8888");
            System.exit(1);
            return;
        }
        LoadThumbnailsPerformanceTest.configureLogging();
        String userId = args[0];
        String userPassword = args[1];
        String serverUrl = args[2];
        LoadThumbnailsPerformanceTest.print(String.format("Connecting to the server '%s' as a user '%s.", serverUrl, userId));
        IScreeningOpenbisServiceFacade facade = ScreeningOpenbisServiceFacadeFactory.tryCreate(userId, userPassword, serverUrl);
        if (facade == null) {
            System.err.println("Authentication failed: check the user name and password.");
            System.exit(1);
            return;
        }
        LoadThumbnailsPerformanceTest newMe = new LoadThumbnailsPerformanceTest(facade);
        newMe.runTest();
        newMe.logout();
    }

    private LoadThumbnailsPerformanceTest(IScreeningOpenbisServiceFacade facade) {
        this.facade = facade;
    }

    public void runTest() throws IOException {
        List<PlateImageReference> imageReferences = this.findPlateImagesToLoad(1000);
        this.runAndTime(imageReferences, 2);
        this.runAndTime(imageReferences, 3);
        this.runAndTime(imageReferences, 4);
    }

    private void runAndTime(List<PlateImageReference> imageReferences, int whichMethod) throws IOException {
        LoadThumbnailsPerformanceTest.print("Retrieving images...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LoadImageConfiguration config = new LoadImageConfiguration();
        config.setDesiredImageSize(new ImageSize(256, 256));
        switch (whichMethod) {
            case 0: {
                this.loadThumbnailImages(imageReferences);
                break;
            }
            case 1: {
                this.loadThumbnailImageWellCaching(imageReferences);
                break;
            }
            case 2: {
                config.setDesiredImageFormatPng(true);
                this.loadImages(imageReferences, config);
                break;
            }
            case 3: {
                this.loadImages(imageReferences, config);
                break;
            }
            case 4: {
                config.setDesiredImageSize(null);
                this.loadImages(imageReferences, config);
                break;
            }
        }
        stopWatch.stop();
        long timeInMs = stopWatch.getLastTaskTimeMillis();
        double timeInSec = (double)timeInMs / 1000.0;
        LoadThumbnailsPerformanceTest.print("Retrieving " + imageReferences.size() + " images took " + timeInMs + " ms = " + timeInSec + " sec");
        LoadThumbnailsPerformanceTest.print("Test done.");
    }

    private void loadThumbnailImageWellCaching(List<PlateImageReference> imageReferences) throws IOException {
        for (PlateImageReference imageReference : imageReferences) {
            this.facade.loadThumbnailImageWellCaching(imageReference);
        }
    }

    private void loadThumbnailImages(List<PlateImageReference> imageReferences) throws IOException {
        this.facade.loadThumbnailImages(imageReferences, new IPlateImageHandler(){

            @Override
            public void handlePlateImage(PlateImageReference plateImageReference, byte[] imageFileBytes) {
            }
        });
    }

    private void loadImages(List<PlateImageReference> imageReferences, LoadImageConfiguration config) throws IOException {
        this.facade.loadImages(imageReferences, config, new IPlateImageHandler(){

            @Override
            public void handlePlateImage(PlateImageReference plateImageReference, byte[] imageFileBytes) {
            }
        });
    }

    private List<PlateImageReference> findPlateImagesToLoad(int numberOfImagesDesired) {
        LoadThumbnailsPerformanceTest.print("Looking for images to load...");
        ArrayList<PlateImageReference> plateImages = new ArrayList<PlateImageReference>();
        List<Plate> plates = this.facade.listPlates();
        List<ImageDatasetReference> imageDatasets = this.facade.listRawImageDatasets(plates);
        if (imageDatasets.size() == 0) {
            return plateImages;
        }
        for (ImageDatasetReference imageDataset : imageDatasets) {
            this.addAllPlateImagesFromDataset(plateImages, imageDataset, numberOfImagesDesired);
            if (!this.isNumberOfImagesSufficient(plateImages, numberOfImagesDesired)) continue;
            break;
        }
        LoadThumbnailsPerformanceTest.print("...found " + plateImages.size() + " images.");
        return plateImages;
    }

    private void addAllPlateImagesFromDataset(ArrayList<PlateImageReference> plateImages, ImageDatasetReference imageDataset, int numberOfImagesDesired) {
        ImageDatasetMetadata metadata = this.facade.listImageMetadata(imageDataset);
        int numberOfRows = metadata.getTilesRows();
        int numberOfCols = metadata.getTilesCols();
        List<String> channels = Arrays.asList("Merged Channels");
        int numberOfTileRows = metadata.getTilesRows();
        int numberOfTileCols = metadata.getTilesCols();
        for (int row = 1; row <= numberOfRows; ++row) {
            for (int col = 1; col <= numberOfCols; ++col) {
                WellPosition well = new WellPosition(row, col);
                for (String channel : channels) {
                    for (int tileRow = 0; tileRow < numberOfTileRows; ++tileRow) {
                        for (int tileCol = 0; tileCol < numberOfTileCols; ++tileCol) {
                            int tile = tileRow * numberOfTileCols + tileCol;
                            PlateImageReference imageRef = new PlateImageReference(tile, channel, well, imageDataset);
                            plateImages.add(imageRef);
                            if (!this.isNumberOfImagesSufficient(plateImages, numberOfImagesDesired)) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private boolean isNumberOfImagesSufficient(ArrayList<PlateImageReference> plateImages, int numberOfImagesDesired) {
        return plateImages.size() > numberOfImagesDesired - 1;
    }

    public void logout() {
        this.facade.logout();
    }

    private static void print(String msg) {
        System.out.println(new Date() + "\t" + msg);
    }

    private static void configureLogging() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d %-5p [%t] %c - %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        PropertyConfigurator.configure((Properties)props);
    }
}

