/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactoryUsingWildcards;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.DelegatedClientPlugin;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.GenericDataSetViewer;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentViewer;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.material.GenericMaterialViewer;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningModule;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ExperimentAnalysisSummaryViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ExperimentViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImageDataSetViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImageSampleViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImagingMaterialViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialFeaturesFromAllExperimentsViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialReplicaSummaryViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MicroscopyDatasetViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.PlateDatasetViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.PlateSampleViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.sample.LibrarySampleBatchRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ClientPluginFactory
extends AbstractClientPluginFactory<ScreeningViewContext>
implements IClientPluginFactoryUsingWildcards {
    public ClientPluginFactory(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        super(originalViewContext);
    }

    public boolean isEnabled() {
        return this.checkEnabledProperty("screening");
    }

    protected final ScreeningViewContext createViewContext(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        return new ScreeningViewContext(originalViewContext);
    }

    public List<String> getOrderedEntityTypeCodes(EntityKind entityKind) {
        ArrayList<String> types = new ArrayList<String>();
        if (entityKind == EntityKind.SAMPLE) {
            types.add("PLATE.*");
            types.add("LIBRARY");
            types.add(".*CONTROL.*");
            types.add(".*WELL.*|.*CHAMBER.*|OLIGO|GENE");
            types.add(".*IMG.*");
        } else if (entityKind == EntityKind.MATERIAL) {
            types.add("GENE");
            types.add("SIRNA");
            types.add("CONTROL");
            types.add("COMPOUND");
        } else if (entityKind == EntityKind.DATA_SET) {
            types.add("HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)");
            types.add("MICROSCOPY_IMAGE|.*IMG.*");
        } else if (entityKind == EntityKind.EXPERIMENT) {
            types.add(".*HCS.*");
        }
        return types;
    }

    public final Set<String> getEntityTypeCodes(EntityKind entityKind) {
        HashSet<String> types = new HashSet<String>();
        types.addAll(this.getOrderedEntityTypeCodes(entityKind));
        return types;
    }

    public <T extends BasicEntityType, I extends IIdAndCodeHolder> IClientPlugin<T, I> createClientPlugin(EntityKind entityKind) {
        ScreeningViewContext viewContext = (ScreeningViewContext)this.getViewContext();
        if (EntityKind.MATERIAL.equals((Object)entityKind)) {
            return new MaterialClientPlugin((IViewContext)viewContext);
        }
        if (EntityKind.SAMPLE.equals((Object)entityKind)) {
            return new SampleClientPlugin(viewContext);
        }
        if (EntityKind.DATA_SET.equals((Object)entityKind)) {
            return new ImageDataSetViewerPlugin(viewContext);
        }
        if (EntityKind.EXPERIMENT.equals((Object)entityKind)) {
            return new ExperimentClientPlugin((IViewContext)viewContext);
        }
        throw new UnsupportedOperationException("IClientPlugin for entity kind '" + entityKind + "' not implemented yet.");
    }

    public static final void openImagingExperimentViewer(IEntityInformationHolderWithPermId experiment, boolean restrictGlobalScopeLinkToProject, IViewContext<IScreeningClientServiceAsync> viewContext) {
        if (viewContext.getModel().isEmbeddedMode()) {
            ExperimentAnalysisSummaryViewer.openTab(viewContext, new TechId((IIdAndCodeHolder)experiment), restrictGlobalScopeLinkToProject, null);
        } else {
            new OpenEntityDetailsTabAction(experiment, viewContext).execute();
        }
    }

    public static String createImagingExperimentViewerLink(IEntityInformationHolderWithPermId experiment, boolean restrictGlobalScopeLinkToProject, IViewContext<IScreeningClientServiceAsync> viewContext) {
        if (viewContext.getModel().isEmbeddedMode()) {
            return ScreeningLinkExtractor.createExperimentAnalysisSummaryBrowserLink(experiment.getPermId(), restrictGlobalScopeLinkToProject, null);
        }
        return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)experiment);
    }

    public static final void openImagingMaterialViewer(IEntityInformationHolderWithPermId material, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, boolean computeRanks, IViewContext<IScreeningClientServiceAsync> viewContext) {
        if (viewContext.getModel().isEmbeddedMode()) {
            MaterialIdentifier materialIdentifier = ClientPluginFactory.asMaterialIdentifier(material);
            WellSearchCriteria.ExperimentSearchByProjectCriteria multipleExperimentsScope = ClientPluginFactory.tryAsMultipleExperimentsCriteria(experimentCriteriaOrNull);
            if (multipleExperimentsScope != null) {
                MaterialFeaturesFromAllExperimentsViewer.openTab(viewContext, materialIdentifier, multipleExperimentsScope, analysisProcedureCriteria, computeRanks);
            } else {
                assert (experimentCriteriaOrNull != null);
                WellSearchCriteria.SingleExperimentSearchCriteria experiment = experimentCriteriaOrNull.tryGetExperiment();
                assert (experiment != null);
                MaterialReplicaSummaryViewer.openTab(viewContext, experiment.getExperimentPermId(), experimentCriteriaOrNull.getRestrictGlobalSearchLinkToProject(), materialIdentifier, analysisProcedureCriteria);
            }
        } else {
            ClientPluginFactory.openImagingMaterialGenericViewer(material, experimentCriteriaOrNull, analysisProcedureCriteria, viewContext);
        }
    }

    private static WellSearchCriteria.ExperimentSearchByProjectCriteria tryAsMultipleExperimentsCriteria(WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull) {
        if (experimentCriteriaOrNull == null) {
            return WellSearchCriteria.ExperimentSearchByProjectCriteria.createAllExperimentsForAllProjects();
        }
        if (experimentCriteriaOrNull.tryGetExperiment() != null) {
            return null;
        }
        BasicProjectIdentifier project = experimentCriteriaOrNull.tryGetProjectIdentifier();
        if (project != null) {
            return WellSearchCriteria.ExperimentSearchByProjectCriteria.createAllExperimentsForProject(project);
        }
        return WellSearchCriteria.ExperimentSearchByProjectCriteria.createAllExperimentsForAllProjects();
    }

    private static void openImagingMaterialGenericViewer(IEntityInformationHolderWithPermId material, WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, IViewContext<IScreeningClientServiceAsync> viewContext) {
        AbstractTabItemFactory tab = ClientPluginFactory.createImagingMaterialViewerTabFactory(material, experimentCriteriaOrNull, analysisProcedureCriteria, viewContext);
        DispatcherHelper.dispatchNaviEvent((AbstractTabItemFactory)tab);
    }

    private static MaterialIdentifier asMaterialIdentifier(IEntityInformationHolderWithPermId material) {
        return new MaterialIdentifier(material.getCode(), material.getEntityType().getCode());
    }

    private static final AbstractTabItemFactory createImagingMaterialViewerTabFactory(final IEntityInformationHolderWithPermId material, final WellSearchCriteria.ExperimentSearchCriteria experimentCriteriaOrNull, final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria, final IViewContext<IScreeningClientServiceAsync> viewContext) {
        return new AbstractTabItemFactory(){

            public ITabItem create() {
                TechId materialTechId = TechId.create((IIdHolder)material);
                DatabaseModificationAwareComponent viewer = ImagingMaterialViewer.create((IViewContext<IScreeningClientServiceAsync>)viewContext, materialTechId, experimentCriteriaOrNull, analysisProcedureCriteria);
                return ClientPluginFactory.createViewerTab(viewer, this.getTabTitle(), viewContext);
            }

            public String getId() {
                return GenericMaterialViewer.createId((TechId)TechId.create((IIdHolder)material));
            }

            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific((String)"Well Content Material Viewer");
            }

            public String getTabTitle() {
                return ClientPluginFactory.getViewerTitle("material", (ICodeHolder)material, (IMessageProvider)viewContext);
            }

            public String tryGetLink() {
                return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)material);
            }
        };
    }

    private static ITabItem createViewerTab(DatabaseModificationAwareComponent viewer, String title, IViewContext<?> viewContext) {
        return DefaultTabItem.create((String)title, (DatabaseModificationAwareComponent)viewer, viewContext, (boolean)false);
    }

    private static String getViewerTitle(String dictTitleKey, ICodeHolder codeProvider, IMessageProvider messageProvider) {
        return AbstractViewer.getTitle((IMessageProvider)messageProvider, (String)dictTitleKey, (ICodeHolder)codeProvider);
    }

    protected IModule maybeCreateModule() {
        return new ScreeningModule((ScreeningViewContext)this.getViewContext());
    }

    private final class SampleClientPlugin
    extends DelegatedClientPlugin<SampleType> {
        private final ScreeningViewContext screeningViewContext;

        private SampleClientPlugin(ScreeningViewContext viewContext) {
            super((IViewContext)viewContext, EntityKind.SAMPLE);
            this.screeningViewContext = viewContext;
        }

        public final AbstractTabItemFactory createEntityViewer(IEntityInformationHolderWithPermId entity) {
            String sampleTypeCode = entity.getEntityType().getCode();
            if (sampleTypeCode.matches("PLATE.*")) {
                if (entity.getPermId().contains(":")) {
                    String permId = entity.getPermId();
                    return this.createImageSampleViewer(entity, WellLocation.parseLocationStr(permId.substring(permId.indexOf(58) + 1)), false);
                }
                return this.createPlateViewer(entity);
            }
            if (sampleTypeCode.equals("LIBRARY")) {
                throw new UserFailureException("Cannot browse objects of the LIBRARY type.");
            }
            if (sampleTypeCode.matches(".*IMG.*")) {
                return this.createImageSampleViewer(entity, null, false);
            }
            return this.createImageSampleViewer(entity, null, true);
        }

        private AbstractTabItemFactory createImageSampleViewer(final IEntityInformationHolderWithPermId entity, final WellLocation wellLocationOrNull, final boolean isWellSample) {
            return new AbstractTabItemFactory(){

                public ITabItem create() {
                    DatabaseModificationAwareComponent viewer = ImageSampleViewer.create(SampleClientPlugin.this.screeningViewContext, (IIdAndCodeHolder)entity, wellLocationOrNull, isWellSample);
                    return ClientPluginFactory.createViewerTab(viewer, this.getTabTitle(), (IViewContext)SampleClientPlugin.this.screeningViewContext);
                }

                public String getId() {
                    TechId sampleId = TechId.create((IIdHolder)entity);
                    return GenericSampleViewer.createId((TechId)sampleId) + (wellLocationOrNull == null ? "" : ":" + wellLocationOrNull.toWellIdString());
                }

                public HelpPageIdentifier getHelpPageIdentifier() {
                    return HelpPageIdentifier.createSpecific((String)"Plate Well Viewer");
                }

                public String getTabTitle() {
                    if (isWellSample || wellLocationOrNull != null) {
                        ICodeHolder codeHolder = new ICodeHolder(){

                            public String getCode() {
                                if (wellLocationOrNull != null) {
                                    return entity.getCode() + ":" + wellLocationOrNull.toWellIdString();
                                }
                                return entity.getCode();
                            }
                        };
                        return ClientPluginFactory.getViewerTitle("WELL", codeHolder, (IMessageProvider)SampleClientPlugin.this.screeningViewContext);
                    }
                    return ClientPluginFactory.getViewerTitle("sample", (ICodeHolder)entity, (IMessageProvider)SampleClientPlugin.this.screeningViewContext);
                }

                public String tryGetLink() {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity);
                }
            };
        }

        private final AbstractTabItemFactory createPlateViewer(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                public ITabItem create() {
                    DatabaseModificationAwareComponent viewer = PlateSampleViewer.create(SampleClientPlugin.this.screeningViewContext, (IIdAndCodeHolder)entity);
                    return ClientPluginFactory.createViewerTab(viewer, this.getTabTitle(), (IViewContext)SampleClientPlugin.this.screeningViewContext);
                }

                public String getId() {
                    TechId sampleId = TechId.create((IIdHolder)entity);
                    return GenericSampleViewer.createId((TechId)sampleId);
                }

                public HelpPageIdentifier getHelpPageIdentifier() {
                    return HelpPageIdentifier.createSpecific((String)"Plate Sample Viewer");
                }

                public String getTabTitle() {
                    return ClientPluginFactory.getViewerTitle("PLATE", (ICodeHolder)entity, (IMessageProvider)SampleClientPlugin.this.screeningViewContext);
                }

                public String tryGetLink() {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity);
                }
            };
        }

        public Widget createBatchRegistrationForEntityType(SampleType type) {
            if (type.getCode().equals("LIBRARY")) {
                return new LibrarySampleBatchRegistrationForm((IViewContext<IScreeningClientServiceAsync>)ClientPluginFactory.this.getViewContext());
            }
            return super.createBatchRegistrationForEntityType((BasicEntityType)type);
        }
    }

    private final class ImageDataSetViewerPlugin
    extends DelegatedClientPlugin<DataSetType> {
        private final ScreeningViewContext screeningViewContext;

        private ImageDataSetViewerPlugin(ScreeningViewContext viewContext) {
            super((IViewContext)viewContext, EntityKind.DATA_SET);
            this.screeningViewContext = viewContext;
        }

        private AbstractTabItemFactory createImageDataSetViewer(final IEntityInformationHolderWithPermId entity, final WellLocation wellLocation) {
            return new AbstractTabItemFactory(){

                public ITabItem create() {
                    DatabaseModificationAwareComponent viewer = ImageDataSetViewer.create(ImageDataSetViewerPlugin.this.screeningViewContext, (IIdAndCodeHolder)entity, wellLocation);
                    return ClientPluginFactory.createViewerTab(viewer, this.getTabTitle(), (IViewContext)ImageDataSetViewerPlugin.this.screeningViewContext);
                }

                public String getId() {
                    TechId dataSetId = TechId.create((IIdHolder)entity);
                    return GenericDataSetViewer.createId((TechId)dataSetId);
                }

                public HelpPageIdentifier getHelpPageIdentifier() {
                    return HelpPageIdentifier.createSpecific((String)"Plate Well Viewer");
                }

                public String getTabTitle() {
                    return ClientPluginFactory.getViewerTitle("WELL", (ICodeHolder)entity, (IMessageProvider)ImageDataSetViewerPlugin.this.screeningViewContext);
                }

                public String tryGetLink() {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity);
                }
            };
        }

        public final AbstractTabItemFactory createEntityViewer(IEntityInformationHolderWithPermId entity) {
            String datasetTypeCode = entity.getEntityType().getCode();
            if (entity.getPermId().contains(":")) {
                String permId = entity.getPermId();
                return this.createImageDataSetViewer(entity, WellLocation.parseLocationStr(permId.substring(permId.indexOf(58) + 1)));
            }
            if (datasetTypeCode.matches("HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)")) {
                return this.createHCSImageDatasetTabItemFactory(entity);
            }
            if (datasetTypeCode.matches("MICROSCOPY_IMAGE|.*IMG.*")) {
                return this.createMicroscopyImageDatasetTabItemFactory(entity);
            }
            throw new IllegalStateException("Unknown dataset type " + datasetTypeCode);
        }

        private AbstractTabItemFactory createMicroscopyImageDatasetTabItemFactory(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                public ITabItem create() {
                    DatabaseModificationAwareComponent viewer = MicroscopyDatasetViewer.create(ImageDataSetViewerPlugin.this.screeningViewContext, (IIdAndCodeHolder)entity);
                    return ClientPluginFactory.createViewerTab(viewer, this.getTabTitle(), (IViewContext)ImageDataSetViewerPlugin.this.screeningViewContext);
                }

                public String getId() {
                    TechId id = TechId.create((IIdHolder)entity);
                    return GenericDataSetViewer.createId((TechId)id);
                }

                public HelpPageIdentifier getHelpPageIdentifier() {
                    return HelpPageIdentifier.createSpecific((String)"Microscopy Dataset Viewer");
                }

                public String getTabTitle() {
                    return ClientPluginFactory.getViewerTitle("data_set", (ICodeHolder)entity, (IMessageProvider)ImageDataSetViewerPlugin.this.screeningViewContext);
                }

                public String tryGetLink() {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity);
                }
            };
        }

        private AbstractTabItemFactory createHCSImageDatasetTabItemFactory(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                public ITabItem create() {
                    DatabaseModificationAwareComponent viewer = PlateDatasetViewer.create(ImageDataSetViewerPlugin.this.screeningViewContext, (IIdAndCodeHolder)entity);
                    return ClientPluginFactory.createViewerTab(viewer, this.getTabTitle(), (IViewContext)ImageDataSetViewerPlugin.this.screeningViewContext);
                }

                public String getId() {
                    TechId sampleId = TechId.create((IIdHolder)entity);
                    return GenericDataSetViewer.createId((TechId)sampleId);
                }

                public HelpPageIdentifier getHelpPageIdentifier() {
                    return HelpPageIdentifier.createSpecific((String)"Plate Dataset Viewer");
                }

                public String getTabTitle() {
                    return ClientPluginFactory.getViewerTitle("data_set", (ICodeHolder)entity, (IMessageProvider)ImageDataSetViewerPlugin.this.screeningViewContext);
                }

                public String tryGetLink() {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity);
                }
            };
        }
    }

    private final class ExperimentClientPlugin
    extends DelegatedClientPlugin<ExperimentType> {
        private ExperimentClientPlugin(IViewContext<IScreeningClientServiceAsync> viewContext) {
            super(viewContext, EntityKind.EXPERIMENT);
        }

        public final AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                public ITabItem create() {
                    DatabaseModificationAwareComponent experimentViewer = ExperimentViewer.createComponent((IViewContext<IScreeningClientServiceAsync>)ClientPluginFactory.this.getViewContext(), entity.getEntityType(), (IIdAndCodeHolder)entity);
                    return DefaultTabItem.create((String)this.getTabTitle(), (DatabaseModificationAwareComponent)experimentViewer, (IViewContext)ClientPluginFactory.this.getViewContext(), (boolean)false);
                }

                public String getId() {
                    return GenericExperimentViewer.createId((IIdAndCodeHolder)entity);
                }

                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                public String getTabTitle() {
                    return ClientPluginFactory.getViewerTitle("experiment", (ICodeHolder)entity, (IMessageProvider)ClientPluginFactory.this.getViewContext());
                }

                public String tryGetLink() {
                    return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)entity);
                }
            };
        }
    }

    private final class MaterialClientPlugin
    extends DelegatedClientPlugin<MaterialType> {
        private MaterialClientPlugin(IViewContext<IScreeningClientServiceAsync> viewContext) {
            super(viewContext, EntityKind.MATERIAL);
        }

        public final AbstractTabItemFactory createEntityViewer(IEntityInformationHolderWithPermId entity) {
            return ClientPluginFactory.createImagingMaterialViewerTabFactory(entity, null, WellSearchCriteria.AnalysisProcedureCriteria.createNoProcedures(), (IViewContext<IScreeningClientServiceAsync>)ClientPluginFactory.this.getViewContext());
        }
    }
}

