/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractPluginViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.IViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocatorResolverRegistry;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientService;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplaySettingsManager;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.ExperimentAnalysisSummaryResolver;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.GlobalWellSearchLocatorResolver;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.ImagingDataSetLocatorResolver;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.ImagingMaterialLocatorResolver;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.PlateMetadataBrowserLocatorResolver;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator.WellSearchLocatorResolver;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import com.google.gwt.core.client.GWT;
import java.util.HashMap;
import java.util.Map;

public final class ScreeningViewContext
extends AbstractPluginViewContext<IScreeningClientServiceAsync> {
    private static final String TECHNOLOGY_NAME = "screening";
    private Map<Long, ImageDatasetEnrichedReference> currentlyViewedPlateToDataSetMap = new HashMap<Long, ImageDatasetEnrichedReference>();

    public ScreeningViewContext(IViewContext<ICommonClientServiceAsync> commonViewContext) {
        super(commonViewContext);
    }

    public String getTechnology() {
        return TECHNOLOGY_NAME;
    }

    protected IScreeningClientServiceAsync createClientServiceAsync() {
        return (IScreeningClientServiceAsync)GWT.create(IScreeningClientService.class);
    }

    protected void initializeLocatorHandlerRegistry(ViewLocatorResolverRegistry handlerRegistry) {
        super.initializeLocatorHandlerRegistry(handlerRegistry);
        handlerRegistry.registerHandler((IViewLocatorResolver)new ImagingDataSetLocatorResolver((IViewContext<IScreeningClientServiceAsync>)this));
        handlerRegistry.registerHandler((IViewLocatorResolver)new ImagingMaterialLocatorResolver((IViewContext<IScreeningClientServiceAsync>)this));
        handlerRegistry.registerHandler((IViewLocatorResolver)new PlateMetadataBrowserLocatorResolver((IViewContext<IScreeningClientServiceAsync>)this));
        handlerRegistry.registerHandler((IViewLocatorResolver)new WellSearchLocatorResolver((IViewContext<IScreeningClientServiceAsync>)this));
        handlerRegistry.registerHandler((IViewLocatorResolver)new GlobalWellSearchLocatorResolver((IViewContext<IScreeningClientServiceAsync>)this));
        handlerRegistry.registerHandler((IViewLocatorResolver)new ExperimentAnalysisSummaryResolver((IViewContext<IScreeningClientServiceAsync>)this));
    }

    public ScreeningDisplaySettingsManager getTechnologySpecificDisplaySettingsManager() {
        return ScreeningViewContext.getTechnologySpecificDisplaySettingsManager(this);
    }

    public static ScreeningDisplaySettingsManager getTechnologySpecificDisplaySettingsManager(IViewContext<?> viewContext) {
        return new ScreeningDisplaySettingsManager(viewContext);
    }

    public ImageDatasetEnrichedReference tryCurrentlyViewedPlateDataSet(Long plateId) {
        return this.currentlyViewedPlateToDataSetMap.get(plateId);
    }

    public void setCurrentlyViewedPlateDataSet(Long plateId, ImageDatasetEnrichedReference dataSet) {
        this.currentlyViewedPlateToDataSetMap.put(plateId, dataSet);
    }
}

