/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleModelComboBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplaySettingsManager;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.utils.GuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.AnalysisProcedures;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AnalysisProcedureChooser
extends LayoutContainer {
    private static final String UNSPECIFIED_PROCEDURE = "Unspecified";
    private static final String ALL_PROCEDURES = "All";
    private final IMessageProvider messageProvider;
    private final ScreeningDisplaySettingsManager screeningDisplaySettingsManager;
    private final IAnalysisProcedureSelectionListener selectionListener;
    private final AnalysisProcedureLister analysisProcedureLister;
    private final SimpleModelComboBox<String> analysisProceduresComboBox;
    private final boolean displaySelectAllProcedures;
    private final Listener<BaseEvent> selectionChangeListener = new Listener<BaseEvent>(){

        public void handleEvent(BaseEvent be) {
            AnalysisProcedureChooser.this.selectionChanged();
        }
    };

    public static final AnalysisProcedureChooser createHorizontal(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteriaHolder experimentCriteriaHolder, WellSearchCriteria.AnalysisProcedureCriteria initialSelection, IAnalysisProcedureSelectionListener selectionListener, boolean triggerInitialSelectionEvent) {
        AnalysisProcedureLister analysisProcedureLister = AnalysisProcedureChooser.createNumericalDatasetsAnalysisProcedureLister(viewContext, experimentCriteriaHolder);
        return new AnalysisProcedureChooser(viewContext, analysisProcedureLister, initialSelection, selectionListener, triggerInitialSelectionEvent, true);
    }

    public static final AnalysisProcedureChooser createVertical(IViewContext<IScreeningClientServiceAsync> viewContext, WellSearchCriteria.ExperimentSearchCriteriaHolder experimentCriteriaHolder, WellSearchCriteria.AnalysisProcedureCriteria initialSelection, IAnalysisProcedureSelectionListener selectionListener, boolean triggerInitialSelectionEvent) {
        AnalysisProcedureLister analysisProcedureLister = AnalysisProcedureChooser.createNumericalDatasetsAnalysisProcedureLister(viewContext, experimentCriteriaHolder);
        return new AnalysisProcedureChooser(viewContext, analysisProcedureLister, initialSelection, selectionListener, triggerInitialSelectionEvent, false);
    }

    public static final AnalysisProcedureChooser create(IViewContext<?> viewContext, final AnalysisProcedures analysisProcedures, WellSearchCriteria.AnalysisProcedureCriteria initialSelection, IAnalysisProcedureSelectionListener selectionListener) {
        AnalysisProcedureLister analysisProcedureLister = new AnalysisProcedureLister(){

            @Override
            public void listNumericalDatasetsAnalysisProcedures(AsyncCallback<AnalysisProcedures> resultsCallback) {
                resultsCallback.onSuccess((Object)analysisProcedures);
            }
        };
        return new AnalysisProcedureChooser(viewContext, analysisProcedureLister, initialSelection, selectionListener, true, false);
    }

    private static AnalysisProcedureLister createNumericalDatasetsAnalysisProcedureLister(final IViewContext<IScreeningClientServiceAsync> viewContext, final WellSearchCriteria.ExperimentSearchCriteriaHolder experimentCriteriaHolder) {
        return new AnalysisProcedureLister(){

            @Override
            public void listNumericalDatasetsAnalysisProcedures(AsyncCallback<AnalysisProcedures> resultsCallback) {
                ((IScreeningClientServiceAsync)viewContext.getService()).listNumericalDatasetsAnalysisProcedures(experimentCriteriaHolder.tryGetCriteria(), resultsCallback);
            }
        };
    }

    private AnalysisProcedureChooser(IViewContext<?> viewContext, AnalysisProcedureLister analysisProcedureLister, WellSearchCriteria.AnalysisProcedureCriteria initialSelection, IAnalysisProcedureSelectionListener selectionListener, boolean triggerInitialSelectionEvent, boolean horizontalLayout) {
        this.messageProvider = viewContext;
        this.screeningDisplaySettingsManager = new ScreeningDisplaySettingsManager(viewContext);
        this.selectionListener = selectionListener;
        this.analysisProcedureLister = analysisProcedureLister;
        this.analysisProceduresComboBox = this.createLayout(horizontalLayout);
        this.displaySelectAllProcedures = initialSelection.isAllProcedures();
        this.initSelection(initialSelection, triggerInitialSelectionEvent);
    }

    private SimpleModelComboBox<String> createLayout(boolean horizontalLayout) {
        Widget layoutPanel;
        SimpleModelComboBox<String> comboBox = this.createProceduresComboBox();
        if (horizontalLayout) {
            layoutPanel = GuiUtils.withLabel(comboBox, this.getAnalysisProcedureLabel());
        } else {
            VerticalPanel panel = AnalysisProcedureChooser.createVerticalPanel();
            panel.setAutoHeight(true);
            panel.add((Widget)this.createComboLabel());
            panel.add(comboBox);
            layoutPanel = panel;
        }
        this.add(layoutPanel);
        return comboBox;
    }

    private static VerticalPanel createVerticalPanel() {
        VerticalPanel layoutPanel = new VerticalPanel();
        layoutPanel.setStyleAttribute("margin-right", "40px");
        return layoutPanel;
    }

    private void initSelection(WellSearchCriteria.AnalysisProcedureCriteria initialSelection, boolean triggerEvents) {
        if (!triggerEvents) {
            this.disableEvents(true);
        }
        this.refresh(initialSelection);
        if (!triggerEvents) {
            this.enableEvents(true);
        }
    }

    public void updateAnalysisProcedures() {
        this.refresh(this.getSelectionAsCriteria());
    }

    private void refresh(final WellSearchCriteria.AnalysisProcedureCriteria selectedProcedureCriteria) {
        this.analysisProceduresComboBox.removeAll();
        this.analysisProcedureLister.listNumericalDatasetsAnalysisProcedures(new AsyncCallback<AnalysisProcedures>(){

            public void onSuccess(AnalysisProcedures analysisProcedures) {
                AnalysisProcedureChooser.this.refresh(selectedProcedureCriteria, analysisProcedures);
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    private void refresh(WellSearchCriteria.AnalysisProcedureCriteria selectedProcedureCriteria, AnalysisProcedures analysisProcedures) {
        this.addAnalysisProcedures(analysisProcedures.getProcedureCodes());
        this.setInitialSelection(selectedProcedureCriteria);
    }

    private Component createComboLabel() {
        LabelToolItem label = new LabelToolItem(this.getAnalysisProcedureLabel());
        label.addStyleName("default-text");
        return label;
    }

    private String getAnalysisProcedureLabel() {
        return this.messageProvider.getMessage("ANALYSIS_PROCEDURE", new Object[0]) + ":";
    }

    private SimpleModelComboBox<String> createProceduresComboBox() {
        SimpleModelComboBox comboBox = new SimpleModelComboBox(this.messageProvider, new ArrayList(), null);
        comboBox.setTriggerAction(ComboBox.TriggerAction.ALL);
        comboBox.setAllowBlank(false);
        comboBox.setEditable(false);
        comboBox.setEmptyText(this.messageProvider.getMessage("load_in_progress", new Object[0]));
        comboBox.addListener(Events.SelectionChange, this.selectionChangeListener);
        return comboBox;
    }

    private void addAnalysisProcedures(List<String> codes) {
        for (String code : this.transformAndSortCodes(codes)) {
            this.addCodeToComboBox(code);
        }
    }

    private List<String> transformAndSortCodes(List<String> codes) {
        ArrayList<String> sortedCodes = new ArrayList<String>();
        for (String code : codes) {
            sortedCodes.add(this.unspecifiedIfEmpty(code));
        }
        boolean unspecifiedPresent = sortedCodes.remove(UNSPECIFIED_PROCEDURE);
        Collections.sort(sortedCodes);
        if (this.displaySelectAllProcedures) {
            sortedCodes.add(0, ALL_PROCEDURES);
        }
        if (unspecifiedPresent) {
            sortedCodes.add(UNSPECIFIED_PROCEDURE);
        }
        return sortedCodes;
    }

    private void addCodeToComboBox(String code) {
        if (this.analysisProceduresComboBox.findModelForVal((Object)code) == null) {
            this.analysisProceduresComboBox.add(new LabeledItem((Object)code, code));
        }
    }

    private void setInitialSelection(WellSearchCriteria.AnalysisProcedureCriteria selectedProcedureCriteria) {
        String comboBoxValue;
        String analysisProcedureOrNull = selectedProcedureCriteria.tryGetAnalysisProcedureCode();
        if (StringUtils.isBlank((String)analysisProcedureOrNull)) {
            analysisProcedureOrNull = this.getDefaultAnalysisProcedure();
        }
        if (StringUtils.isBlank((String)(comboBoxValue = analysisProcedureOrNull))) {
            comboBoxValue = selectedProcedureCriteria.isNoProcedures() ? UNSPECIFIED_PROCEDURE : ALL_PROCEDURES;
        }
        LabeledItem<String> valueToSelect = this.analysisProceduresComboBox.findModelForVal((Object)comboBoxValue);
        if (UNSPECIFIED_PROCEDURE.equals(comboBoxValue) || valueToSelect == null) {
            valueToSelect = this.getFirstValueFromCombo();
        }
        this.analysisProceduresComboBox.setSimpleValue(valueToSelect);
    }

    private LabeledItem<String> getFirstValueFromCombo() {
        return (LabeledItem)((SimpleComboValue)this.analysisProceduresComboBox.getStore().getAt(0)).getValue();
    }

    private void selectionChanged() {
        WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria = this.getSelectionAsCriteria();
        this.selectionListener.analysisProcedureSelected(analysisProcedureCriteria);
        this.setDefaultAnalysisProcedure(analysisProcedureCriteria);
    }

    private WellSearchCriteria.AnalysisProcedureCriteria getSelectionAsCriteria() {
        String selectedAP = (String)this.analysisProceduresComboBox.tryGetChosenItem();
        if (UNSPECIFIED_PROCEDURE.equals(selectedAP)) {
            return WellSearchCriteria.AnalysisProcedureCriteria.createNoProcedures();
        }
        if (StringUtils.isBlank((String)selectedAP) || ALL_PROCEDURES.equals(selectedAP)) {
            return WellSearchCriteria.AnalysisProcedureCriteria.createAllProcedures();
        }
        return WellSearchCriteria.AnalysisProcedureCriteria.createFromCode(selectedAP);
    }

    private String getDefaultAnalysisProcedure() {
        return this.screeningDisplaySettingsManager.getDefaultAnalysisProcedure();
    }

    private void setDefaultAnalysisProcedure(WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        String analysisProcedureCode;
        String string = analysisProcedureCode = analysisProcedureCriteria.isAllProcedures() ? ALL_PROCEDURES : analysisProcedureCriteria.tryGetAnalysisProcedureCode();
        if (StringUtils.isNotBlank((String)analysisProcedureCode)) {
            this.screeningDisplaySettingsManager.setDefaultAnalysisProcedure(analysisProcedureCode);
        }
    }

    private String unspecifiedIfEmpty(String analysisProcedureOrNull) {
        return StringUtils.isBlank((String)analysisProcedureOrNull) ? UNSPECIFIED_PROCEDURE : analysisProcedureOrNull;
    }

    private static interface AnalysisProcedureLister {
        public void listNumericalDatasetsAnalysisProcedures(AsyncCallback<AnalysisProcedures> var1);
    }

    public static interface IAnalysisProcedureSelectionListener {
        public void analysisProcedureSelected(WellSearchCriteria.AnalysisProcedureCriteria var1);
    }
}

