/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.CheckBoxGroupWithModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleModelComboBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ChannelChooserPanel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.IDefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImagingDatasetGuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ResolutionChooser;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.ImageDatasetChannel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageChannelsReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.EntityTypeLabelUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.utils.GuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetOverlayImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageTransformationInfo;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.MarginData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ChannelChooser {
    private static final String OVERLAYS_MSG = "Overlays:";
    private static final String CHANNEL_MSG = "Channel:";
    private final IChanneledViewerFactory viewerFactory;
    private final IDefaultChannelState defaultChannelState;
    private final LayoutContainer imageContainer;
    private ResolutionChooser resolutionChooser;
    private LogicalImageReference basicImage;
    private Set<ImageDatasetChannel> selectedOverlayChannels;
    private List<String> basicChannelCodes;
    private String imageTransformationCodeOrNull;
    private Map<String, IntensityRange> rangesOrNull;
    private final String windowId;

    public ChannelChooser(LogicalImageReference basicImage, IChanneledViewerFactory viewerFactory, IDefaultChannelState defaultChannelState, String windowId) {
        this.basicImage = basicImage;
        this.viewerFactory = viewerFactory;
        this.imageContainer = new LayoutContainer();
        this.basicChannelCodes = ChannelChooser.getInitialChannelCodes(defaultChannelState, basicImage.getChannelsCodes());
        this.imageTransformationCodeOrNull = ChannelChooser.tryGetInitialImageTransformationCode(defaultChannelState, this.basicChannelCodes, basicImage.getImagetParameters());
        this.rangesOrNull = ChannelChooser.tryGetInitialIntensityRange(defaultChannelState, this.basicChannelCodes);
        this.defaultChannelState = defaultChannelState;
        this.selectedOverlayChannels = new HashSet<ImageDatasetChannel>();
        this.windowId = windowId;
    }

    public void refresh(LogicalImageReference updatedBasicImage) {
        this.basicImage = updatedBasicImage;
        this.refresh();
    }

    public void refresh() {
        LogicalImageChannelsReference state = new LogicalImageChannelsReference(this.basicImage, this.basicChannelCodes, this.imageTransformationCodeOrNull, this.rangesOrNull, this.selectedOverlayChannels);
        LayoutContainer view = this.viewerFactory.create(state, this.resolutionChooser != null ? this.resolutionChooser.getResolution() : null);
        this.imageContainer.removeAll();
        this.imageContainer.add((Widget)view);
        this.imageContainer.layout();
    }

    public void addViewerTo(final LayoutContainer container, IViewContext<IScreeningClientServiceAsync> context, AsyncCallback<Void> callback) {
        Text loading = new Text(context.getMessage("load_in_progress", new Object[0]));
        container.add((Widget)loading);
        ((IScreeningClientServiceAsync)context.getService()).getImageDatasetResolutions(this.basicImage.getDatasetCode(), this.basicImage.getDatastoreCode(), (AsyncCallback<List<ImageResolution>>)new AbstractAsyncCallback<List<ImageResolution>>(context, (Widget)loading, context, callback){
            final /* synthetic */ Widget val$loading;
            final /* synthetic */ IViewContext val$context;
            final /* synthetic */ AsyncCallback val$callback;
            {
                this.val$loading = widget;
                this.val$context = iViewContext;
                this.val$callback = asyncCallback;
                super(arg0);
            }

            protected void process(List<ImageResolution> resolutions) {
                container.remove(this.val$loading);
                List<DatasetOverlayImagesReference> overlayDatasets = ChannelChooser.this.basicImage.getOverlayDatasets();
                if (overlayDatasets.size() > 0) {
                    container.add(ChannelChooser.this.createOverlayChannelsChooser(overlayDatasets, this.val$context));
                }
                if (ChannelChooser.this.basicImage.getChannelsCodes().size() > 0) {
                    Widget channelChooserWithLabel = ChannelChooser.this.createBasicChannelChooser((IViewContext<IScreeningClientServiceAsync>)this.val$context);
                    container.add(channelChooserWithLabel);
                }
                container.add(ChannelChooser.this.createResolutionChooser((IViewContext<IScreeningClientServiceAsync>)this.val$context, resolutions), (LayoutData)new MarginData(5, 0, 5, 0));
                container.add((Widget)ChannelChooser.this.imageContainer);
                container.layout();
                if (this.val$callback != null) {
                    this.val$callback.onSuccess(null);
                }
                ChannelChooser.this.refresh();
            }
        });
    }

    private static Map<String, List<DatasetOverlayImagesReference>> groupByAnalysisProcedure(List<DatasetOverlayImagesReference> overlayDatasets) {
        return GroupByMap.create(overlayDatasets, (IGroupKeyExtractor)new IGroupKeyExtractor<String, DatasetOverlayImagesReference>(){

            public String getKey(DatasetOverlayImagesReference dataset) {
                return dataset.tryGetAnalysisProcedure();
            }
        }).getMap();
    }

    public Widget createAndConnectOverlayImageDatasetChooser(String labelText, List<DatasetOverlayImagesReference> imageDatasets, final OverlayDataSetSelectionListener listener, IViewContext<?> viewContext) {
        List<String> labels = EntityTypeLabelUtils.createDatasetLabels(ChannelChooser.overlaysAsReferences(imageDatasets), true, true);
        imageDatasets.add(0, null);
        labels.add(0, "All");
        SimpleModelComboBox<DatasetOverlayImagesReference> datasetChooser = ImagingDatasetGuiUtils.createDatasetChooserComboBox(viewContext, imageDatasets, labels, labels);
        datasetChooser.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SimpleComboValue<LabeledItem<DatasetOverlayImagesReference>>>(){

            public void selectionChanged(SelectionChangedEvent<SimpleComboValue<LabeledItem<DatasetOverlayImagesReference>>> se) {
                DatasetOverlayImagesReference chosenDataset = (DatasetOverlayImagesReference)SimpleModelComboBox.getChosenItem(se);
                listener.overlayDataSetSelected(chosenDataset);
            }
        });
        DatasetOverlayImagesReference chosenDataset = (DatasetOverlayImagesReference)datasetChooser.tryGetChosenItem();
        listener.overlayDataSetSelected(chosenDataset);
        return ImagingDatasetGuiUtils.withLabel(datasetChooser, labelText);
    }

    private static List<DatasetReference> overlaysAsReferences(List<DatasetOverlayImagesReference> imageDatasets) {
        ArrayList<DatasetReference> refs = new ArrayList<DatasetReference>();
        for (DatasetOverlayImagesReference dataset : imageDatasets) {
            DatasetReference r = dataset.getDatasetReference();
            refs.add(r);
        }
        return refs;
    }

    private Widget createOverlayChannelsChooser(List<DatasetOverlayImagesReference> overlayDatasets, IViewContext<?> viewContext) {
        LinkedList<DatasetOverlayImagesReference> sortedDataSets = new LinkedList<DatasetOverlayImagesReference>(overlayDatasets);
        Collections.sort(sortedDataSets, new ProcedureDatasetSortingOrder());
        Map<String, List<DatasetOverlayImagesReference>> datasetsByAnalysisProcMap = ChannelChooser.groupByAnalysisProcedure(overlayDatasets);
        if (sortedDataSets.size() > 1) {
            LayoutContainer chooserPanel = new LayoutContainer();
            chooserPanel.setLayout((Layout)new RowLayout());
            LayoutContainer objectsChooserContainer = new LayoutContainer();
            OverlayDataSetSelectionListener selectionListener = this.createAnalysisProcedureSelectionListener(datasetsByAnalysisProcMap, objectsChooserContainer);
            Widget overlaysChooser = this.createAndConnectOverlayImageDatasetChooser(OVERLAYS_MSG, sortedDataSets, selectionListener, viewContext);
            chooserPanel.add(overlaysChooser);
            chooserPanel.add((Widget)objectsChooserContainer);
            return chooserPanel;
        }
        LayoutContainer objectsChooserContainer = new LayoutContainer();
        this.addOverlayChannelsChoosers(sortedDataSets, objectsChooserContainer);
        return objectsChooserContainer;
    }

    private OverlayDataSetSelectionListener createAnalysisProcedureSelectionListener(final Map<String, List<DatasetOverlayImagesReference>> datasetsByAnalysisProcMap, final LayoutContainer objectsChooserContainer) {
        return new OverlayDataSetSelectionListener(){

            @Override
            public void overlayDataSetSelected(DatasetOverlayImagesReference reference) {
                ChannelChooser.this.refreshObjectChooser(reference, datasetsByAnalysisProcMap, objectsChooserContainer);
            }
        };
    }

    private void refreshObjectChooser(DatasetOverlayImagesReference image, Map<String, List<DatasetOverlayImagesReference>> datasetsByAnalysisProcMap, LayoutContainer objectsChooserContainer) {
        LinkedList<DatasetOverlayImagesReference> overlayDatasetsForOneAnalysisProc = new LinkedList<DatasetOverlayImagesReference>();
        if (image == null) {
            for (String ap : datasetsByAnalysisProcMap.keySet()) {
                overlayDatasetsForOneAnalysisProc.addAll((Collection<DatasetOverlayImagesReference>)datasetsByAnalysisProcMap.get(ap));
            }
        } else {
            overlayDatasetsForOneAnalysisProc.add(image);
        }
        objectsChooserContainer.removeAll();
        if (overlayDatasetsForOneAnalysisProc.size() > 0) {
            this.addOverlayChannelsChoosers(overlayDatasetsForOneAnalysisProc, objectsChooserContainer);
        }
        objectsChooserContainer.layout();
        this.updateSelectedOverlayChannels(Collections.emptyList());
    }

    private List<List<DatasetOverlayImagesReference>> splitIntoGroupsOfIdenticalAnalysisProcedure(List<DatasetOverlayImagesReference> overlayDatasets) {
        LinkedList<DatasetOverlayImagesReference> sortedDataSets = new LinkedList<DatasetOverlayImagesReference>();
        sortedDataSets.addAll(overlayDatasets);
        Collections.sort(sortedDataSets, new ProcedureDatasetSortingOrder());
        LinkedList<List<DatasetOverlayImagesReference>> result = new LinkedList<List<DatasetOverlayImagesReference>>();
        LinkedList<DatasetOverlayImagesReference> group = null;
        String currentAP = null;
        for (DatasetOverlayImagesReference dataSet : sortedDataSets) {
            String localAP = dataSet.tryGetAnalysisProcedure();
            if (localAP == null || localAP.isEmpty()) {
                localAP = "Unspecified Analysis Procedure";
            }
            if (!localAP.equals(currentAP)) {
                group = null;
            }
            if (group == null) {
                group = new LinkedList<DatasetOverlayImagesReference>();
                result.add(group);
                currentAP = localAP;
            }
            group.add(dataSet);
        }
        return result;
    }

    private void addOverlayChannelsChoosers(List<DatasetOverlayImagesReference> overlayDatasets, LayoutContainer objectsChooserContainer) {
        List<List<DatasetOverlayImagesReference>> groups = this.splitIntoGroupsOfIdenticalAnalysisProcedure(overlayDatasets);
        if (groups.size() == 1 && overlayDatasets.size() > 1) {
            objectsChooserContainer.add((Widget)new HTML(OVERLAYS_MSG));
        }
        LinkedList<CheckBoxGroupWithModel<ImageDatasetChannel>> checkboxGroups = new LinkedList<CheckBoxGroupWithModel<ImageDatasetChannel>>();
        for (List<DatasetOverlayImagesReference> group : groups) {
            Object container;
            if (groups.size() == 1) {
                container = objectsChooserContainer;
            } else {
                String analysisProcedure = group.get(0).tryGetAnalysisProcedure();
                if (analysisProcedure == null || analysisProcedure.isEmpty()) {
                    analysisProcedure = "Unspecified Analysis Procedure";
                }
                container = new SectionFieldSet(analysisProcedure);
            }
            for (DatasetOverlayImagesReference dataSet : group) {
                container.add(this.createOverlayChannelsChooserForOneDataSet(dataSet, overlayDatasets.size() != 1, checkboxGroups));
            }
            if (container == objectsChooserContainer) continue;
            objectsChooserContainer.add((Widget)container);
        }
    }

    private Widget createOverlayChannelsChooserForOneDataSet(DatasetOverlayImagesReference overlayDataset, boolean withLabel, final List<CheckBoxGroupWithModel<ImageDatasetChannel>> checkboxes) {
        List<LabeledItem<ImageDatasetChannel>> overlayChannelItems = ChannelChooser.createOverlayChannelItems(overlayDataset);
        CheckBoxGroupWithModel checkBoxGroup = new CheckBoxGroupWithModel(overlayChannelItems);
        checkBoxGroup.addListener((CheckBoxGroupWithModel.CheckBoxGroupListner)new CheckBoxGroupWithModel.CheckBoxGroupListner<ImageDatasetChannel>(){

            public void onChange(Set<ImageDatasetChannel> selected) {
                ChannelChooser.this.updateSelectedOverlayChannels(checkboxes);
            }
        });
        checkboxes.add((CheckBoxGroupWithModel<ImageDatasetChannel>)checkBoxGroup);
        String label = OVERLAYS_MSG;
        if (withLabel) {
            String extraLabel = overlayDataset.getDatasetReference().getLabelText() == null ? "" : ", " + overlayDataset.getDatasetReference().getLabelText();
            label = overlayDataset.getDatasetCode() + extraLabel + ":";
        }
        return GuiUtils.withLabel((Widget)checkBoxGroup, label);
    }

    private void updateSelectedOverlayChannels(List<CheckBoxGroupWithModel<ImageDatasetChannel>> checkboxes) {
        this.selectedOverlayChannels = new HashSet<ImageDatasetChannel>();
        for (CheckBoxGroupWithModel<ImageDatasetChannel> checkbox : checkboxes) {
            this.selectedOverlayChannels.addAll(checkbox.getSelected());
        }
        this.refresh();
    }

    private static List<LabeledItem<ImageDatasetChannel>> createOverlayChannelItems(DatasetImagesReference overlayDataset) {
        ArrayList<LabeledItem<ImageDatasetChannel>> items = new ArrayList<LabeledItem<ImageDatasetChannel>>();
        ImageDatasetParameters imageParams = overlayDataset.getImageParameters();
        for (int i = 0; i < imageParams.getChannelsNumber(); ++i) {
            InternalImageChannel channel = imageParams.getInternalChannels().get(i);
            String channelCode = channel.getCode();
            String channelLabel = channel.getLabel();
            LabeledItem<ImageDatasetChannel> item = ChannelChooser.createLabeledItem(overlayDataset, channelCode, channelLabel);
            items.add(item);
        }
        return items;
    }

    private static LabeledItem<ImageDatasetChannel> createLabeledItem(DatasetImagesReference overlayDataset, String channelCode, String channelLabel) {
        ImageDatasetChannel overlayChannel = ChannelChooser.createImageDatasetChannel(overlayDataset, channelCode);
        return new LabeledItem((Object)overlayChannel, channelLabel);
    }

    private static ImageDatasetChannel createImageDatasetChannel(DatasetImagesReference dataset, String channelCode) {
        return new ImageDatasetChannel(dataset.getDatasetCode(), dataset.getDatastoreHostUrl(), channelCode);
    }

    private Widget createBasicChannelChooser(IViewContext<IScreeningClientServiceAsync> viewContext) {
        ChannelChooserPanel channelChooser = new ChannelChooserPanel((IMessageProvider)viewContext, this.defaultChannelState, this.basicChannelCodes, this.basicImage.getImagetParameters());
        channelChooser.addSelectionChangedListener(new ChannelChooserPanel.ChannelSelectionListener(){

            @Override
            public void selectionChanged(List<String> newlySelectedChannels, String imageTransformationCodeOrNull, Map<String, IntensityRange> rangesOrNull) {
                ChannelChooser.this.basicChannelCodes = newlySelectedChannels;
                ChannelChooser.this.imageTransformationCodeOrNull = imageTransformationCodeOrNull;
                ChannelChooser.this.rangesOrNull = rangesOrNull;
                ChannelChooser.this.refresh();
            }
        });
        return GuiUtils.withLabel((Widget)channelChooser, CHANNEL_MSG, 0, 80);
    }

    private Widget createResolutionChooser(IViewContext<IScreeningClientServiceAsync> viewContext, List<ImageResolution> resolutions) {
        if (this.resolutionChooser == null) {
            this.resolutionChooser = new ResolutionChooser(viewContext, resolutions, this.defaultChannelState.tryGetDefaultResolution(this.windowId));
            this.resolutionChooser.addResolutionChangedListener(new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    ChannelChooser.this.defaultChannelState.setDefaultResolution(ChannelChooser.this.resolutionChooser.getResolution(), ChannelChooser.this.windowId);
                    ChannelChooser.this.refresh();
                }
            });
        }
        return GuiUtils.withLabel((Widget)this.resolutionChooser, viewContext.getMessage("RESOLUTION_CHOOSER_LABEL", new Object[0]), 0, 80);
    }

    private static List<String> getInitialChannelCodes(IDefaultChannelState defaultChannelState, List<String> channels) {
        List<String> defaultChannels = defaultChannelState.tryGetDefaultChannels();
        if (defaultChannels == null || !channels.containsAll(defaultChannels)) {
            return channels;
        }
        return defaultChannels;
    }

    private static String tryGetInitialImageTransformationCode(IDefaultChannelState defaultChannelState, List<String> channels, ImageDatasetParameters imageParameters) {
        if (imageParameters != null) {
            String channel = channels.size() == 1 ? channels.get(0) : "Merged Channels";
            String initialTransformation = defaultChannelState.tryGetDefaultTransformation(channel);
            if ("$DEFAULT$".equals(initialTransformation)) {
                return null;
            }
            String defaultSelection = null;
            List<InternalImageTransformationInfo> transformations = imageParameters.getAvailableImageTransformationsFor(channel);
            for (InternalImageTransformationInfo transformation : transformations) {
                if (transformation.getCode().equals(initialTransformation)) {
                    return initialTransformation;
                }
                if (!transformation.isDefault() || defaultSelection != null) continue;
                defaultSelection = transformation.getCode();
            }
            return defaultSelection;
        }
        return null;
    }

    private static Map<String, IntensityRange> tryGetInitialIntensityRange(IDefaultChannelState defaultChannelState, List<String> channels) {
        HashMap<String, IntensityRange> ranges = new HashMap<String, IntensityRange>();
        for (String channel : channels) {
            IntensityRange rangeOrNull = defaultChannelState.tryGetIntensityRange(channel);
            ranges.put(channel, rangeOrNull);
        }
        return ranges;
    }

    private static final class SectionFieldSet
    extends FieldSet {
        public SectionFieldSet(String sectionName) {
            this.createForm(sectionName);
        }

        private void createForm(String sectionName) {
            this.setHeading(sectionName);
            this.setLayout((Layout)this.createFormLayout());
            this.setAutoWidth(true);
        }

        private final FormLayout createFormLayout() {
            FormLayout formLayout = new FormLayout();
            formLayout.setLabelWidth(109);
            formLayout.setDefaultWidth(500);
            return formLayout;
        }
    }

    private static class ProcedureDatasetSortingOrder
    implements Comparator<DatasetOverlayImagesReference> {
        private ProcedureDatasetSortingOrder() {
        }

        private String key(DatasetOverlayImagesReference dataSet) {
            return dataSet.tryGetAnalysisProcedure() + ":" + dataSet.getDatasetCode();
        }

        @Override
        public int compare(DatasetOverlayImagesReference one, DatasetOverlayImagesReference two) {
            return this.key(one).compareTo(this.key(two));
        }
    }

    public static interface OverlayDataSetSelectionListener {
        public void overlayDataSetSelected(DatasetOverlayImagesReference var1);
    }

    public static interface IChanneledViewerFactory {
        public LayoutContainer create(LogicalImageChannelsReference var1, ImageResolution var2);
    }
}

