/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleModelComboBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.IDefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.UserDefinedRescalingSettingsDialog;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageTransformationInfo;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChannelChooserPanel
extends LayoutContainer {
    public static final String DEFAULT_TRANSFORMATION_CODE = "$DEFAULT$";
    private static final LabeledItem<InternalImageTransformationInfo> DEFAULT_TRANSFORMATION = ChannelChooserPanel.convertToLabeledItem(new InternalImageTransformationInfo("$DEFAULT$", "Optimal (image)", "Grayscale images with color depth higher then 8 bits are transformed in the optimal way for a single image. Otherwise no filter is applied.", "", false));
    private final IMessageProvider messageProvider;
    private IDefaultChannelState defaultChannelState;
    private CheckBoxGroup channelsCheckBoxGroup;
    private SimpleModelComboBox<String> channelsComboBox;
    private SimpleModelComboBox<InternalImageTransformationInfo> transformationsComboBox;
    private LabelField adjustLabel = new LabelField("Filter:");
    private Button userDefinedTransformationSettingsButton = new Button("Settings");
    private AdapterField userDefinedTransformationSettingsButtonField = new AdapterField((Widget)this.userDefinedTransformationSettingsButton);
    private Map<String, Set<InternalImageTransformationInfo>> transformationsForChannels = new HashMap<String, Set<InternalImageTransformationInfo>>();
    private List<ChannelSelectionListener> channelSelectionListeners = new ArrayList<ChannelSelectionListener>();
    private Map<String, IntensityRange> intensitiesPerChannel = new HashMap<String, IntensityRange>();
    private final Listener<BaseEvent> selectionChangeListener = new Listener<BaseEvent>(){

        public void handleEvent(BaseEvent be) {
            ChannelChooserPanel.this.selectionChanged();
        }
    };
    private final Listener<BaseEvent> transformationSelection = new Listener<BaseEvent>(){

        public void handleEvent(BaseEvent be) {
            List<LabeledItem<String>> channelCodes = ChannelChooserPanel.this.getSelectedLabeledValues();
            InternalImageTransformationInfo selectedTransformation = (InternalImageTransformationInfo)((LabeledItem)ChannelChooserPanel.this.transformationsComboBox.getSimpleValue()).getItem();
            String transformationCode = selectedTransformation.getCode();
            ChannelChooserPanel.this.defaultChannelState.setDefaultTransformation(ChannelChooserPanel.getChannelCode(channelCodes), transformationCode);
            ChannelChooserPanel.this.changeTransformationSettingsButtonVisibility(true, false);
            HashMap<String, IntensityRange> intensityRanges = new HashMap<String, IntensityRange>();
            for (LabeledItem<String> channelCode : channelCodes) {
                intensityRanges.put((String)channelCode.getItem(), ChannelChooserPanel.this.defaultChannelState.tryGetIntensityRange((String)channelCode.getItem()));
            }
            ChannelChooserPanel.this.notifySelectionListeners(ChannelChooserPanel.this.getSelectedValues(), ChannelChooserPanel.this.tryGetSelectedTransformationCode(false), intensityRanges);
            String updatedTooltip = selectedTransformation.getLabel();
            if ("$USER_DEFINED_RESCALING$".equalsIgnoreCase(transformationCode)) {
                for (Map.Entry rangeEntry : intensityRanges.entrySet()) {
                    IntensityRange intensityRange = (IntensityRange)rangeEntry.getValue();
                    updatedTooltip = intensityRanges.size() == 1 ? updatedTooltip + " [" + (intensityRange == null ? "undefined" : intensityRange.getBlackPoint() + " - " + intensityRange.getWhitePoint()) + "]" : updatedTooltip + " " + (String)rangeEntry.getKey() + "=[" + (intensityRange == null ? "undefined" : intensityRange.getBlackPoint() + " - " + intensityRange.getWhitePoint()) + "];";
                    ChannelChooserPanel.this.intensitiesPerChannel.put((String)rangeEntry.getKey(), intensityRange);
                }
            }
            ChannelChooserPanel.this.transformationsComboBox.setToolTip(updatedTooltip);
        }
    };

    public ChannelChooserPanel(IMessageProvider messageProvider, IDefaultChannelState defChannelState) {
        this(messageProvider, defChannelState, Collections.emptyList(), null);
    }

    public ChannelChooserPanel(final IMessageProvider messageProvider, IDefaultChannelState defChannelState, List<String> selectedChannelsOrNull, ImageDatasetParameters imageDatasetParameters) {
        this.messageProvider = messageProvider;
        this.defaultChannelState = defChannelState;
        this.setAutoHeight(true);
        this.setAutoWidth(true);
        this.channelsComboBox = this.createChannelsComboBox();
        this.transformationsComboBox = new SimpleModelComboBox(this.messageProvider, new ArrayList(), null);
        this.transformationsComboBox.addListener(Events.SelectionChange, this.transformationSelection);
        ComboBoxGroup group = new ComboBoxGroup();
        group.add((Field)this.channelsComboBox);
        group.add((Field)this.adjustLabel);
        group.add((Field)this.transformationsComboBox);
        group.add((Field)this.userDefinedTransformationSettingsButtonField);
        this.userDefinedTransformationSettingsButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                UserDefinedRescalingSettingsDialog dialog = new UserDefinedRescalingSettingsDialog(messageProvider, ChannelChooserPanel.this.intensitiesPerChannel, ChannelChooserPanel.this.defaultChannelState, ChannelChooserPanel.this.getSelectedLabeledValues());
                dialog.addListener(Events.OnChange, ChannelChooserPanel.this.transformationSelection);
                dialog.show();
            }
        });
        this.add((Component)group);
        this.channelsCheckBoxGroup = this.createCheckBoxGroup();
        this.add((Component)this.channelsCheckBoxGroup);
        this.addChannels(imageDatasetParameters);
        this.updateChannelSelection(selectedChannelsOrNull);
    }

    private static final String getChannelCode(List<LabeledItem<String>> selection) {
        if (selection.size() == 1) {
            return (String)selection.get(0).getItem();
        }
        return "Merged Channels";
    }

    private SimpleModelComboBox<String> createChannelsComboBox() {
        SimpleModelComboBox comboBox = new SimpleModelComboBox(this.messageProvider, new ArrayList(), null);
        comboBox.addListener(Events.SelectionChange, this.selectionChangeListener);
        return comboBox;
    }

    private CheckBoxGroup createCheckBoxGroup() {
        CheckBoxGroup group = new CheckBoxGroup();
        return group;
    }

    public void addSelectionChangedListener(ChannelSelectionListener selectionListener) {
        this.channelSelectionListeners.add(selectionListener);
    }

    public void addChannels(ImageDatasetParameters imageParameters) {
        this.addChannelsForParameters(imageParameters);
        this.updateChannelSelection(null);
    }

    public List<String> getSelectedValues() {
        String comboBoxValue = (String)this.channelsComboBox.tryGetChosenItem();
        if (comboBoxValue == null) {
            return Collections.emptyList();
        }
        if ("Merged Channels".equals(comboBoxValue)) {
            return this.getMergedChannelSelection();
        }
        return Collections.singletonList(comboBoxValue);
    }

    private List<String> getMergedChannelSelection() {
        boolean allSelected = true;
        ArrayList<String> channels = new ArrayList<String>();
        for (CheckBox cb : this.getAllCheckBoxes()) {
            if (cb.getValue().booleanValue()) {
                channels.add(cb.getValueAttribute());
                continue;
            }
            allSelected = false;
        }
        if (allSelected) {
            return Collections.singletonList("Merged Channels");
        }
        return channels;
    }

    public List<LabeledItem<String>> getSelectedLabeledValues() {
        LabeledItem comboBoxValue = this.channelsComboBox.getSelectedIndex() == -1 ? null : (LabeledItem)this.channelsComboBox.getSimpleValue();
        if (comboBoxValue == null) {
            return Collections.emptyList();
        }
        if ("Merged Channels".equals(comboBoxValue.getItem())) {
            return this.getMergedChannelLabeledSelection();
        }
        return Collections.singletonList(comboBoxValue);
    }

    private List<LabeledItem<String>> getMergedChannelLabeledSelection() {
        ArrayList<LabeledItem<String>> channels = new ArrayList<LabeledItem<String>>();
        for (CheckBox cb : this.getAllCheckBoxes()) {
            if (!cb.getValue().booleanValue()) continue;
            channels.add((LabeledItem<String>)new LabeledItem((Object)cb.getValueAttribute(), cb.getBoxLabel()));
        }
        return channels;
    }

    public void addChannelsForParameters(ImageDatasetParameters imageParameters) {
        this.addChannelToComboBox((LabeledItem<String>)new LabeledItem((Object)"Merged Channels", "Merged Channels"));
        List<LabeledItem<String>> channels = this.extractLabeledChannels(imageParameters);
        if (channels == null || channels.isEmpty()) {
            return;
        }
        ArrayList<CheckBox> newCheckBoxes = new ArrayList<CheckBox>();
        for (LabeledItem<String> channel : channels) {
            boolean codeAdded = this.addChannelToComboBox(channel);
            String code = (String)channel.getItem();
            Set<InternalImageTransformationInfo> transformationsForChannel = this.transformationsForChannels.get(code);
            if (transformationsForChannel == null) {
                transformationsForChannel = new LinkedHashSet<InternalImageTransformationInfo>();
                this.transformationsForChannels.put(code, transformationsForChannel);
            }
            transformationsForChannel.addAll(imageParameters.getAvailableImageTransformationsFor(code));
            this.intensitiesPerChannel.put(code, this.defaultChannelState.tryGetIntensityRange(code));
            if (!codeAdded) continue;
            CheckBox checkBox = new CheckBox();
            checkBox.setBoxLabel(channel.getLabel());
            checkBox.setValueAttribute((String)channel.getItem());
            checkBox.addListener(Events.Change, this.selectionChangeListener);
            newCheckBoxes.add(checkBox);
        }
        this.updateCheckBoxGroup(newCheckBoxes);
    }

    private List<LabeledItem<String>> extractLabeledChannels(ImageDatasetParameters imageParameters) {
        if (imageParameters == null || imageParameters.getChannelsNumber() == 0) {
            return Collections.emptyList();
        }
        List<String> codes = imageParameters.getChannelsCodes();
        List<String> labels = imageParameters.getChannelsLabels();
        ArrayList<LabeledItem<String>> result = new ArrayList<LabeledItem<String>>();
        for (int i = 0; i < codes.size(); ++i) {
            String code;
            String label = code = codes.get(i);
            if (i < labels.size() && !StringUtils.isBlank((String)labels.get(i))) {
                label = labels.get(i);
            }
            result.add((LabeledItem<String>)new LabeledItem((Object)code, label));
        }
        return result;
    }

    private boolean addChannelToComboBox(LabeledItem<String> channel) {
        if (this.channelsComboBox.findModelForVal((Object)((String)channel.getItem())) == null) {
            this.channelsComboBox.add(channel);
            return true;
        }
        return false;
    }

    public void updateChannelSelection(List<String> selectedChannels) {
        List<String> channels = selectedChannels;
        if ((channels == null || channels.size() == 0) && this.defaultChannelState != null) {
            channels = this.defaultChannelState.tryGetDefaultChannels();
        }
        String codeToSelect = "Merged Channels";
        if (channels != null && channels.size() == 1) {
            codeToSelect = channels.get(0);
        }
        LabeledItem itemToSelect = this.channelsComboBox.findModelForVal((Object)codeToSelect);
        this.channelsComboBox.setSelection(itemToSelect);
        this.initializeCheckBoxValues(channels);
        this.updateTransformationComboBox();
    }

    private void initializeCheckBoxValues(List<String> selectedChannels) {
        boolean selectAllChannels = selectedChannels == null || selectedChannels.size() < 2;
        for (CheckBox cb : this.getAllCheckBoxes()) {
            boolean checked = selectAllChannels || selectedChannels.contains(cb.getValueAttribute());
            cb.setValue(Boolean.valueOf(checked));
        }
    }

    private void selectionChanged() {
        List<String> selection = this.getSelectedValues();
        this.defaultChannelState.setDefaultChannels(selection);
        String selectedComboValue = (String)this.channelsComboBox.tryGetChosenItem();
        boolean showCheckBoxGroup = "Merged Channels".equals(selectedComboValue);
        this.channelsCheckBoxGroup.setVisible(showCheckBoxGroup);
        this.ensureAtLeastOneCheckboxChecked();
        this.updateTransformationComboBox();
        this.notifySelectionListeners(selection, this.tryGetSelectedTransformationCode(false), this.tryGetSelectedIntensityRanges());
    }

    public String tryGetSelectedTransformationCode(boolean force) {
        String code = null;
        if (force || this.transformationsComboBox.isVisible(false)) {
            code = ((InternalImageTransformationInfo)((LabeledItem)((SimpleComboValue)this.transformationsComboBox.getSelection().get(0)).getValue()).getItem()).getCode();
        } else if (this.transformationsComboBox.getStore().getModels().size() == 1) {
            code = ((InternalImageTransformationInfo)((LabeledItem)((SimpleComboValue)this.transformationsComboBox.getStore().getModels().get(0)).getValue()).getItem()).getCode();
        }
        return ChannelChooserPanel.transformCode(code);
    }

    public Map<String, IntensityRange> tryGetSelectedIntensityRanges() {
        List<LabeledItem<String>> selectedValues = this.getSelectedLabeledValues();
        if (selectedValues != null) {
            HashMap<String, IntensityRange> ranges = new HashMap<String, IntensityRange>();
            for (LabeledItem<String> channelCode : selectedValues) {
                ranges.put((String)channelCode.getItem(), this.intensitiesPerChannel.get(channelCode.getItem()));
            }
            return ranges;
        }
        return null;
    }

    private static String transformCode(String code) {
        if (code == null || DEFAULT_TRANSFORMATION_CODE.equals(code)) {
            return null;
        }
        return code;
    }

    private void notifySelectionListeners(List<String> selection, String imageTransformationCodeOrNull, Map<String, IntensityRange> rangesOrNull) {
        for (ChannelSelectionListener listener : this.channelSelectionListeners) {
            listener.selectionChanged(selection, imageTransformationCodeOrNull, rangesOrNull);
        }
    }

    private void updateCheckBoxGroup(List<CheckBox> newCheckBoxes) {
        if (newCheckBoxes.isEmpty()) {
            return;
        }
        boolean recreateCheckBoxGroup = this.channelsCheckBoxGroup.isRendered();
        if (recreateCheckBoxGroup) {
            newCheckBoxes.addAll(0, this.getAllCheckBoxes());
            this.remove((Component)this.channelsCheckBoxGroup);
            this.channelsCheckBoxGroup = this.createCheckBoxGroup();
        }
        for (CheckBox cb : newCheckBoxes) {
            this.channelsCheckBoxGroup.add((Field)cb);
        }
        if (recreateCheckBoxGroup) {
            this.add((Component)this.channelsCheckBoxGroup);
            this.layout(true);
        }
    }

    private void ensureAtLeastOneCheckboxChecked() {
        List<CheckBox> checkboxes = this.getAllCheckBoxes();
        int selected = 0;
        for (CheckBox cb : checkboxes) {
            if (!cb.getValue().booleanValue()) continue;
            ++selected;
        }
        if (selected > 1) {
            for (CheckBox cb : checkboxes) {
                cb.setEnabled(true);
            }
        } else {
            for (CheckBox cb : checkboxes) {
                if (!cb.getValue().booleanValue()) continue;
                cb.setEnabled(false);
            }
        }
    }

    private List<CheckBox> getAllCheckBoxes() {
        ArrayList<CheckBox> result = new ArrayList<CheckBox>();
        for (Field field : this.channelsCheckBoxGroup.getAll()) {
            if (!(field instanceof CheckBox)) continue;
            result.add((CheckBox)field);
        }
        return result;
    }

    private void updateTransformationComboBox() {
        List<String> selectedValues = this.getSelectedValues();
        this.transformationsComboBox.removeAll();
        this.transformationsComboBox.clearState();
        ArrayList<LabeledItem<InternalImageTransformationInfo>> model = new ArrayList<LabeledItem<InternalImageTransformationInfo>>();
        Set<InternalImageTransformationInfo> infos = null;
        if (selectedValues.size() == 1 && (infos = this.transformationsForChannels.get(selectedValues.get(0))) != null && infos.size() > 0) {
            if (!ChannelChooserPanel.isDefaultTransformationDefined(infos)) {
                model.add(DEFAULT_TRANSFORMATION);
            }
            for (InternalImageTransformationInfo imageTransformationInfo : infos) {
                model.add(ChannelChooserPanel.convertToLabeledItem(imageTransformationInfo));
            }
            if (model.size() <= 1) {
                this.transformationsComboBox.setVisible(false);
                this.adjustLabel.setVisible(false);
                this.userDefinedTransformationSettingsButtonField.setVisible(false);
                return;
            }
            this.transformationsComboBox.add(model);
            this.selectTransformation(selectedValues.get(0));
            this.setTransformationsVisible(true);
        } else if (selectedValues.size() > 0) {
            model.add(DEFAULT_TRANSFORMATION);
            model.add(ChannelChooserPanel.convertToLabeledItem(new InternalImageTransformationInfo("$USER_DEFINED_RESCALING$", "User defined", "User defined intensity rescaling", "", false)));
            this.transformationsComboBox.add(model);
            this.selectTransformation("Merged Channels");
            this.setTransformationsVisible(true);
        } else {
            this.setTransformationsVisible(false);
        }
    }

    private void changeTransformationSettingsButtonVisibility(boolean visible, boolean force) {
        if (visible && "$USER_DEFINED_RESCALING$".equals(this.tryGetSelectedTransformationCode(force))) {
            this.userDefinedTransformationSettingsButtonField.setVisible(true);
        } else {
            this.userDefinedTransformationSettingsButtonField.setVisible(false);
        }
    }

    private static boolean isDefaultTransformationDefined(Set<InternalImageTransformationInfo> infos) {
        for (InternalImageTransformationInfo imageTransformationInfo : infos) {
            if (!imageTransformationInfo.isDefault()) continue;
            return true;
        }
        return false;
    }

    private void setTransformationsVisible(boolean visible) {
        this.transformationsComboBox.setVisible(visible);
        this.adjustLabel.setVisible(visible);
        this.changeTransformationSettingsButtonVisibility(visible, true);
    }

    private void selectTransformation(String channelCode) {
        SimpleModelComboBox<InternalImageTransformationInfo> combobox;
        boolean selected = false;
        String code = this.defaultChannelState.tryGetDefaultTransformation(channelCode);
        selected = this.setSelectedValue(code, combobox = this.transformationsComboBox);
        if (!selected) {
            for (SimpleComboValue info : this.transformationsComboBox.getStore().getModels()) {
                if (!((InternalImageTransformationInfo)((LabeledItem)info.getValue()).getItem()).isDefault()) continue;
                this.transformationsComboBox.setSelection(Collections.singletonList(info));
                selected = true;
                break;
            }
        }
        if (!selected) {
            this.transformationsComboBox.setSelection(Collections.singletonList((SimpleComboValue)this.transformationsComboBox.getStore().getModels().get(0)));
        }
        this.changeTransformationSettingsButtonVisibility(true, true);
    }

    private boolean setSelectedValue(String code, SimpleModelComboBox<InternalImageTransformationInfo> combobox) {
        if (code != null) {
            for (SimpleComboValue info : combobox.getStore().getModels()) {
                if (!((InternalImageTransformationInfo)((LabeledItem)info.getValue()).getItem()).getCode().equals(code)) continue;
                combobox.setSelection(Collections.singletonList(info));
                return true;
            }
        }
        return false;
    }

    private static LabeledItem<InternalImageTransformationInfo> convertToLabeledItem(InternalImageTransformationInfo imageTransformationInfo) {
        return new LabeledItem((Object)imageTransformationInfo, imageTransformationInfo.getLabel(), imageTransformationInfo.getDescription());
    }

    public static interface ChannelSelectionListener {
        public void selectionChanged(List<String> var1, String var2, Map<String, IntensityRange> var3);
    }

    private static class ComboBoxGroup
    extends MultiField<Widget> {
        private ComboBoxGroup() {
            this.setSpacing(5);
        }
    }
}

