/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplaySettingsManager;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.IDefaultChannelState;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import java.util.List;
import java.util.Map;

public class DefaultChannelState
implements IDefaultChannelState {
    private IViewContext<?> viewContext;
    private String displayTypeId;

    public DefaultChannelState(IViewContext<?> viewContext, String displayTypeId) {
        this.viewContext = viewContext;
        this.displayTypeId = displayTypeId;
    }

    @Override
    public void setDefaultChannels(List<String> channels) {
        this.getDisplaySettingManager().setDefaultChannels(this.displayTypeId, channels);
    }

    @Override
    public List<String> tryGetDefaultChannels() {
        return this.getDisplaySettingManager().tryGetDefaultChannels(this.displayTypeId);
    }

    private ScreeningDisplaySettingsManager getDisplaySettingManager() {
        return ScreeningViewContext.getTechnologySpecificDisplaySettingsManager(this.viewContext);
    }

    @Override
    public void setDefaultTransformation(String channel, String codes) {
        this.getTransformations().put(channel, codes);
    }

    @Override
    public String tryGetDefaultTransformation(String channel) {
        return this.getTransformations().get(channel);
    }

    private Map<String, String> getTransformations() {
        return this.getDisplaySettingManager().getDefaultTransformationsForChannels(this.displayTypeId);
    }

    @Override
    public ImageResolution tryGetDefaultResolution(String windowId) {
        return this.getDisplaySettingManager().getDefaultResolution(this.displayTypeId + windowId);
    }

    @Override
    public void setDefaultResolution(ImageResolution resolution, String windowId) {
        this.getDisplaySettingManager().setDefaultResolution(this.displayTypeId + windowId, resolution);
    }

    @Override
    public void setIntensityRange(String channel, IntensityRange intensityRange) {
        this.getIntensityRange().put(channel, intensityRange);
    }

    @Override
    public IntensityRange tryGetIntensityRange(String channel) {
        return this.getIntensityRange().get(channel);
    }

    private Map<String, IntensityRange> getIntensityRange() {
        return this.getDisplaySettingManager().getIntensityRangesForChannels(this.displayTypeId);
    }
}

