/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ExperimentAnalysisSummaryGrid;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.MaterialComponentUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ExperimentAnalysisSummaryViewer {
    public static void openTab(final IViewContext<IScreeningClientServiceAsync> screeningViewContext, String experimentPermId, final boolean restrictGlobalScopeLinkToProject, final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        screeningViewContext.getCommonService().getEntityInformationHolder(EntityKind.EXPERIMENT, experimentPermId, (AsyncCallback)new AbstractAsyncCallback<IEntityInformationHolderWithPermId>(screeningViewContext){

            protected void process(IEntityInformationHolderWithPermId experiment) {
                TechId experimentId = new TechId((IIdAndCodeHolder)experiment);
                ExperimentAnalysisSummaryViewer.openTab((IViewContext<IScreeningClientServiceAsync>)screeningViewContext, experimentId, restrictGlobalScopeLinkToProject, analysisProcedureCriteria);
            }
        });
    }

    public static void openTab(final IViewContext<IScreeningClientServiceAsync> screeningViewContext, TechId experimentId, final boolean restrictGlobalScopeLinkToProject, final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        screeningViewContext.getCommonService().getExperimentInfo(experimentId, (AsyncCallback)new AbstractAsyncCallback<Experiment>(screeningViewContext){

            protected void process(Experiment result) {
                AbstractTabItemFactory factory = ExperimentAnalysisSummaryViewer.createTabFactory((IViewContext<IScreeningClientServiceAsync>)screeningViewContext, (IEntityInformationHolderWithProperties)result, restrictGlobalScopeLinkToProject, analysisProcedureCriteria);
                DispatcherHelper.dispatchNaviEvent((AbstractTabItemFactory)factory);
            }
        });
    }

    private static AbstractTabItemFactory createTabFactory(final IViewContext<IScreeningClientServiceAsync> viewContext, final IEntityInformationHolderWithProperties experiment, final boolean restrictGlobalScopeLinkToProject, final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        return new AbstractTabItemFactory(){

            public String getId() {
                return "openbis_-screening-FEATURE_VECTOR_SUMMARY" + experiment.getCode();
            }

            public ITabItem create() {
                IDisposableComponent tabComponent = ExperimentAnalysisSummaryViewer.createViewer((IViewContext<IScreeningClientServiceAsync>)viewContext, experiment, restrictGlobalScopeLinkToProject, analysisProcedureCriteria);
                return DefaultTabItem.create((String)this.getTabTitle(), (IDisposableComponent)tabComponent, (IViewContext)viewContext);
            }

            public String tryGetLink() {
                return ScreeningLinkExtractor.createExperimentAnalysisSummaryBrowserLink(experiment.getPermId(), restrictGlobalScopeLinkToProject, analysisProcedureCriteria.tryGetAnalysisProcedureCode());
            }

            public String getTabTitle() {
                return "Analysis Summary " + experiment.getCode();
            }

            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.VIEW);
            }
        };
    }

    private static IDisposableComponent createViewer(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithProperties experiment, boolean restrictGlobalScopeLinkToProject, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        String headingText = viewContext.getMessage("ASSAY_HEADER", new Object[]{experiment.getCode()});
        IDisposableComponent gridComponent = ExperimentAnalysisSummaryGrid.create(viewContext, (IEntityInformationHolderWithIdentifier)experiment, restrictGlobalScopeLinkToProject, analysisProcedureCriteria);
        return MaterialComponentUtils.createExperimentViewer(viewContext, experiment, headingText, gridComponent);
    }
}

