/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleViewer;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImageSampleSection;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;

public final class ImageSampleViewer
extends GenericSampleViewer {
    private final ScreeningViewContext screeningViewContext;
    private final WellLocation wellLocationOrNull;
    private final boolean isWell;

    public static DatabaseModificationAwareComponent create(ScreeningViewContext viewContext, IIdAndCodeHolder identifiable, WellLocation wellLocationOrNull, boolean isWellSample) {
        ImageSampleViewer viewer = new ImageSampleViewer(viewContext, identifiable, wellLocationOrNull, isWellSample);
        viewer.reloadAllData();
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    private ImageSampleViewer(ScreeningViewContext viewContext, IIdAndCodeHolder identifiable, WellLocation wellLocationOrNull, boolean isWellSample) {
        super((IViewContext)viewContext, identifiable);
        this.screeningViewContext = viewContext;
        this.isWell = isWellSample;
        this.wellLocationOrNull = isWellSample ? (isWellSample ? WellLocation.tryParseLocationStr(ImageSampleViewer.getWellCode(identifiable)) : null) : wellLocationOrNull;
    }

    private static String getWellCode(IIdAndCodeHolder identifiable) {
        String code = identifiable.getCode();
        int colon = code.indexOf(":");
        if (colon != -1) {
            return code.substring(colon + 1);
        }
        return code;
    }

    protected void loadSampleGenerationInfo(TechId sampleTechId, AsyncCallback<SampleParentWithDerived> asyncCallback) {
        ((IScreeningClientServiceAsync)this.screeningViewContext.getService()).getSampleGenerationInfo(sampleTechId, asyncCallback);
    }

    protected List<TabContent> createAdditionalSectionPanels() {
        ArrayList<TabContent> sections = new ArrayList<TabContent>();
        sections.add(new ImageSampleSection(this.screeningViewContext, this.sampleId, this.wellLocationOrNull, this.isWell));
        return sections;
    }

    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_well", new Object[0]);
    }
}

