/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleModelComboBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.EntityTypeLabelUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.utils.GuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ImagingDatasetGuiUtils {
    private static final String UNKNOWN_DATASETS_LABEL = "Other connected datasets:";
    private static final String LABEL_WIDTH_PX = "160";
    private static final int DATASET_COMBOBOX_CHOOSER_WIDTH_PX = 350;
    private final IViewContext<?> viewContext;

    public ImagingDatasetGuiUtils(IViewContext<?> viewContext) {
        this.viewContext = viewContext;
    }

    public final Widget tryCreateUnknownDatasetsLinks(List<DatasetReference> unknownDatasets) {
        if (unknownDatasets.isEmpty()) {
            return null;
        }
        LayoutContainer c = new LayoutContainer();
        c.setLayout((Layout)new RowLayout());
        c.add((Widget)new Text(UNKNOWN_DATASETS_LABEL));
        for (DatasetReference dataset : unknownDatasets) {
            String label = EntityTypeLabelUtils.createDatasetLabel(dataset, true, null, true);
            Widget detailsLink = ImagingDatasetGuiUtils.createDatasetDetailsLink(dataset, label, this.viewContext);
            c.add((Widget)ImagingDatasetGuiUtils.warpInTable(detailsLink));
        }
        return c;
    }

    private static LayoutContainer warpInTable(Widget detailsLink) {
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new TableLayout(1));
        container.add(detailsLink);
        return container;
    }

    public Widget createFeatureVectorDatasetDetailsRow(List<DatasetReference> featureVectorDatasets, IFeatureVectorDatasetReferenceUpdater datasetUpdater) {
        return ImageAnalysisDatasetDetails.createFeatureVectorDatasetDetailsRow(featureVectorDatasets, datasetUpdater, this.viewContext);
    }

    public final Widget createImageDatasetDetailsRow(List<ImageDatasetEnrichedReference> imageDatasets, IDatasetImagesReferenceUpdater datasetUpdater) {
        return ImageDatasetDetails.createImageDatasetDetailsRow(imageDatasets, datasetUpdater, this.viewContext);
    }

    private static Widget createDatasetDetailsLink(final DatasetReference dataset, String label, final IViewContext<?> viewContext) {
        String href = LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)dataset);
        assert (href != null) : "invalid link for " + dataset;
        ClickHandler listener = new ClickHandler(){

            public void onClick(ClickEvent event) {
                ImagingDatasetGuiUtils.openDatasetDetails(dataset, viewContext);
            }
        };
        return LinkRenderer.getLinkWidget((String)label, (ClickHandler)listener, (String)href);
    }

    private static void openDatasetDetails(DatasetReference selectedDatasetReference, IViewContext<?> viewContext) {
        new OpenEntityDetailsTabAction((IEntityInformationHolderWithPermId)selectedDatasetReference, viewContext).execute();
    }

    static Widget withLabel(Widget widet, String label) {
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new TableLayout(2));
        Text labelWidget = new Text(label);
        labelWidget.setWidth(LABEL_WIDTH_PX);
        container.add((Widget)labelWidget);
        container.add(widet);
        return container;
    }

    private static List<DatasetReference> asReferences(List<ImageDatasetEnrichedReference> imageDatasets) {
        ArrayList<DatasetReference> refs = new ArrayList<DatasetReference>();
        for (ImageDatasetEnrichedReference dataset : imageDatasets) {
            refs.add(dataset.getImageDataset().getDatasetReference());
        }
        return refs;
    }

    static <T> SimpleModelComboBox<T> createDatasetChooserComboBox(IMessageProvider messageProvider, List<T> items, List<String> labels, List<String> tooltips) {
        return new SimpleModelComboBox(messageProvider, items, labels, tooltips, Integer.valueOf(350));
    }

    private static final class ImageDatasetDetails {
        private static final String IMAGES_DATASET_CHOOSER_LABEL = "Images acquired on: ";
        private static final String SINGLE_IMAGE_DATASET_DETAILS_LABEL = "Image acquisition details: ";
        private static final String SHOW_CHOSEN_IMAGE_DATASET_DETAILS_BUTTON = "Advanced";
        private static final String NO_IMAGES_DATASET_LABEL = "No images data has been acquired.";
        private final IViewContext<?> viewContext;

        public static Widget createImageDatasetDetailsRow(List<ImageDatasetEnrichedReference> imageDatasets, IDatasetImagesReferenceUpdater datasetUpdater, IViewContext<?> viewContext) {
            return new ImageDatasetDetails(viewContext).createImageDatasetDetailsRow(imageDatasets, datasetUpdater);
        }

        private ImageDatasetDetails(IViewContext<?> viewContext) {
            this.viewContext = viewContext;
        }

        private final Widget createImageDatasetDetailsRow(List<ImageDatasetEnrichedReference> imageDatasets, IDatasetImagesReferenceUpdater datasetUpdater) {
            if (imageDatasets.size() == 0) {
                return new Text(NO_IMAGES_DATASET_LABEL);
            }
            if (imageDatasets.size() == 1) {
                ImageDatasetEnrichedReference imageDataset = imageDatasets.get(0);
                return this.createAndConnectImageDatasetInfo(imageDataset, datasetUpdater);
            }
            return this.createAndConnectImageDatasetChooser(imageDatasets, datasetUpdater);
        }

        private Widget createAndConnectImageDatasetInfo(ImageDatasetEnrichedReference imageDataset, IDatasetImagesReferenceUpdater datasetUpdater) {
            Widget datasetDetailsButton = ImagingDatasetGuiUtils.createDatasetDetailsLink(imageDataset.getImageDataset().getDatasetReference(), SHOW_CHOSEN_IMAGE_DATASET_DETAILS_BUTTON, this.viewContext);
            Widget imageDatasetDetailsRow = ImagingDatasetGuiUtils.withLabel(datasetDetailsButton, SINGLE_IMAGE_DATASET_DETAILS_LABEL);
            datasetUpdater.changeDisplayedImageDataset(imageDataset);
            return imageDatasetDetailsRow;
        }

        private Widget createAndConnectImageDatasetChooser(List<ImageDatasetEnrichedReference> imageDatasets, final IDatasetImagesReferenceUpdater datasetUpdater) {
            List<String> labels = EntityTypeLabelUtils.createDatasetLabels(ImagingDatasetGuiUtils.asReferences(imageDatasets), true);
            final SimpleModelComboBox<ImageDatasetEnrichedReference> datasetChooser = ImagingDatasetGuiUtils.createDatasetChooserComboBox(this.viewContext, imageDatasets, labels, labels);
            final Anchor datasetDetailsButton = this.createImageDetailsButton(datasetChooser);
            datasetChooser.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SimpleComboValue<LabeledItem<ImageDatasetEnrichedReference>>>(){

                public void selectionChanged(SelectionChangedEvent<SimpleComboValue<LabeledItem<ImageDatasetEnrichedReference>>> se) {
                    ImageDatasetEnrichedReference chosenDataset = (ImageDatasetEnrichedReference)SimpleModelComboBox.getChosenItem(se);
                    datasetUpdater.changeDisplayedImageDataset(chosenDataset);
                    this.updateImageDatasetSimpleViewModeLink((SimpleModelComboBox<ImageDatasetEnrichedReference>)datasetChooser, datasetDetailsButton);
                }
            });
            ImageDatasetEnrichedReference chosenDataset = (ImageDatasetEnrichedReference)datasetChooser.tryGetChosenItem();
            datasetUpdater.changeDisplayedImageDataset(chosenDataset);
            return GuiUtils.renderInRow(new Widget[]{ImagingDatasetGuiUtils.withLabel(datasetChooser, IMAGES_DATASET_CHOOSER_LABEL), datasetDetailsButton});
        }

        private Anchor createImageDetailsButton(final SimpleModelComboBox<ImageDatasetEnrichedReference> imageDatasetChooser) {
            return LinkRenderer.getLinkAnchor((String)SHOW_CHOSEN_IMAGE_DATASET_DETAILS_BUTTON, (ClickHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ImagingDatasetGuiUtils.openDatasetDetails(ImageDatasetDetails.getChosenDatasetReference((SimpleModelComboBox<ImageDatasetEnrichedReference>)imageDatasetChooser), viewContext);
                }
            }, (String)ImageDatasetDetails.createImageDatasetSimpleViewModeHref(imageDatasetChooser));
        }

        private void updateImageDatasetSimpleViewModeLink(SimpleModelComboBox<ImageDatasetEnrichedReference> imageDatasetChooser, Anchor anchor) {
            if (this.viewContext.isSimpleOrEmbeddedMode()) {
                anchor.setHref("#" + ImageDatasetDetails.createImageDatasetSimpleViewModeHref(imageDatasetChooser));
            }
        }

        private static String createImageDatasetSimpleViewModeHref(SimpleModelComboBox<ImageDatasetEnrichedReference> imageDatasetChooser) {
            return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)ImageDatasetDetails.getChosenDatasetReference(imageDatasetChooser));
        }

        private static DatasetReference getChosenDatasetReference(SimpleModelComboBox<ImageDatasetEnrichedReference> imageDatasetChooser) {
            return ((ImageDatasetEnrichedReference)imageDatasetChooser.tryGetChosenItem()).getImageDataset().getDatasetReference();
        }
    }

    private static final class ImageAnalysisDatasetDetails {
        private static final String SHOW_CHOSEN_ANALYSIS_DATASET_BUTTON = "Show Report";
        private static final String NO_IMAGE_ANALYSIS_DATASET_LABEL = "No image analysis data is available.";
        private static final String IMAGE_ANALYSIS_DATASET_CHOOSER_LABEL = "Images analysis results: ";
        private final IViewContext<?> viewContext;

        public static Widget createFeatureVectorDatasetDetailsRow(List<DatasetReference> featureVectorDatasets, IFeatureVectorDatasetReferenceUpdater datasetUpdater, IViewContext<?> viewContext) {
            return new ImageAnalysisDatasetDetails(viewContext).createFeatureVectorDatasetDetailsRow(featureVectorDatasets, datasetUpdater);
        }

        private ImageAnalysisDatasetDetails(IViewContext<?> viewContext) {
            this.viewContext = viewContext;
        }

        private Widget createFeatureVectorDatasetDetailsRow(List<DatasetReference> featureVectorDatasets, IFeatureVectorDatasetReferenceUpdater datasetUpdater) {
            if (featureVectorDatasets.size() == 0) {
                return new Text(NO_IMAGE_ANALYSIS_DATASET_LABEL);
            }
            if (featureVectorDatasets.size() == 1) {
                return this.createAndConnectFeatureVectorDatasetInfo(featureVectorDatasets.get(0), datasetUpdater);
            }
            return this.createAndConnectFeatureVectorDatasetChooser(featureVectorDatasets, datasetUpdater);
        }

        private Widget createAndConnectFeatureVectorDatasetChooser(List<DatasetReference> featureVectorDatasets, final IFeatureVectorDatasetReferenceUpdater datasetUpdater) {
            List<String> datasetLabels = this.getDatasetLabels(featureVectorDatasets);
            List<String> tooltips = this.getDatasetTooltips(featureVectorDatasets);
            final SimpleModelComboBox<DatasetReference> datasetChooser = ImagingDatasetGuiUtils.createDatasetChooserComboBox(this.viewContext, featureVectorDatasets, datasetLabels, tooltips);
            String defaultAnalysisProcedure = ScreeningViewContext.getTechnologySpecificDisplaySettingsManager(this.viewContext).getDefaultAnalysisProcedure();
            if (defaultAnalysisProcedure != null) {
                int index = -1;
                for (int i = 0; i < featureVectorDatasets.size(); ++i) {
                    if (!defaultAnalysisProcedure.equals(featureVectorDatasets.get(i).getAnalysisProcedure())) continue;
                    index = i;
                    break;
                }
                if (index > -1) {
                    datasetChooser.setSelection(Collections.singletonList((SimpleComboValue)datasetChooser.getStore().getAt(index)));
                }
            }
            final Anchor datasetDetailsButton = this.createImageAnalysisDetailsButton(datasetChooser);
            datasetChooser.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SimpleComboValue<LabeledItem<DatasetReference>>>(){

                public void selectionChanged(SelectionChangedEvent<SimpleComboValue<LabeledItem<DatasetReference>>> se) {
                    DatasetReference chosenDataset = (DatasetReference)SimpleModelComboBox.getChosenItem(se);
                    datasetUpdater.changeDisplayedFeatureVectorDataset((ScreeningViewContext)viewContext, chosenDataset);
                    this.updateFeatureVectorDatasetSimpleViewModeLink((SimpleModelComboBox<DatasetReference>)datasetChooser, datasetDetailsButton);
                    if (chosenDataset.getAnalysisProcedure() != null) {
                        ScreeningViewContext.getTechnologySpecificDisplaySettingsManager(viewContext).setDefaultAnalysisProcedure(chosenDataset.getAnalysisProcedure());
                    }
                }
            });
            DatasetReference chosenDataset = (DatasetReference)datasetChooser.tryGetChosenItem();
            datasetUpdater.changeDisplayedFeatureVectorDataset((ScreeningViewContext)this.viewContext, chosenDataset);
            return GuiUtils.renderInRow(new Widget[]{ImagingDatasetGuiUtils.withLabel(datasetChooser, IMAGE_ANALYSIS_DATASET_CHOOSER_LABEL), datasetDetailsButton});
        }

        private List<String> getDatasetTooltips(List<DatasetReference> featureVectorDatasets) {
            ArrayList<String> tooltips = new ArrayList<String>(featureVectorDatasets.size());
            for (DatasetReference reference : featureVectorDatasets) {
                StringBuilder sb = new StringBuilder();
                sb.append("Dataset Code: ").append(reference.getCode()).append("<BR/>");
                sb.append("Dataset Type: ").append(reference.getEntityType().getCode()).append("<BR/>");
                String fileTypeCode = reference.getFileTypeCode();
                fileTypeCode = fileTypeCode == null ? "none" : fileTypeCode;
                sb.append("File Type: ").append(fileTypeCode).append("<BR/>");
                sb.append("Registration Date: ").append(reference.getRegistrationDate()).append("<BR/>");
                if (reference.getAnalysisProcedure() != null) {
                    sb.append("Analysis Procedure: ").append(reference.getAnalysisProcedure()).append("<BR/>");
                }
                tooltips.add(sb.toString());
            }
            return tooltips;
        }

        private List<String> getDatasetLabels(List<DatasetReference> featureVectorDatasets) {
            List<String> datasetLabels = EntityTypeLabelUtils.createDatasetLabelsForFeatureVectors(featureVectorDatasets, false);
            return datasetLabels;
        }

        private Widget createAndConnectFeatureVectorDatasetInfo(DatasetReference featureVectorDataset, IFeatureVectorDatasetReferenceUpdater datasetUpdater) {
            ScreeningViewContext screeningViewContext = (ScreeningViewContext)this.viewContext;
            ((IScreeningClientServiceAsync)screeningViewContext.getService()).getFeatureVectorDataset(featureVectorDataset, null, this.createLoadFeatureCallback(screeningViewContext, datasetUpdater));
            Widget datasetDetailsLink = ImagingDatasetGuiUtils.createDatasetDetailsLink(featureVectorDataset, SHOW_CHOSEN_ANALYSIS_DATASET_BUTTON, this.viewContext);
            return ImagingDatasetGuiUtils.withLabel(datasetDetailsLink, IMAGE_ANALYSIS_DATASET_CHOOSER_LABEL);
        }

        private AsyncCallback<FeatureVectorDataset> createLoadFeatureCallback(ScreeningViewContext context, final IFeatureVectorDatasetReferenceUpdater datasetUpdater) {
            return new AbstractAsyncCallback<FeatureVectorDataset>((IViewContext)context){

                protected void process(FeatureVectorDataset featureVector) {
                    datasetUpdater.changeDisplayedFeatureVectorDataset(featureVector);
                }
            };
        }

        private Anchor createImageAnalysisDetailsButton(final SimpleModelComboBox<DatasetReference> datasetChooser) {
            return LinkRenderer.getLinkAnchor((String)SHOW_CHOSEN_ANALYSIS_DATASET_BUTTON, (ClickHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    DatasetReference datasetReference = (DatasetReference)datasetChooser.tryGetChosenItem();
                    ImagingDatasetGuiUtils.openDatasetDetails(datasetReference, viewContext);
                }
            }, (String)this.createDatasetSimpleViewModeHref(datasetChooser));
        }

        private void updateFeatureVectorDatasetSimpleViewModeLink(SimpleModelComboBox<DatasetReference> datasetChooser, Anchor anchor) {
            if (this.viewContext.isSimpleOrEmbeddedMode()) {
                anchor.setHref("#" + this.createDatasetSimpleViewModeHref(datasetChooser));
            }
        }

        private String createDatasetSimpleViewModeHref(SimpleModelComboBox<DatasetReference> datasetChooser) {
            return LinkExtractor.tryExtract((IEntityInformationHolderWithPermId)((IEntityInformationHolderWithPermId)datasetChooser.tryGetChosenItem()));
        }
    }

    protected static interface IDatasetImagesReferenceUpdater {
        public void changeDisplayedImageDataset(ImageDatasetEnrichedReference var1);
    }

    protected static interface IFeatureVectorDatasetReferenceUpdater {
        public void changeDisplayedFeatureVectorDataset(ScreeningViewContext var1, DatasetReference var2);

        public void changeDisplayedFeatureVectorDataset(FeatureVectorDataset var1);
    }
}

